/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpatch.sdk.server.callback;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tinkerpatch.sdk.a.e;
import com.tinkerpatch.sdk.a.g;
import com.tinkerpatch.sdk.server.a;
import com.tinkerpatch.sdk.server.c.b;
import com.tinkerpatch.sdk.server.callback.PatchRequestCallback;
import com.tinkerpatch.sdk.server.callback.RollbackCallBack;
import com.tinkerpatch.sdk.server.utils.e;
import java.io.File;

public class TinkerPatchRequestCallback
implements PatchRequestCallback {
    private static final String TAG = "Tinker.PatchRequestCallback";
    public static final String TINKER_DOWNLOAD_FAIL_TIMES = "tinker_download_fail";
    public static final int DOWNLOAD_FAIL_MAX_TIMES = 3;
    public static final int PATCH_MAX_RETRY_COUNT = 3;
    private static boolean rollbackOnScreenOff;
    private static RollbackCallBack rollbackCallBack;

    public static void setRollbackOnScreenOff(boolean bl) {
        rollbackOnScreenOff = bl;
    }

    public static void setPatchRollbackCallBack(RollbackCallBack rollbackCallBack) {
        TinkerPatchRequestCallback.rollbackCallBack = rollbackCallBack;
    }

    @Override
    public boolean beforePatchRequest() {
        Context context = b.d();
        Tinker tinker = Tinker.with(context);
        if (!com.tinkerpatch.sdk.a.a.a(context)) {
            TinkerLog.i(TAG, "TinkerPatchRequestCallback: beforePatchRequest return false, not connect to internet", new Object[0]);
            return false;
        }
        if (TinkerServiceInternals.isTinkerPatchServiceRunning(context)) {
            TinkerLog.i(TAG, "TinkerPatchRequestCallback: beforePatchRequest return false, tinker service is running", new Object[0]);
            return false;
        }
        if (!tinker.isMainProcess()) {
            TinkerLog.i(TAG, "TinkerPatchRequestCallback: beforePatchRequest return false, only request on the main process", new Object[0]);
            return false;
        }
        if (com.tinkerpatch.sdk.a.e.b()) {
            TinkerLog.e(TAG, "TinkerPatchRequestCallback: beforePatchRequest return false, is in ignore channel, current channel:%s", com.tinkerpatch.sdk.a.e.a());
            return false;
        }
        return true;
    }

    @Override
    public void onPatchRollback() {
        Object object = b.d();
        Tinker tinker = Tinker.with(object);
        if (!tinker.isTinkerLoaded()) {
            TinkerLog.w(TAG, "TinkerPatchRequestCallback: onPatchRollback, tinker is not loaded, just return", new Object[0]);
            return;
        }
        if (rollbackCallBack != null) {
            rollbackCallBack.onPatchRollback();
        }
        if (rollbackOnScreenOff) {
            TinkerLog.i(TAG, "tinker wait screen to clean patch and kill all process", new Object[0]);
            new e.b((Context)object, new e.a(){

                @Override
                public void onScreenOff() {
                    TinkerPatchRequestCallback.this.rollbackPatchDirectly();
                }
            });
        }
        object = tinker.getTinkerLoadResultIfPresent().currentVersion;
        object = new SharePatchInfo((String)object, "00000000000000000000000000000000", Build.FINGERPRINT);
        SharePatchInfo.rewritePatchInfoFileWithLock(tinker.getPatchInfoFile(), (SharePatchInfo)object, tinker.getPatchInfoLockFile());
    }

    @Override
    public void onPatchDownloadFail(Exception exception, Integer n, Integer n2) {
        TinkerLog.w(TAG, "TinkerPatchRequestCallback: onPatchDownloadFail: %s", exception.getMessage());
    }

    @Override
    public boolean onPatchUpgrade(File file, Integer n, Integer object) {
        TinkerLog.i(TAG, "TinkerPatchRequestCallback: onPatchUpgrade, file:%s, newVersion:%d, currentVersion:%d", file.getPath(), n, object);
        object = a.a();
        Context context = b.d();
        ShareSecurityCheck shareSecurityCheck = new ShareSecurityCheck(context);
        if (!shareSecurityCheck.verifyPatchMetaSignature(file)) {
            TinkerLog.e(TAG, "onPatchUpgrade, signature check failed. file: %s, version:%d", file.getPath(), n);
            if (this.increaseDownloadError(context)) {
                g.a().a(n, SharePatchFileUtil.getMD5(file));
                ((a)object).a(n, -1);
            }
            SharePatchFileUtil.safeDeleteFile(file);
            return false;
        }
        this.handleUpgradePatch(file, n);
        file = context.getSharedPreferences("patch_server_config", 0);
        file.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, 0).apply();
        return true;
    }

    @Override
    public void onPatchNeedNotUpgrade() {
        Object object = a.a();
        Context context = b.d();
        Object object2 = Tinker.with(context);
        Object object3 = g.a();
        String string = ((g)object3).g();
        object2 = ((Tinker)object2).getTinkerLoadResultIfPresent();
        if ((((TinkerLoadResult)object2).currentVersion == null || !string.equals(((TinkerLoadResult)object2).currentVersion)) && (Integer)(object2 = ((g)object3).c()) > 0 && ((File)(object = e.a(context, ((a)object).c(), String.valueOf(object2)))).exists() && ((File)object).isFile() && ((String)(object3 = SharePatchFileUtil.getMD5((File)object))).equals(string) && this.retryPendingPatch(context, (Integer)object2, (String)object3, (File)object)) {
            return;
        }
    }

    @Override
    public void onPatchSyncFail(Exception exception) {
        TinkerLog.i(TAG, "TinkerPatchRequestCallback onPatchSyncFail error: %s", exception.getMessage());
        TinkerLog.printErrStackTrace(TAG, exception, "onPatchSyncFail stack", new Object[0]);
    }

    @Override
    public void updatePatchConditions() {
        TinkerLog.i(TAG, "TinkerPatchRequestCallback: updatePatchConditions", new Object[0]);
        a a2 = a.a();
        Context context = b.d();
        a2.a("wifi", com.tinkerpatch.sdk.a.a.b(context) ? "1" : "0");
    }

    private boolean retryPendingPatch(Context context, Integer object, String string, File file) {
        g g2 = g.a();
        int n = g2.f() + 1;
        if (n < 3) {
            TinkerLog.d(TAG, "[beforePatchRequest] have pending patch to install, version: %d, patch:%s", object, file.getPath());
            object = g2;
            if (!((g)object).g().equals(string)) {
                TinkerLog.w("Tinker.VersionInfo", "increaseRetryTimes fail, current PatchMd5: %s, try increase md5: %s", ((g)object).g(), string);
            } else {
                ((g)object).a(((g)object).h(), ((g)object).i(), ((g)object).d(), ((g)object).c(), string, ((g)object).j(), ((g)object).e(), ((g)object).f() + 1);
            }
            TinkerInstaller.onReceiveUpgradePatch(context, file.getAbsolutePath());
            return true;
        }
        SharePatchFileUtil.safeDeleteFile(file);
        TinkerLog.d(TAG, "[beforePatchRequest] retry patch install more than %d times, version: %d, patch:%s", n, object, file.getPath());
        return false;
    }

    private void rollbackPatchDirectly() {
        Context context = b.d();
        Tinker tinker = Tinker.with(context);
        ShareTinkerInternals.killAllOtherProcess(context);
        tinker.cleanPatch();
        Process.killProcess((int)Process.myPid());
    }

    private void handleUpgradePatch(File file, Integer fileArray) {
        Object object = a.a();
        Context context = b.d();
        g g2 = g.a();
        ((a)object).a((Integer)fileArray);
        object = SharePatchFileUtil.getMD5(file);
        g2.a((Integer)fileArray, (String)object);
        fileArray = e.c(context).listFiles();
        if (fileArray != null) {
            object = file.getName();
            for (File file2 : fileArray) {
                String string = file2.getName();
                if (string.equals(object) || string.endsWith("_version.info") || string.equals("version.lock")) continue;
                SharePatchFileUtil.safeDeleteFile(file2);
            }
        }
        TinkerInstaller.onReceiveUpgradePatch(context, file.getAbsolutePath());
    }

    private boolean increaseDownloadError(Context context) {
        context = context.getSharedPreferences("patch_server_config", 0);
        int n = context.getInt(TINKER_DOWNLOAD_FAIL_TIMES, 0);
        TinkerLog.i(TAG, "TinkerPatchRequestCallback: increaseDownloadError, current count:%d", n);
        if (n >= 3) {
            context.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, 0).commit();
            return true;
        }
        context.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, ++n).commit();
        return false;
    }
}

