/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import com.tencent.tinker.loader.TinkerRuntimeException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;

public class ShareResPatchInfo {
    public String arscBaseCrc = null;
    public String resArscMd5 = null;
    public ArrayList<String> addRes = new ArrayList();
    public ArrayList<String> deleteRes = new ArrayList();
    public ArrayList<String> modRes = new ArrayList();
    public ArrayList<String> largeModRes = new ArrayList();
    public HashMap<String, LargeModeInfo> largeModMap = new HashMap();
    public HashSet<Pattern> patterns = new HashSet();

    public static void parseAllResPatchInfo(String stringArray, ShareResPatchInfo shareResPatchInfo) {
        if (stringArray == null || stringArray.length() == 0) {
            return;
        }
        stringArray = stringArray.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            if (stringArray2 == null || stringArray2.length() <= 0) continue;
            if (stringArray2.startsWith("resources_out.zip")) {
                stringArray2 = stringArray2.split(",", 3);
                shareResPatchInfo.arscBaseCrc = stringArray2[1];
                shareResPatchInfo.resArscMd5 = stringArray2[2];
                continue;
            }
            if (stringArray2.startsWith("pattern:")) {
                stringArray2 = stringArray2.split(":", 2);
                for (int j = Integer.parseInt(stringArray2[1]); j > 0; --j) {
                    shareResPatchInfo.patterns.add(ShareResPatchInfo.convertToPatternString(stringArray[i + 1]));
                    ++i;
                }
                continue;
            }
            if (stringArray2.startsWith("add:")) {
                stringArray2 = stringArray2.split(":", 2);
                for (int j = Integer.parseInt(stringArray2[1]); j > 0; --j) {
                    shareResPatchInfo.addRes.add(stringArray[i + 1]);
                    ++i;
                }
                continue;
            }
            if (stringArray2.startsWith("modify:")) {
                stringArray2 = stringArray2.split(":", 2);
                for (int j = Integer.parseInt(stringArray2[1]); j > 0; --j) {
                    shareResPatchInfo.modRes.add(stringArray[i + 1]);
                    ++i;
                }
                continue;
            }
            if (stringArray2.startsWith("large modify:")) {
                stringArray2 = stringArray2.split(":", 2);
                for (int j = Integer.parseInt(stringArray2[1]); j > 0; --j) {
                    String[] stringArray3 = stringArray[i + 1];
                    stringArray3 = stringArray3.split(",", 3);
                    String string = stringArray3[0];
                    LargeModeInfo largeModeInfo = new LargeModeInfo();
                    new LargeModeInfo().md5 = stringArray3[1];
                    largeModeInfo.crc = Long.parseLong(stringArray3[2]);
                    shareResPatchInfo.largeModRes.add(string);
                    shareResPatchInfo.largeModMap.put(string, largeModeInfo);
                    ++i;
                }
                continue;
            }
            if (!stringArray2.startsWith("delete:")) continue;
            stringArray2 = stringArray2.split(":", 2);
            for (int j = Integer.parseInt(stringArray2[1]); j > 0; --j) {
                shareResPatchInfo.deleteRes.add(stringArray[i + 1]);
                ++i;
            }
        }
    }

    public static boolean checkFileInPattern(HashSet<Pattern> object, String string) {
        if (!((HashSet)object).isEmpty()) {
            object = ((HashSet)object).iterator();
            while (object.hasNext()) {
                Pattern pattern = (Pattern)object.next();
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkResPatchInfo(ShareResPatchInfo object) {
        if (object == null) {
            return false;
        }
        object = ((ShareResPatchInfo)object).resArscMd5;
        return object != null && ((String)object).length() == 32;
    }

    private static Pattern convertToPatternString(String object) {
        if (((String)object).contains(".")) {
            object = ((String)object).replaceAll("\\.", "\\\\.");
        }
        if (((String)object).contains("?")) {
            object = ((String)object).replaceAll("\\?", "\\.");
        }
        if (((String)object).contains("*")) {
            object = ((String)object).replace("*", ".*");
        }
        object = Pattern.compile((String)object);
        return object;
    }

    public static void parseResPatchInfoFirstLine(String stringArray, ShareResPatchInfo shareResPatchInfo) {
        if (stringArray == null || stringArray.length() == 0) {
            return;
        }
        Object object = stringArray.split("\n");
        if ((object = object[0]) == null || ((String)object).length() <= 0) {
            throw new TinkerRuntimeException("res meta Corrupted:" + (String)stringArray);
        }
        stringArray = ((String)object).split(",", 3);
        shareResPatchInfo.arscBaseCrc = stringArray[1];
        shareResPatchInfo.resArscMd5 = stringArray[2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("resArscMd5:" + this.resArscMd5 + "\n");
        stringBuffer.append("arscBaseCrc:" + this.arscBaseCrc + "\n");
        for (Pattern object : this.patterns) {
            stringBuffer.append("pattern:" + object + "\n");
        }
        for (String string : this.addRes) {
            stringBuffer.append("addedSet:" + string + "\n");
        }
        for (String string : this.modRes) {
            stringBuffer.append("modifiedSet:" + string + "\n");
        }
        for (String string : this.largeModRes) {
            stringBuffer.append("largeModifiedSet:" + string + "\n");
        }
        for (String string : this.deleteRes) {
            stringBuffer.append("deletedSet:" + string + "\n");
        }
        return stringBuffer.toString();
    }

    public static class LargeModeInfo {
        public String md5 = null;
        public long crc;
        public File file = null;
    }
}

