/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.os.Process;
import android.util.Log;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class TinkerUncaughtHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = "Tinker.UncaughtHandler";
    private final File crashFile;
    private final Context context;
    private final Thread.UncaughtExceptionHandler ueh;

    public TinkerUncaughtHandler(Context context) {
        this.context = context;
        this.ueh = Thread.getDefaultUncaughtExceptionHandler();
        this.crashFile = SharePatchFileUtil.getPatchLastCrashFile(context);
    }

    @Override
    public void uncaughtException(Thread object, Throwable throwable) {
        Log.e((String)TAG, (String)("catch exception when loading tinker:" + Log.getStackTraceString((Throwable)throwable)));
        this.ueh.uncaughtException((Thread)object, throwable);
        if (this.crashFile != null && (object = Thread.getDefaultUncaughtExceptionHandler()) instanceof TinkerUncaughtHandler) {
            object = this.crashFile.getParentFile();
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                Log.e((String)TAG, (String)"print crash file error: create directory fail!");
                return;
            }
            object = null;
            try {
                object = new PrintWriter(new FileWriter(this.crashFile, false));
                ((PrintWriter)object).println("process:" + ShareTinkerInternals.getProcessName(this.context));
                ((PrintWriter)object).println(ShareTinkerInternals.getExceptionCauseString(throwable));
            }
            catch (IOException iOException) {
                Log.e((String)TAG, (String)("print crash file error:" + Log.getStackTraceString((Throwable)iOException)));
            }
            finally {
                SharePatchFileUtil.closeQuietly((Closeable)object);
            }
            Process.killProcess((int)Process.myPid());
        }
    }
}

