/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.SystemClock;
import com.tencent.tinker.bsdiff.BSPatch;
import com.tencent.tinker.lib.patch.BasePatchInternal;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareBsDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BsDiffPatchInternal
extends BasePatchInternal {
    private static final String TAG = "Tinker.BsDiffPatchInternal";

    protected static boolean tryRecoverLibraryFiles(Tinker object, ShareSecurityCheck shareSecurityCheck, Context context, String string, File file) {
        if (!((Tinker)object).isEnabledForNativeLib()) {
            TinkerLog.w(TAG, "patch recover, library is not enabled", new Object[0]);
            return true;
        }
        object = shareSecurityCheck.getMetaContentMap().get("assets/so_meta.txt");
        if (object == null) {
            TinkerLog.w(TAG, "patch recover, library is not contained", new Object[0]);
            return true;
        }
        long l = SystemClock.elapsedRealtime();
        boolean bl = BsDiffPatchInternal.patchLibraryExtractViaBsDiff(context, string, (String)object, file);
        long l2 = SystemClock.elapsedRealtime() - l;
        TinkerLog.i(TAG, "recover lib result:%b, cost:%d", bl, l2);
        return bl;
    }

    private static boolean patchLibraryExtractViaBsDiff(Context context, String string, String string2, File file) {
        string = string + "/lib" + "/";
        return BsDiffPatchInternal.extractBsDiffInternals(context, string, string2, file, 5);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractBsDiffInternals(Context var0, String var1_4, String var2_5, File var3_6, int var4_7) {
        block20: {
            block19: {
                var5_8 = new ArrayList<ShareBsDiffPatchInfo>();
                ShareBsDiffPatchInfo.parseDiffPatchInfo((String)var2_5, var5_8);
                if (var5_8.isEmpty()) {
                    TinkerLog.w("Tinker.BsDiffPatchInternal", "extract patch list is empty! type:%s:", new Object[]{ShareTinkerInternals.getTypeString(var4_7)});
                    return true;
                }
                var2_5 = new File(var1_4);
                if (!var2_5.exists()) {
                    var2_5.mkdirs();
                }
                var2_5 = Tinker.with((Context)var0);
                if ((var0 = var0.getApplicationInfo()) == null) {
                    TinkerLog.w("Tinker.BsDiffPatchInternal", "applicationInfo == null!!!!", new Object[0]);
                    return false;
                }
                var6_9 = null;
                var7_10 = null;
                try {
                    var0 = var0.sourceDir;
                    var6_9 = new ZipFile((String)var0);
                    var7_10 = new ZipFile(var3_6);
                    var0 = var5_8.iterator();
lbl21:
                    // 4 sources

                    while (var0.hasNext()) {
                        var5_8 = (ShareBsDiffPatchInfo)var0.next();
                        var14_17 = System.currentTimeMillis();
                        var8_11 = var5_8.path;
                        var8_11 = var8_11.equals("") != false ? var5_8.name : var5_8.path + "/" + var5_8.name;
                        var9_12 = var5_8.md5;
                        if (!SharePatchFileUtil.checkIfMd5Valid(var9_12)) {
                            TinkerLog.w("Tinker.BsDiffPatchInternal", "meta file md5 mismatch, type:%s, name: %s, md5: %s", new Object[]{ShareTinkerInternals.getTypeString(var4_7), var5_8.name, var5_8.md5});
                            var2_5.getPatchReporter().onPatchPackageCheckFail(var3_6, BasePatchInternal.getMetaCorruptedCode(var4_7));
                            break block19;
                        }
                        ** GOTO lbl-1000
                    }
                    break block20;
                }
                catch (Throwable var0_2) {
                    try {
                        throw new TinkerRuntimeException("patch " + ShareTinkerInternals.getTypeString(var4_7) + " extract failed (" + var0_2.getMessage() + ").", var0_2);
                    }
                    catch (Throwable var0_3) {
                        SharePatchFileUtil.closeZip(var6_9);
                        SharePatchFileUtil.closeZip(var7_10);
                        throw var0_3;
                    }
                }
            }
            SharePatchFileUtil.closeZip(var6_9);
            SharePatchFileUtil.closeZip(var7_10);
            return false;
lbl-1000:
            // 1 sources

            {
                block24: {
                    block22: {
                        block23: {
                            var10_13 = var5_8.path + "/" + var5_8.name;
                            var10_13 = new File(var1_4 + (String)var10_13);
                            if (!var10_13.exists()) break block22;
                            if (!var9_12.equals(SharePatchFileUtil.getMD5((File)var10_13))) break block23;
                            TinkerLog.w("Tinker.BsDiffPatchInternal", "bsdiff file %s is already exist, and md5 match, just continue", new Object[]{var10_13.getPath()});
                            ** GOTO lbl21
                        }
                        TinkerLog.w("Tinker.BsDiffPatchInternal", "have a mismatch corrupted dex " + var10_13.getPath(), new Object[0]);
                        var10_13.delete();
                        break block24;
                    }
                    var10_13.getParentFile().mkdirs();
                }
                var11_14 = var5_8.patchMd5;
                var12_15 = var7_10.getEntry((String)var8_11);
                if (var12_15 != null) ** GOTO lbl-1000
                TinkerLog.w("Tinker.BsDiffPatchInternal", "patch entry is null. path:" + (String)var8_11, new Object[0]);
                var2_5.getPatchReporter().onPatchTypeExtractFail(var3_6, (File)var10_13, var5_8.name, var4_7);
            }
            SharePatchFileUtil.closeZip(var6_9);
            SharePatchFileUtil.closeZip(var7_10);
            return false;
lbl-1000:
            // 1 sources

            {
                if (!var11_14.equals("0")) ** GOTO lbl-1000
                if (BsDiffPatchInternal.extract(var7_10, var12_15, (File)var10_13, var9_12, false)) ** GOTO lbl21
                TinkerLog.w("Tinker.BsDiffPatchInternal", "Failed to extract file " + var10_13.getPath(), new Object[0]);
                var2_5.getPatchReporter().onPatchTypeExtractFail(var3_6, (File)var10_13, var5_8.name, var4_7);
            }
            SharePatchFileUtil.closeZip(var6_9);
            SharePatchFileUtil.closeZip(var7_10);
            return false;
lbl-1000:
            // 1 sources

            {
                if (SharePatchFileUtil.checkIfMd5Valid((String)var11_14)) ** GOTO lbl-1000
                TinkerLog.w("Tinker.BsDiffPatchInternal", "meta file md5 mismatch, type:%s, name: %s, md5: %s", new Object[]{ShareTinkerInternals.getTypeString(var4_7), var5_8.name, var11_14});
                var2_5.getPatchReporter().onPatchPackageCheckFail(var3_6, BasePatchInternal.getMetaCorruptedCode(var4_7));
            }
            SharePatchFileUtil.closeZip(var6_9);
            SharePatchFileUtil.closeZip(var7_10);
            return false;
lbl-1000:
            // 1 sources

            {
                var11_14 = var6_9.getEntry((String)var8_11);
                if (var11_14 != null) ** GOTO lbl-1000
                TinkerLog.w("Tinker.BsDiffPatchInternal", "apk entry is null. path:" + (String)var8_11, new Object[0]);
                var2_5.getPatchReporter().onPatchTypeExtractFail(var3_6, (File)var10_13, var5_8.name, var4_7);
            }
            SharePatchFileUtil.closeZip(var6_9);
            SharePatchFileUtil.closeZip(var7_10);
            return false;
lbl-1000:
            // 1 sources

            {
                var13_16 = var5_8.rawCrc;
                var16_18 = String.valueOf(var11_14.getCrc());
                if (var16_18.equals(var13_16)) ** GOTO lbl-1000
                TinkerLog.e("Tinker.BsDiffPatchInternal", "apk entry %s crc is not equal, expect crc: %s, got crc: %s", new Object[]{var8_11, var13_16, var16_18});
                var2_5.getPatchReporter().onPatchTypeExtractFail(var3_6, (File)var10_13, var5_8.name, var4_7);
            }
            SharePatchFileUtil.closeZip(var6_9);
            SharePatchFileUtil.closeZip(var7_10);
            return false;
lbl-1000:
            // 1 sources

            {
                var8_11 = null;
                var13_16 = null;
                try {
                    var8_11 = var6_9.getInputStream((ZipEntry)var11_14);
                    var13_16 = var7_10.getInputStream(var12_15);
                    BSPatch.patchFast((InputStream)var8_11, (InputStream)var13_16, (File)var10_13);
                }
                finally {
                    SharePatchFileUtil.closeQuietly((Closeable)var8_11);
                    SharePatchFileUtil.closeQuietly((Closeable)var13_16);
                }
                if (SharePatchFileUtil.verifyFileMd5((File)var10_13, var9_12)) ** GOTO lbl-1000
                TinkerLog.w("Tinker.BsDiffPatchInternal", "Failed to recover diff file " + var10_13.getPath(), new Object[0]);
                var2_5.getPatchReporter().onPatchTypeExtractFail(var3_6, (File)var10_13, var5_8.name, var4_7);
                SharePatchFileUtil.safeDeleteFile((File)var10_13);
            }
            SharePatchFileUtil.closeZip(var6_9);
            SharePatchFileUtil.closeZip(var7_10);
            return false;
lbl-1000:
            // 1 sources

            {
                TinkerLog.w("Tinker.BsDiffPatchInternal", "success recover bsdiff file: %s, use time: %d", new Object[]{var10_13.getPath(), System.currentTimeMillis() - var14_17});
                ** GOTO lbl21
            }
        }
        SharePatchFileUtil.closeZip(var6_9);
        SharePatchFileUtil.closeZip(var7_10);
        return true;
    }
}

