/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.tinker;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.util.HashMap;

public class TinkerLoadResult {
    private static final String TAG = "Tinker.TinkerLoadResult";
    public SharePatchInfo patchInfo;
    public String currentVersion;
    public boolean versionChanged;
    public boolean systemOTA;
    public File patchVersionDirectory;
    public File patchVersionFile;
    public File dexDirectory;
    public File libraryDirectory;
    public File resourceDirectory;
    public File resourceFile;
    public HashMap<String, String> dexes;
    public HashMap<String, String> libs;
    public HashMap<String, String> packageConfig;
    public int loadCode;
    public long costTime;

    public boolean parseTinkerResult(Context object, Intent object2) {
        Object object3;
        object = Tinker.with((Context)object);
        this.loadCode = ShareIntentUtil.getIntentReturnCode(object2);
        this.costTime = ShareIntentUtil.getIntentPatchCostTime(object2);
        this.systemOTA = ShareIntentUtil.getBooleanExtra(object2, "intent_patch_system_ota", false);
        TinkerLog.i(TAG, "parseTinkerResult loadCode:%d, systemOTA:%b", this.loadCode, this.systemOTA);
        String string = ShareIntentUtil.getStringExtra(object2, "intent_patch_old_version");
        String string2 = ShareIntentUtil.getStringExtra(object2, "intent_patch_new_version");
        File file = ((Tinker)object).getPatchDirectory();
        File file2 = ((Tinker)object).getPatchInfoFile();
        boolean bl = ((Tinker)object).isMainProcess();
        if (string != null && string2 != null) {
            this.currentVersion = bl ? string2 : string;
            TinkerLog.i(TAG, "parseTinkerResult oldVersion:%s, newVersion:%s, current:%s", string, string2, this.currentVersion);
            object3 = SharePatchFileUtil.getPatchVersionDirectory(this.currentVersion);
            if (!ShareTinkerInternals.isNullOrNil((String)object3)) {
                this.patchVersionDirectory = new File(file.getAbsolutePath() + "/" + (String)object3);
                this.patchVersionFile = new File(this.patchVersionDirectory.getAbsolutePath(), SharePatchFileUtil.getPatchVersionFile(this.currentVersion));
                this.dexDirectory = new File(this.patchVersionDirectory, "dex");
                this.libraryDirectory = new File(this.patchVersionDirectory, "lib");
                this.resourceDirectory = new File(this.patchVersionDirectory, "res");
                this.resourceFile = new File(this.resourceDirectory, "resources.apk");
            }
            this.patchInfo = new SharePatchInfo(string, string2, Build.FINGERPRINT);
            boolean bl2 = this.versionChanged = !string.equals(string2);
        }
        if ((object3 = ShareIntentUtil.getIntentPatchException(object2)) != null) {
            TinkerLog.i(TAG, "Tinker load have exception loadCode:%d", this.loadCode);
            int n = -1;
            switch (this.loadCode) {
                case -19: {
                    n = -1;
                    break;
                }
                case -14: {
                    n = -2;
                    break;
                }
                case -15: {
                    n = -5;
                    break;
                }
                case -22: {
                    n = -3;
                    break;
                }
                case -24: {
                    n = -4;
                }
            }
            ((Tinker)object).getLoadReporter().onLoadException((Throwable)object3, n);
            return false;
        }
        switch (this.loadCode) {
            case -10000: {
                TinkerLog.e(TAG, "can't get the right intent return code", new Object[0]);
                throw new TinkerRuntimeException("can't get the right intent return code");
            }
            case -1: {
                TinkerLog.w(TAG, "tinker is disable, just return", new Object[0]);
                break;
            }
            case -3: 
            case -2: {
                TinkerLog.w(TAG, "can't find patch file, is ok, just return", new Object[0]);
                break;
            }
            case -4: {
                TinkerLog.e(TAG, "path info corrupted", new Object[0]);
                ((Tinker)object).getLoadReporter().onLoadPatchInfoCorrupted(string, string2, file2);
                break;
            }
            case -5: {
                TinkerLog.e(TAG, "path info blank, wait main process to restart", new Object[0]);
                break;
            }
            case -6: {
                TinkerLog.e(TAG, "patch version directory not found, current version:%s", this.currentVersion);
                ((Tinker)object).getLoadReporter().onLoadFileNotFound(this.patchVersionDirectory, 1, true);
                break;
            }
            case -7: {
                TinkerLog.e(TAG, "patch version file not found, current version:%s", this.currentVersion);
                if (this.patchVersionFile == null) {
                    throw new TinkerRuntimeException("error load patch version file not exist, but file is null");
                }
                ((Tinker)object).getLoadReporter().onLoadFileNotFound(this.patchVersionFile, 1, false);
                break;
            }
            case -8: {
                TinkerLog.i(TAG, "patch package check fail", new Object[0]);
                if (this.patchVersionFile == null) {
                    throw new TinkerRuntimeException("error patch package check fail , but file is null");
                }
                int n = object2.getIntExtra("intent_patch_package_patch_check", -10000);
                ((Tinker)object).getLoadReporter().onLoadPackageCheckFail(this.patchVersionFile, n);
                break;
            }
            case -9: {
                if (this.dexDirectory != null) {
                    TinkerLog.e(TAG, "patch dex file directory not found:%s", this.dexDirectory.getAbsolutePath());
                    ((Tinker)object).getLoadReporter().onLoadFileNotFound(this.dexDirectory, 3, true);
                    break;
                }
                TinkerLog.e(TAG, "patch dex file directory not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch dex file directory not found, warning why the path is null!!!!");
            }
            case -10: {
                object2 = ShareIntentUtil.getStringExtra(object2, "intent_patch_missing_dex_path");
                if (object2 != null) {
                    TinkerLog.e(TAG, "patch dex file not found:%s", object2);
                    ((Tinker)object).getLoadReporter().onLoadFileNotFound(new File((String)object2), 3, false);
                    break;
                }
                TinkerLog.e(TAG, "patch dex file not found, but path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch dex file not found, but path is null!!!!");
            }
            case -11: {
                object2 = ShareIntentUtil.getStringExtra(object2, "intent_patch_missing_dex_path");
                if (object2 != null) {
                    TinkerLog.e(TAG, "patch dex opt file not found:%s", object2);
                    ((Tinker)object).getLoadReporter().onLoadFileNotFound(new File((String)object2), 4, false);
                    break;
                }
                TinkerLog.e(TAG, "patch dex opt file not found, but path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch dex opt file not found, but path is null!!!!");
            }
            case -16: {
                if (this.patchVersionDirectory != null) {
                    TinkerLog.e(TAG, "patch lib file directory not found:%s", this.libraryDirectory.getAbsolutePath());
                    ((Tinker)object).getLoadReporter().onLoadFileNotFound(this.libraryDirectory, 5, true);
                    break;
                }
                TinkerLog.e(TAG, "patch lib file directory not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch lib file directory not found, warning why the path is null!!!!");
            }
            case -17: {
                object2 = ShareIntentUtil.getStringExtra(object2, "intent_patch_missing_lib_path");
                if (object2 != null) {
                    TinkerLog.e(TAG, "patch lib file not found:%s", object2);
                    ((Tinker)object).getLoadReporter().onLoadFileNotFound(new File((String)object2), 5, false);
                    break;
                }
                TinkerLog.e(TAG, "patch lib file not found, but path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch lib file not found, but path is null!!!!");
            }
            case -12: {
                TinkerLog.e(TAG, "patch dex load fail, classloader is null", new Object[0]);
                break;
            }
            case -13: {
                object2 = ShareIntentUtil.getStringExtra(object2, "intent_patch_mismatch_dex_path");
                if (object2 == null) {
                    TinkerLog.e(TAG, "patch dex file md5 is mismatch, but path is null!!!!", new Object[0]);
                    throw new TinkerRuntimeException("patch dex file md5 is mismatch, but path is null!!!!");
                }
                TinkerLog.e(TAG, "patch dex file md5 is mismatch: %s", object2);
                ((Tinker)object).getLoadReporter().onLoadFileMd5Mismatch(new File((String)object2), 3);
                break;
            }
            case -18: {
                TinkerLog.i(TAG, "rewrite patch info file corrupted", new Object[0]);
                ((Tinker)object).getLoadReporter().onLoadPatchInfoCorrupted(string, string2, file2);
                break;
            }
            case -20: {
                if (this.patchVersionDirectory != null) {
                    TinkerLog.e(TAG, "patch resource file directory not found:%s", this.resourceDirectory.getAbsolutePath());
                    ((Tinker)object).getLoadReporter().onLoadFileNotFound(this.resourceDirectory, 6, true);
                    break;
                }
                TinkerLog.e(TAG, "patch resource file directory not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch resource file directory not found, warning why the path is null!!!!");
            }
            case -21: {
                if (this.patchVersionDirectory != null) {
                    TinkerLog.e(TAG, "patch resource file not found:%s", this.resourceFile.getAbsolutePath());
                    ((Tinker)object).getLoadReporter().onLoadFileNotFound(this.resourceFile, 6, false);
                    break;
                }
                TinkerLog.e(TAG, "patch resource file not found, warning why the path is null!!!!", new Object[0]);
                throw new TinkerRuntimeException("patch resource file not found, warning why the path is null!!!!");
            }
            case -23: {
                if (this.resourceFile == null) {
                    TinkerLog.e(TAG, "resource file md5 mismatch, but patch resource file not found!", new Object[0]);
                    throw new TinkerRuntimeException("resource file md5 mismatch, but patch resource file not found!");
                }
                TinkerLog.e(TAG, "patch resource file md5 is mismatch: %s", this.resourceFile.getAbsolutePath());
                ((Tinker)object).getLoadReporter().onLoadFileMd5Mismatch(this.resourceFile, 6);
                break;
            }
            case 0: {
                TinkerLog.i(TAG, "oh yeah, tinker load all success", new Object[0]);
                ((Tinker)object).setTinkerLoaded(true);
                this.dexes = ShareIntentUtil.getIntentPatchDexPaths(object2);
                this.libs = ShareIntentUtil.getIntentPatchLibsPaths(object2);
                this.packageConfig = ShareIntentUtil.getIntentPackageConfig(object2);
                if (bl && this.versionChanged) {
                    ((Tinker)object).getLoadReporter().onLoadPatchVersionChanged(string, string2, file, this.patchVersionDirectory.getName());
                }
                return true;
            }
        }
        return false;
    }

    public String getPackageConfigByName(String string) {
        if (this.packageConfig != null) {
            return this.packageConfig.get(string);
        }
        return null;
    }
}

