/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BasePatchInternal {
    protected static final String TAG = "Tinker.BasePatchInternal";
    protected static final String DEX_PATH = "dex";
    protected static final String SO_PATH = "lib";
    protected static final String DEX_OPTIMIZE_PATH = "odex";
    protected static final int MAX_EXTRACT_ATTEMPTS = 2;
    protected static final String DEX_META_FILE = "assets/dex_meta.txt";
    protected static final String SO_META_FILE = "assets/so_meta.txt";
    protected static final String RES_META_FILE = "assets/res_meta.txt";
    protected static final int TYPE_DEX = 3;
    protected static final int TYPE_Library = 5;
    protected static final int TYPE_RESOURCE = 6;

    public static boolean extract(ZipFile zipFile, ZipEntry zipEntry, File file, String string, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        while (n < 2 && !bl2) {
            ++n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            OutputStream outputStream = new FileOutputStream(file);
            outputStream = new BufferedOutputStream(outputStream);
            TinkerLog.i(TAG, "try Extracting " + file.getPath(), new Object[0]);
            try {
                byte[] byArray = new byte[16384];
                int n2 = bufferedInputStream.read(byArray);
                while (n2 != -1) {
                    ((BufferedOutputStream)outputStream).write(byArray, 0, n2);
                    n2 = bufferedInputStream.read(byArray);
                }
            }
            finally {
                SharePatchFileUtil.closeQuietly(outputStream);
                SharePatchFileUtil.closeQuietly(bufferedInputStream);
            }
            bl2 = bl ? SharePatchFileUtil.verifyDexFileMd5(file, string) : SharePatchFileUtil.verifyFileMd5(file, string);
            TinkerLog.i(TAG, "isExtractionSuccessful: %b", bl2);
            if (bl2) continue;
            file.delete();
            if (!file.exists()) continue;
            TinkerLog.e(TAG, "Failed to delete corrupted dex " + file.getPath(), new Object[0]);
        }
        return bl2;
    }

    public static int getMetaCorruptedCode(int n) {
        if (n == 3) {
            return -3;
        }
        if (n == 5) {
            return -4;
        }
        if (n == 6) {
            return -8;
        }
        return 0;
    }
}

