/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.library;

import android.content.Context;
import android.os.Build;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TinkerLoadLibrary {
    private static final String TAG = "Tinker.LoadLibrary";

    public static void loadArmLibrary(Context context, String string) {
        if (string == null || string.isEmpty() || context == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        Tinker tinker = Tinker.with(context);
        if (tinker.isEnabledForNativeLib() && TinkerLoadLibrary.loadLibraryFromTinker(context, "lib/armeabi", string)) {
            return;
        }
        System.loadLibrary(string);
    }

    public static void loadArmV7Library(Context context, String string) {
        if (string == null || string.isEmpty() || context == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        Tinker tinker = Tinker.with(context);
        if (tinker.isEnabledForNativeLib() && TinkerLoadLibrary.loadLibraryFromTinker(context, "lib/armeabi-v7a", string)) {
            return;
        }
        System.loadLibrary(string);
    }

    public static boolean loadLibraryFromTinker(Context object, String string, String object2) {
        object = Tinker.with((Context)object);
        object2 = ((String)object2).startsWith("lib") ? object2 : "lib" + (String)object2;
        object2 = ((String)object2).endsWith(".so") ? object2 : (String)object2 + ".so";
        string = string + "/" + (String)object2;
        if (((Tinker)object).isEnabledForNativeLib() && ((Tinker)object).isTinkerLoaded()) {
            object2 = ((Tinker)object).getTinkerLoadResultIfPresent();
            if (((TinkerLoadResult)object2).libs != null) {
                for (String string2 : ((TinkerLoadResult)object2).libs.keySet()) {
                    String string3;
                    File file;
                    if (!string2.equals(string) || !(file = new File(string3 = ((TinkerLoadResult)object2).libraryDirectory + "/" + string2)).exists()) continue;
                    boolean bl = ((Tinker)object).isTinkerLoadVerify();
                    if (bl && !SharePatchFileUtil.verifyFileMd5(file, ((TinkerLoadResult)object2).libs.get(string2))) {
                        ((Tinker)object).getLoadReporter().onLoadFileMd5Mismatch(file, 5);
                        continue;
                    }
                    System.load(string3);
                    TinkerLog.i(TAG, "loadLibraryFromTinker success:" + string3, new Object[0]);
                    return true;
                }
            }
        }
        return false;
    }

    public static void installNavitveLibraryABI(Context object, String object2) {
        Object object3 = Tinker.with((Context)object);
        if (!((Tinker)object3).isTinkerLoaded()) {
            TinkerLog.i(TAG, "tinker is not loaded, just return", new Object[0]);
            return;
        }
        object3 = ((Tinker)object3).getTinkerLoadResultIfPresent();
        if (((TinkerLoadResult)object3).libs == null) {
            TinkerLog.i(TAG, "tinker libs is null, just return", new Object[0]);
            return;
        }
        if (!((File)(object2 = new File(((TinkerLoadResult)object3).libraryDirectory, "lib/" + (String)object2))).exists()) {
            TinkerLog.e(TAG, "current libraryABI folder is not exist, path: %s", ((File)object2).getPath());
            return;
        }
        if ((object = object.getClassLoader()) == null) {
            TinkerLog.e(TAG, "classloader is null", new Object[0]);
            return;
        }
        TinkerLog.i(TAG, "before hack classloader:" + object.toString(), new Object[0]);
        try {
            TinkerLoadLibrary.installNativeLibraryPath((ClassLoader)object, (File)object2);
        }
        catch (Throwable throwable) {
            TinkerLog.e(TAG, "installNativeLibraryPath fail:" + throwable, new Object[0]);
        }
        TinkerLog.i(TAG, "after hack classloader:" + object.toString(), new Object[0]);
    }

    private static void installNativeLibraryPath(ClassLoader classLoader, File file) {
        if (file == null || !file.exists()) {
            TinkerLog.e(TAG, "installNativeLibraryPath, folder %s is illegal", file);
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                V23.install(classLoader, file);
                return;
            }
            catch (Throwable throwable) {
                TinkerLog.e(TAG, "installNativeLibraryPath, v23 fail, sdk: %d, error: %s", Build.VERSION.SDK_INT, throwable.getMessage());
                V14.install(classLoader, file);
                return;
            }
        }
        if (Build.VERSION.SDK_INT >= 14) {
            V14.install(classLoader, file);
            return;
        }
        V4.install(classLoader, file);
    }

    static final class V23 {
        private V23() {
        }

        private static void install(ClassLoader object, File objectArray) {
            Object object2 = ShareReflectUtil.findField(object, "pathList");
            object = ((Field)object2).get(object);
            object2 = ShareReflectUtil.findField(object, "nativeLibraryDirectories");
            object2 = (List)((Field)object2).get(object);
            object2.add(0, objectArray);
            objectArray = ShareReflectUtil.findField(object, "systemNativeLibraryDirectories");
            objectArray = (List)objectArray.get(object);
            Method method = ShareReflectUtil.findMethod(object, "makePathElements", List.class, File.class, List.class);
            ArrayList arrayList = new ArrayList();
            object2.addAll(objectArray);
            objectArray = (Object[])method.invoke(object, object2, null, arrayList);
            object2 = ShareReflectUtil.findField(object, "nativeLibraryPathElements");
            ((Field)object2).setAccessible(true);
            ((Field)object2).set(object, objectArray);
        }
    }

    static final class V14 {
        private V14() {
        }

        private static void install(ClassLoader object, File file) {
            Field field = ShareReflectUtil.findField(object, "pathList");
            object = field.get(object);
            ShareReflectUtil.expandFieldArray(object, "nativeLibraryDirectories", new File[]{file});
        }
    }

    static final class V4 {
        private V4() {
        }

        private static void install(ClassLoader classLoader, File object) {
            object = ((File)object).getPath();
            Field field = ShareReflectUtil.findField(classLoader, "libPath");
            Object object2 = new StringBuilder((String)field.get(classLoader));
            ((StringBuilder)object2).append(':').append((String)object);
            field.set(classLoader, ((StringBuilder)object2).toString());
            field = ShareReflectUtil.findField(classLoader, "libraryPathElements");
            object2 = (List)field.get(classLoader);
            object2.add(0, object);
            field.set(classLoader, object2);
        }
    }
}

