/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ShareSecurityCheck {
    private static final String TAG = "ShareSecurityCheck";
    private static PublicKey mPublicKey = null;
    private final Context mContext;
    private final HashMap<String, String> metaContentMap;
    private HashMap<String, String> packageProperties;

    public ShareSecurityCheck(Context context) {
        this.mContext = context;
        this.metaContentMap = new HashMap();
        if (mPublicKey == null) {
            this.init(this.mContext);
        }
    }

    public HashMap<String, String> getMetaContentMap() {
        return this.metaContentMap;
    }

    public HashMap<String, String> getPackagePropertiesIfPresent() {
        if (this.packageProperties != null) {
            return this.packageProperties;
        }
        String[] stringArray = this.metaContentMap.get("assets/package_meta.txt");
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = stringArray.split("\n");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3 = stringArray[i];
            if (stringArray3 == null || stringArray3.length() <= 0 || stringArray3.startsWith("#") || (stringArray3 = stringArray3.split("=", 2)) == null || stringArray3.length < 2) continue;
            if (this.packageProperties == null) {
                this.packageProperties = new HashMap();
            }
            this.packageProperties.put(stringArray3[0].trim(), stringArray3[1].trim());
        }
        return this.packageProperties;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyPatchMetaSignature(File var1_1) {
        block17: {
            block16: {
                if (!SharePatchFileUtil.isLegalFile(var1_1)) {
                    return false;
                }
                var2_2 = null;
                try {
                    var2_2 = new JarFile(var1_1);
                    var3_6 = var2_2.entries();
lbl7:
                    // 3 sources

                    while (var3_6.hasMoreElements()) {
                        var4_10 = var3_6.nextElement();
                        if (var4_10 == null || (var5_11 = var4_10.getName()).startsWith("META-INF/") || !var5_11.endsWith("meta.txt")) continue;
                        this.metaContentMap.put(var5_11, SharePatchFileUtil.loadDigestes(var2_2, (JarEntry)var4_10));
                        var4_10 = var4_10.getCertificates();
                        if (var4_10 == null) {
                            break block16;
                        }
                        ** GOTO lbl-1000
                    }
                    break block17;
                }
                catch (Exception var3_8) {
                    try {
                        throw new TinkerRuntimeException(String.format("ShareSecurityCheck file %s, size %d verifyPatchMetaSignature fail", new Object[]{var1_1.getAbsolutePath(), var1_1.length()}), var3_8);
                    }
                    catch (Throwable var3_9) {
                        try {
                            if (var2_2 == null) throw var3_9;
                            var2_2.close();
                            throw var3_9;
                        }
                        catch (IOException var2_5) {
                            Log.e((String)"ShareSecurityCheck", (String)var1_1.getAbsolutePath(), (Throwable)var2_5);
                        }
                        throw var3_9;
                    }
                }
            }
            try {
                var2_2.close();
                return false;
            }
            catch (IOException var2_3) {
                Log.e((String)"ShareSecurityCheck", (String)var1_1.getAbsolutePath(), (Throwable)var2_3);
            }
            return false;
lbl-1000:
            // 1 sources

            {
                if (this.check(var1_1, var4_10)) ** GOTO lbl7
            }
            try {
                var2_2.close();
                return false;
            }
            catch (IOException var2_4) {
                Log.e((String)"ShareSecurityCheck", (String)var1_1.getAbsolutePath(), (Throwable)var2_4);
            }
            return false;
        }
        try {
            var2_2.close();
            return true;
        }
        catch (IOException var3_7) {
            Log.e((String)"ShareSecurityCheck", (String)var1_1.getAbsolutePath(), (Throwable)var3_7);
            return true;
        }
    }

    private boolean check(File file, Certificate[] certificateArray) {
        if (certificateArray.length > 0) {
            for (int i = certificateArray.length - 1; i >= 0; --i) {
                try {
                    certificateArray[i].verify(mPublicKey);
                    return true;
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)file.getAbsolutePath(), (Throwable)exception);
                    continue;
                }
            }
        }
        return false;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private void init(Context object) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            Object object2 = object.getPackageManager();
            object = object.getPackageName();
            object = object2.getPackageInfo((String)object, 64);
            object2 = CertificateFactory.getInstance("X.509");
            byteArrayInputStream = new ByteArrayInputStream(object.signatures[0].toByteArray());
            object = (X509Certificate)((CertificateFactory)object2).generateCertificate(byteArrayInputStream);
            mPublicKey = object.getPublicKey();
        }
        catch (Exception exception) {
            try {
                throw new TinkerRuntimeException("ShareSecurityCheck init public key fail", exception);
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(byteArrayInputStream);
                throw throwable;
            }
        }
        SharePatchFileUtil.closeQuietly(byteArrayInputStream);
        return;
    }
}

