/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;

public class ShareFileLockHelper
implements Closeable {
    public static final int MAX_LOCK_ATTEMPTS = 3;
    public static final int LOCK_WAIT_EACH_TIME = 10;
    private static final String TAG = "Tinker.FileLockHelper";
    private final FileOutputStream outputStream;
    private final FileLock fileLock;

    private ShareFileLockHelper(File file) {
        this.outputStream = new FileOutputStream(file);
        int n = 0;
        FileLock fileLock = null;
        Exception exception = null;
        while (n < 3) {
            ++n;
            try {
                fileLock = this.outputStream.getChannel().lock();
                boolean bl = fileLock != null;
                if (bl) break;
                Thread.sleep(10L);
            }
            catch (Exception exception2) {
                Exception exception3 = exception2;
                exception = exception2;
                Log.e((String)TAG, (String)"getInfoLock Thread failed time:10");
            }
        }
        if (fileLock == null) {
            throw new IOException("Tinker Exception:FileLockHelper lock file failed: " + file.getAbsolutePath(), exception);
        }
        this.fileLock = fileLock;
    }

    public static ShareFileLockHelper getFileLock(File file) {
        return new ShareFileLockHelper(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            if (this.outputStream == null) return;
        }
        catch (Throwable throwable) {
            if (this.outputStream == null) throw throwable;
            this.outputStream.close();
            throw throwable;
        }
        this.outputStream.close();
    }
}

