/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.SystemClock;
import android.util.Log;
import com.tencent.tinker.loader.AbstractTinkerLoader;
import com.tencent.tinker.loader.TinkerDexLoader;
import com.tencent.tinker.loader.TinkerResourceLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerSoLoader;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.io.Serializable;

public class TinkerLoader
extends AbstractTinkerLoader {
    private static final String TAG = "Tinker.TinkerLoader";
    private SharePatchInfo patchInfo;

    @Override
    public Intent tryLoad(TinkerApplication tinkerApplication, int n, boolean bl) {
        Intent intent = new Intent();
        long l = SystemClock.elapsedRealtime();
        this.tryLoadPatchFilesInternal(tinkerApplication, n, bl, intent);
        long l2 = SystemClock.elapsedRealtime() - l;
        ShareIntentUtil.setIntentPatchCostTime(intent, l2);
        return intent;
    }

    private void tryLoadPatchFilesInternal(TinkerApplication tinkerApplication, int n, boolean bl, Intent intent) {
        boolean bl2;
        boolean bl3;
        if (!ShareTinkerInternals.isTinkerEnabled(n)) {
            ShareIntentUtil.setIntentReturnCode(intent, -1);
            return;
        }
        File file = SharePatchFileUtil.getPatchDirectory((Context)tinkerApplication);
        if (file == null) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:getPatchDirectory == null");
            ShareIntentUtil.setIntentReturnCode(intent, -2);
            return;
        }
        String string = file.getAbsolutePath();
        if (!file.exists()) {
            Log.w((String)TAG, (String)("tryLoadPatchFiles:patch dir not exist:" + string));
            ShareIntentUtil.setIntentReturnCode(intent, -2);
            return;
        }
        file = SharePatchFileUtil.getPatchInfoFile(string);
        if (!file.exists()) {
            Log.w((String)TAG, (String)("tryLoadPatchFiles:patch info not exist:" + file.getAbsolutePath()));
            ShareIntentUtil.setIntentReturnCode(intent, -3);
            return;
        }
        File file2 = SharePatchFileUtil.getPatchInfoLockFile(string);
        this.patchInfo = SharePatchInfo.readAndCheckPropertyWithLock(file, file2);
        if (this.patchInfo == null) {
            ShareIntentUtil.setIntentReturnCode(intent, -4);
            return;
        }
        String string2 = this.patchInfo.oldVersion;
        Object object = this.patchInfo.newVersion;
        if (string2 == null || object == null) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchInfoCorrupted");
            ShareIntentUtil.setIntentReturnCode(intent, -4);
            return;
        }
        intent.putExtra("intent_patch_old_version", string2);
        intent.putExtra("intent_patch_new_version", (String)object);
        boolean bl4 = ShareTinkerInternals.isInMainProcess((Context)tinkerApplication);
        boolean bl5 = bl3 = !string2.equals(object);
        if (bl3 && bl4) {
            string2 = object;
        }
        if (ShareTinkerInternals.isNullOrNil(string2)) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:version is blank, wait main process to restart");
            ShareIntentUtil.setIntentReturnCode(intent, -5);
            return;
        }
        object = SharePatchFileUtil.getPatchVersionDirectory(string2);
        if (object == null) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:patchName is null");
            ShareIntentUtil.setIntentReturnCode(intent, -6);
            return;
        }
        object = new File(string = string + "/" + (String)object);
        if (!((File)object).exists()) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchVersionDirectoryNotFound");
            ShareIntentUtil.setIntentReturnCode(intent, -6);
            return;
        }
        if (!SharePatchFileUtil.isLegalFile((File)(object = new File(((File)object).getAbsolutePath(), SharePatchFileUtil.getPatchVersionFile(string2))))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchVersionFileNotFound");
            ShareIntentUtil.setIntentReturnCode(intent, -7);
            return;
        }
        ShareSecurityCheck shareSecurityCheck = new ShareSecurityCheck((Context)tinkerApplication);
        int n2 = ShareTinkerInternals.checkTinkerPackage((Context)tinkerApplication, n, (File)object, shareSecurityCheck);
        if (n2 != 0) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:checkTinkerPackage");
            intent.putExtra("intent_patch_package_patch_check", n2);
            ShareIntentUtil.setIntentReturnCode(intent, -8);
            return;
        }
        intent.putExtra("intent_patch_package_config", shareSecurityCheck.getPackagePropertiesIfPresent());
        boolean bl6 = ShareTinkerInternals.isTinkerEnabledForDex(n);
        n2 = bl6 ? 1 : 0;
        if (bl6 && !(bl2 = TinkerDexLoader.checkComplete(string, shareSecurityCheck, intent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:dex check fail");
            return;
        }
        bl2 = ShareTinkerInternals.isTinkerEnabledForNativeLib(n);
        if (bl2 && !(bl2 = TinkerSoLoader.checkComplete(string, shareSecurityCheck, intent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:native lib check fail");
            return;
        }
        bl2 = ShareTinkerInternals.isTinkerEnabledForResource(n);
        Log.w((String)TAG, (String)("tryLoadPatchFiles:isEnabledForResource:" + bl2));
        if (bl2) {
            boolean bl7 = TinkerResourceLoader.checkComplete((Context)tinkerApplication, string, shareSecurityCheck, intent);
            n = bl7 ? 1 : 0;
            if (!bl7) {
                Log.w((String)TAG, (String)"tryLoadPatchFiles:resource check fail");
                return;
            }
        }
        n = ShareTinkerInternals.isVmArt() && ShareTinkerInternals.isSystemOTA(this.patchInfo.fingerPrint) ? 1 : 0;
        intent.putExtra("intent_patch_system_ota", n != 0);
        if (n != 0 || bl4 && bl3) {
            this.patchInfo.oldVersion = string2;
            if (!SharePatchInfo.rewritePatchInfoFileWithLock(file, this.patchInfo, file2)) {
                ShareIntentUtil.setIntentReturnCode(intent, -18);
                Log.w((String)TAG, (String)"tryLoadPatchFiles:onReWritePatchInfoCorrupted");
                return;
            }
        }
        if (!this.checkSafeModeCount(tinkerApplication)) {
            intent.putExtra("intent_patch_exception", (Serializable)new TinkerRuntimeException("checkSafeModeCount fail"));
            ShareIntentUtil.setIntentReturnCode(intent, -24);
            Log.w((String)TAG, (String)"tryLoadPatchFiles:checkSafeModeCount fail");
            return;
        }
        if (n2 != 0) {
            boolean bl8 = TinkerDexLoader.loadTinkerJars(tinkerApplication, bl, string, intent, n != 0);
            n = bl8 ? 1 : 0;
            if (!bl8) {
                Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchLoadDexesFail");
                return;
            }
        }
        if (bl2) {
            boolean bl9 = TinkerResourceLoader.loadTinkerResources((Context)tinkerApplication, bl, string, intent);
            n = bl9 ? 1 : 0;
            if (!bl9) {
                Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchLoadResourcesFail");
                return;
            }
        }
        ShareIntentUtil.setIntentReturnCode(intent, 0);
        Log.i((String)TAG, (String)"tryLoadPatchFiles: load end, ok!");
    }

    private boolean checkSafeModeCount(TinkerApplication tinkerApplication) {
        String string = ShareTinkerInternals.getProcessName((Context)tinkerApplication);
        string = "tinker_own_config_" + string;
        SharedPreferences sharedPreferences = tinkerApplication.getSharedPreferences(string, 0);
        int n = sharedPreferences.getInt("safe_mode_count", 0) + 1;
        Log.w((String)TAG, (String)("tinker safe mode preferName:" + string + " count:" + n));
        if (n >= 3) {
            sharedPreferences.edit().putInt("safe_mode_count", 0).commit();
            return false;
        }
        tinkerApplication.setUseSafeMode(true);
        sharedPreferences.edit().putInt("safe_mode_count", n).commit();
        return true;
    }
}

