/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpatch.sdk;

import android.content.Context;
import android.os.Looper;
import android.os.MessageQueue;
import com.tencent.tinker.lib.library.TinkerLoadLibrary;
import com.tencent.tinker.lib.listener.PatchListener;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.patch.UpgradePatch;
import com.tencent.tinker.lib.reporter.LoadReporter;
import com.tencent.tinker.lib.reporter.PatchReporter;
import com.tencent.tinker.lib.service.AbstractResultService;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.app.ApplicationLike;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tinkerpatch.sdk.a.d;
import com.tinkerpatch.sdk.a.f;
import com.tinkerpatch.sdk.server.a;
import com.tinkerpatch.sdk.server.callback.ConfigRequestCallback;
import com.tinkerpatch.sdk.server.callback.PatchRequestCallback;
import com.tinkerpatch.sdk.server.callback.RollbackCallBack;
import com.tinkerpatch.sdk.server.callback.TinkerPatchRequestCallback;
import com.tinkerpatch.sdk.tinker.c.b;
import com.tinkerpatch.sdk.tinker.c.c;
import com.tinkerpatch.sdk.tinker.callback.ResultCallBack;
import com.tinkerpatch.sdk.tinker.service.TinkerServerResultService;
import java.util.HashSet;

public class TinkerPatch {
    private static final String TAG = "Tinker.TinkerPatch";
    private static TinkerPatch sInstance;
    private final Tinker tinkerClient;
    private final a tinkerServerClient;
    private final ApplicationLike applicationLike;
    private final Context context;

    public TinkerPatch(Context context, ApplicationLike applicationLike, LoadReporter loadReporter, PatchReporter patchReporter, PatchListener patchListener, AbstractPatch abstractPatch, Class<? extends AbstractResultService> clazz, PatchRequestCallback patchRequestCallback) {
        this.context = context;
        this.applicationLike = applicationLike;
        if (com.tinkerpatch.sdk.server.d.d.b(context) == null || com.tinkerpatch.sdk.server.d.d.a(context) == null) {
            TinkerLog.e(TAG, "can get appVersion or appKey from manifest, just disable TinkerPatch SDK", new Object[0]);
            this.tinkerServerClient = null;
            this.tinkerClient = null;
            return;
        }
        f.a(context);
        Thread.setDefaultUncaughtExceptionHandler(new com.tinkerpatch.sdk.tinker.a.a(this.applicationLike));
        this.tinkerServerClient = a.a(this.context, patchRequestCallback);
        this.tinkerClient = TinkerInstaller.install(applicationLike, loadReporter, patchReporter, patchListener, clazz, abstractPatch);
    }

    public static void setLogIml(TinkerLog.TinkerLogImp tinkerLogImp) {
        TinkerLog.setTinkerLogImp(tinkerLogImp);
    }

    public static TinkerPatch init(ApplicationLike applicationLike) {
        if (sInstance != null) {
            throw new TinkerRuntimeException("TinkerPatch instance is already set.");
        }
        sInstance = new Builder(applicationLike).build();
        return sInstance;
    }

    public static TinkerPatch init(TinkerPatch tinkerPatch) {
        if (tinkerPatch == null) {
            throw new TinkerRuntimeException("TinkerPatch init, tinkerPatch should not be null.");
        }
        if (sInstance != null) {
            throw new TinkerRuntimeException("TinkerPatch instance is already set.");
        }
        sInstance = tinkerPatch;
        return sInstance;
    }

    public static TinkerPatch with() {
        if (sInstance == null) {
            throw new TinkerRuntimeException("you must init TinkerPatch sdk first");
        }
        return sInstance;
    }

    public ApplicationLike getApplcationLike() {
        if (this.applicationLike == null) {
            throw new TinkerRuntimeException("you must init TinkerPatch sdk first.");
        }
        return this.applicationLike;
    }

    public TinkerPatch reflectPatchLibrary() {
        Context context = this.context;
        Object object = Tinker.with(context);
        if (((Tinker)object).isTinkerLoaded()) {
            object = ((Tinker)object).getTinkerLoadResultIfPresent();
            if (((TinkerLoadResult)object).libs != null) {
                HashSet<String> hashSet = new HashSet<String>();
                for (String string : ((TinkerLoadResult)object).libs.keySet()) {
                    if (!string.startsWith("lib/") || !string.endsWith(".so")) continue;
                    String[] stringArray = string.split("/", 3);
                    hashSet.add(stringArray[1]);
                }
                object = f.a().d();
                TinkerLog.i("Tinker.ReflectLibrary", "attachPatchNative, getCurrentABI:" + (String)object, new Object[0]);
                if (((String)object).equals("unknown")) {
                    TinkerLog.i("Tinker.ReflectLibrary", "currentABI is unknown, just return", new Object[0]);
                } else if (hashSet.contains(object)) {
                    TinkerLoadLibrary.installNavitveLibraryABI(context, (String)object);
                }
            }
        }
        return sInstance;
    }

    public TinkerPatch fetchDynamicConfig(ConfigRequestCallback configRequestCallback, boolean bl) {
        if (this.tinkerServerClient == null || this.tinkerClient == null) {
            TinkerLog.e(TAG, "fetchDynamicConfig, tinkerServerClient or tinkerClient is null, just return", new Object[0]);
            return sInstance;
        }
        if (!a.a(this.context)) {
            TinkerLog.e(TAG, "fetchDynamicConfig, permission refuse, you must access INTERNET and ACCESS_NETWORK_STATE permission first", new Object[0]);
            return sInstance;
        }
        if (this.tinkerClient.isMainProcess()) {
            Looper.getMainLooper();
            Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(this, configRequestCallback, bl){
                private /* synthetic */ ConfigRequestCallback a;
                private /* synthetic */ boolean b;
                private /* synthetic */ TinkerPatch c;
                {
                    this.c = tinkerPatch;
                    this.a = configRequestCallback;
                    this.b = bl;
                }

                public final boolean queueIdle() {
                    this.c.tinkerServerClient.a(this.a, this.b);
                    return false;
                }
            });
        }
        return sInstance;
    }

    public TinkerPatch fetchPatchUpdate(boolean bl) {
        if (this.tinkerServerClient == null || this.tinkerClient == null) {
            TinkerLog.e(TAG, "fetchPatchUpdate, tinkerServerClient or tinkerClient is null, just return", new Object[0]);
            return sInstance;
        }
        if (!a.a(this.context)) {
            TinkerLog.e(TAG, "fetchPatchUpdate, permission refuse, you must access INTERNET and ACCESS_NETWORK_STATE permission first", new Object[0]);
            return sInstance;
        }
        if (!this.tinkerClient.isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences(this.context)) {
            TinkerLog.e(TAG, "fetchPatchUpdate, tinker is disable, just return", new Object[0]);
            return sInstance;
        }
        if (this.tinkerClient.isMainProcess()) {
            Looper.getMainLooper();
            Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(this, bl){
                private /* synthetic */ boolean a;
                private /* synthetic */ TinkerPatch b;
                {
                    this.b = tinkerPatch;
                    this.a = bl;
                }

                public final boolean queueIdle() {
                    this.b.tinkerServerClient.a(this.a);
                    return false;
                }
            });
        }
        return sInstance;
    }

    public TinkerPatch setAppChannel(String string) {
        if (this.tinkerServerClient == null) {
            TinkerLog.e(TAG, "setAppChannel, tinkerServerClient == null, just return", new Object[0]);
            return sInstance;
        }
        d.a(string);
        this.tinkerServerClient.a("channel", string);
        return sInstance;
    }

    public TinkerPatch addIgnoreAppChannel(String string) {
        d.b(string);
        return sInstance;
    }

    public TinkerPatch setPatchCondition(String string, String string2) {
        if (this.tinkerServerClient == null) {
            TinkerLog.e(TAG, "setPatchCondition, tinkerServerClient == null, just return", new Object[0]);
            return sInstance;
        }
        this.tinkerServerClient.a(string, string2);
        return sInstance;
    }

    public TinkerPatch setFetchDynamicConfigIntervalByHours(int n) {
        if (this.tinkerServerClient == null) {
            TinkerLog.e(TAG, "setFetchDynamicConfigIntervalByHours, tinkerServerClient == null, just return", new Object[0]);
            return sInstance;
        }
        this.tinkerServerClient.b(n);
        return sInstance;
    }

    public TinkerPatch setFetchPatchIntervalByHours(int n) {
        if (this.tinkerServerClient == null) {
            TinkerLog.e(TAG, "setFetchPatchIntervalByHours, tinkerServerClient == null, just return", new Object[0]);
            return sInstance;
        }
        this.tinkerServerClient.a(n);
        return sInstance;
    }

    public TinkerPatch setPatchRestartOnSrceenOff(boolean bl) {
        if (this.tinkerClient == null) {
            TinkerLog.e(TAG, "setPatchRestartConfig, tinkerClient is null, just return", new Object[0]);
            return sInstance;
        }
        TinkerServerResultService.a(bl);
        return sInstance;
    }

    public TinkerPatch setPatchResultCallback(ResultCallBack resultCallBack) {
        if (this.tinkerClient == null) {
            TinkerLog.e(TAG, "setPatchRestartConfig, tinkerClient is null, just return", new Object[0]);
            return sInstance;
        }
        TinkerServerResultService.a(resultCallBack);
        return sInstance;
    }

    public TinkerPatch setPatchRollbackOnScreenOff(boolean bl) {
        if (this.tinkerClient == null) {
            TinkerLog.e(TAG, "setPatchRollbackOnScreenOff, tinkerClient is null, just return", new Object[0]);
            return sInstance;
        }
        TinkerPatchRequestCallback.setRollbackOnScreenOff(bl);
        return sInstance;
    }

    public TinkerPatch setPatchRollBackCallback(RollbackCallBack rollbackCallBack) {
        if (this.tinkerClient == null) {
            TinkerLog.e(TAG, "setPatchRestartConfig, tinkerClient is null, just return", new Object[0]);
            return sInstance;
        }
        TinkerPatchRequestCallback.setPatchRollbackCallBack(rollbackCallBack);
        return sInstance;
    }

    public TinkerPatch cleanPatch() {
        if (this.tinkerClient == null) {
            TinkerLog.e(TAG, "cleanPatch, tinkerClient is null, just return", new Object[0]);
            return sInstance;
        }
        this.tinkerClient.cleanPatch();
        return sInstance;
    }

    public static class Builder {
        private final Context context;
        private final ApplicationLike applicationLike;
        private LoadReporter loadReporter;
        private PatchReporter patchReporter;
        private PatchListener listener;
        private AbstractPatch upgradePatch;
        private Class<? extends AbstractResultService> serviceClass;
        private PatchRequestCallback patchRequestCallback;

        public Builder(ApplicationLike applicationLike) {
            if (applicationLike == null) {
                throw new TinkerRuntimeException("applicationLike must not be null.");
            }
            this.context = applicationLike.getApplication();
            this.applicationLike = applicationLike;
        }

        public Builder loadReporter(LoadReporter loadReporter) {
            if (loadReporter == null) {
                throw new TinkerRuntimeException("loadReporter must not be null.");
            }
            if (this.loadReporter != null) {
                throw new TinkerRuntimeException("loadReporter is already set.");
            }
            this.loadReporter = loadReporter;
            return this;
        }

        public Builder patchReporter(PatchReporter patchReporter) {
            if (patchReporter == null) {
                throw new TinkerRuntimeException("patchReporter must not be null.");
            }
            if (this.patchReporter != null) {
                throw new TinkerRuntimeException("patchReporter is already set.");
            }
            this.patchReporter = patchReporter;
            return this;
        }

        public Builder listener(PatchListener patchListener) {
            if (patchListener == null) {
                throw new TinkerRuntimeException("listener must not be null.");
            }
            if (this.listener != null) {
                throw new TinkerRuntimeException("listener is already set.");
            }
            this.listener = patchListener;
            return this;
        }

        public Builder upgradePatch(AbstractPatch abstractPatch) {
            if (abstractPatch == null) {
                throw new TinkerRuntimeException("upgradePatch must not be null.");
            }
            if (this.upgradePatch != null) {
                throw new TinkerRuntimeException("upgradePatch is already set.");
            }
            this.upgradePatch = abstractPatch;
            return this;
        }

        public Builder resultServiceClass(Class<? extends AbstractResultService> clazz) {
            if (clazz == null) {
                throw new TinkerRuntimeException("resultServiceClass must not be null.");
            }
            if (this.serviceClass != null) {
                throw new TinkerRuntimeException("resultServiceClass is already set.");
            }
            this.serviceClass = clazz;
            return this;
        }

        public Builder patchRequestCallback(PatchRequestCallback patchRequestCallback) {
            if (patchRequestCallback == null) {
                throw new TinkerRuntimeException("patchRequestCallback must not be null.");
            }
            if (this.patchRequestCallback != null) {
                throw new TinkerRuntimeException("patchRequestCallback is already set.");
            }
            this.patchRequestCallback = patchRequestCallback;
            return this;
        }

        public TinkerPatch build() {
            if (this.loadReporter == null) {
                this.loadReporter = new com.tinkerpatch.sdk.tinker.c.a(this.context);
            }
            if (this.patchReporter == null) {
                this.patchReporter = new c(this.context);
            }
            if (this.listener == null) {
                this.listener = new b(this.context);
            }
            if (this.upgradePatch == null) {
                this.upgradePatch = new UpgradePatch();
            }
            if (this.serviceClass == null) {
                this.serviceClass = TinkerServerResultService.class;
            }
            if (this.patchRequestCallback == null) {
                this.patchRequestCallback = new TinkerPatchRequestCallback();
            }
            return new TinkerPatch(this.context, this.applicationLike, this.loadReporter, this.patchReporter, this.listener, this.upgradePatch, this.serviceClass, this.patchRequestCallback);
        }
    }
}

