/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.Build;
import com.tencent.tinker.lib.patch.AbstractPatch;
import com.tencent.tinker.lib.patch.BsDiffPatchInternal;
import com.tencent.tinker.lib.patch.DexDiffPatchInternal;
import com.tencent.tinker.lib.patch.ResDiffPatchInternal;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.io.IOException;

public class UpgradePatch
extends AbstractPatch {
    private static final String TAG = "Tinker.UpgradePatch";

    @Override
    public boolean tryPatch(Context object, String object2, PatchResult object3) {
        Tinker tinker = Tinker.with(object);
        object2 = new File((String)object2);
        if (!tinker.isTinkerEnabled() || !ShareTinkerInternals.isTinkerEnableWithSharedPreferences(object)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch is disabled, just return", new Object[0]);
            return false;
        }
        if (!SharePatchFileUtil.isLegalFile((File)object2)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch file is not found, just return", new Object[0]);
            return false;
        }
        ShareSecurityCheck shareSecurityCheck = new ShareSecurityCheck((Context)object);
        int n = ShareTinkerInternals.checkTinkerPackage(object, tinker.getTinkerFlags(), (File)object2, shareSecurityCheck);
        if (n != 0) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchPackageCheckFail", new Object[0]);
            tinker.getPatchReporter().onPatchPackageCheckFail((File)object2, n);
            return false;
        }
        Object object4 = tinker.getTinkerLoadResultIfPresent().patchInfo;
        String string = SharePatchFileUtil.getMD5((File)object2);
        if (string == null) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:patch md5 is null, just return", new Object[0]);
            return false;
        }
        ((PatchResult)object3).patchVersion = string;
        if (object4 != null) {
            if (((SharePatchInfo)object4).oldVersion == null || ((SharePatchInfo)object4).newVersion == null) {
                TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchInfoCorrupted", new Object[0]);
                tinker.getPatchReporter().onPatchInfoCorrupted((File)object2, ((SharePatchInfo)object4).oldVersion, ((SharePatchInfo)object4).newVersion);
                return false;
            }
            if (!SharePatchFileUtil.checkIfMd5Valid(string)) {
                TinkerLog.e(TAG, "UpgradePatch tryPatch:onPatchVersionCheckFail md5 %s is valid", string);
                tinker.getPatchReporter().onPatchVersionCheckFail((File)object2, (SharePatchInfo)object4, string);
                return false;
            }
            object3 = new SharePatchInfo(((SharePatchInfo)object4).oldVersion, string, Build.FINGERPRINT);
        } else {
            object3 = new SharePatchInfo("", string, Build.FINGERPRINT);
        }
        object4 = tinker.getPatchDirectory().getAbsolutePath();
        TinkerLog.i(TAG, "UpgradePatch tryPatch:patchMd5:%s", string);
        String string2 = SharePatchFileUtil.getPatchVersionDirectory(string);
        string2 = (String)object4 + "/" + string2;
        TinkerLog.i(TAG, "UpgradePatch tryPatch:patchVersionDirectory:%s", string2);
        File file = new File(string2 + "/" + SharePatchFileUtil.getPatchVersionFile(string));
        try {
            if (!string.equals(SharePatchFileUtil.getMD5(file))) {
                SharePatchFileUtil.copyFileUsingStream((File)object2, file);
                TinkerLog.w(TAG, "UpgradePatch copy patch file, src file: %s size: %d, dest file: %s size:%d", ((File)object2).getAbsolutePath(), ((File)object2).length(), file.getAbsolutePath(), file.length());
            }
        }
        catch (IOException iOException) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:copy patch file fail from %s to %s", ((File)object2).getPath(), file.getPath());
            tinker.getPatchReporter().onPatchTypeExtractFail((File)object2, file, ((File)object2).getName(), 1);
            return false;
        }
        if (!DexDiffPatchInternal.tryRecoverDexFiles(tinker, shareSecurityCheck, object, string2, file)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch dex failed", new Object[0]);
            return false;
        }
        if (!BsDiffPatchInternal.tryRecoverLibraryFiles(tinker, shareSecurityCheck, object, string2, file)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch library failed", new Object[0]);
            return false;
        }
        if (!ResDiffPatchInternal.tryRecoverResourceFiles(tinker, shareSecurityCheck, object, string2, file)) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, try patch resource failed", new Object[0]);
            return false;
        }
        if (!DexDiffPatchInternal.waitDexOptFile()) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, check dex opt file failed", new Object[0]);
        }
        if (!SharePatchInfo.rewritePatchInfoFileWithLock((File)(object = tinker.getPatchInfoFile()), (SharePatchInfo)object3, SharePatchFileUtil.getPatchInfoLockFile((String)object4))) {
            TinkerLog.e(TAG, "UpgradePatch tryPatch:new patch recover, rewrite patch info failed", new Object[0]);
            tinker.getPatchReporter().onPatchInfoCorrupted((File)object2, ((SharePatchInfo)object3).oldVersion, ((SharePatchInfo)object3).newVersion);
            return false;
        }
        TinkerLog.w(TAG, "UpgradePatch tryPatch: done, it is ok", new Object[0]);
        return true;
    }
}

