/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dx.instruction;

import com.tencent.tinker.android.dx.instruction.CodeCursor;

public final class ShortArrayCodeOutput
extends CodeCursor {
    private short[] array;

    public ShortArrayCodeOutput(int initSize) {
        if (initSize < 0) {
            throw new IllegalArgumentException("initSize < 0");
        }
        this.array = new short[initSize];
    }

    public ShortArrayCodeOutput(short[] array) {
        if (array == null) {
            throw new IllegalArgumentException("array is null.");
        }
        this.array = array;
    }

    public short[] getArray() {
        int cursor = this.cursor();
        if (cursor == this.array.length) {
            return this.array;
        }
        short[] result = new short[cursor];
        System.arraycopy(this.array, 0, result, 0, cursor);
        return result;
    }

    public void write(short codeUnit) {
        this.ensureArrayLength(1);
        this.array[this.cursor()] = codeUnit;
        this.advance(1);
    }

    public void write(short u0, short u1) {
        this.write(u0);
        this.write(u1);
    }

    public void write(short u0, short u1, short u2) {
        this.write(u0);
        this.write(u1);
        this.write(u2);
    }

    public void write(short u0, short u1, short u2, short u3) {
        this.write(u0);
        this.write(u1);
        this.write(u2);
        this.write(u3);
    }

    public void write(short u0, short u1, short u2, short u3, short u4) {
        this.write(u0);
        this.write(u1);
        this.write(u2);
        this.write(u3);
        this.write(u4);
    }

    public void writeInt(int value) {
        this.write((short)value);
        this.write((short)(value >> 16));
    }

    public void writeLong(long value) {
        this.write((short)value);
        this.write((short)(value >> 16));
        this.write((short)(value >> 32));
        this.write((short)(value >> 48));
    }

    public void write(byte[] data) {
        int value = 0;
        boolean even = true;
        for (byte b : data) {
            if (even) {
                value = b & 0xFF;
                even = false;
                continue;
            }
            this.write((short)(value |= b << 8));
            even = true;
        }
        if (!even) {
            this.write((short)value);
        }
    }

    public void write(short[] data) {
        for (short unit : data) {
            this.write(unit);
        }
    }

    public void write(int[] data) {
        for (int i : data) {
            this.writeInt(i);
        }
    }

    public void write(long[] data) {
        for (long l : data) {
            this.writeLong(l);
        }
    }

    private void ensureArrayLength(int shortCountToWrite) {
        int currPos = this.cursor();
        if (this.array.length - currPos < shortCountToWrite) {
            short[] newArray = new short[this.array.length + (this.array.length >> 1)];
            System.arraycopy(this.array, 0, newArray, 0, currPos);
            this.array = newArray;
        }
    }
}

