/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.algorithms.patch;

import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.commons.dexpatcher.struct.DexPatchFile;
import com.tencent.tinker.commons.dexpatcher.util.AbstractIndexMap;
import com.tencent.tinker.commons.dexpatcher.util.SparseIndexMap;
import java.util.Arrays;

public abstract class DexSectionPatchAlgorithm<T extends Comparable<T>> {
    protected final DexPatchFile patchFile;
    protected final Dex oldDex;
    private final SparseIndexMap oldToPatchedIndexMap;

    public DexSectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, SparseIndexMap oldToPatchedIndexMap) {
        this.patchFile = patchFile;
        this.oldDex = oldDex;
        this.oldToPatchedIndexMap = oldToPatchedIndexMap;
    }

    protected abstract TableOfContents.Section getTocSection(Dex var1);

    protected abstract T nextItem(DexDataBuffer var1);

    protected abstract int getItemSize(T var1);

    protected T adjustItem(AbstractIndexMap indexMap, T item) {
        return item;
    }

    protected void updateIndexOrOffset(SparseIndexMap sparseIndexMap, int oldIndex, int oldOffset, int newIndex, int newOffset) {
    }

    protected void markDeletedIndexOrOffset(SparseIndexMap sparseIndexMap, int deletedIndex, int deletedOffset) {
    }

    protected abstract int writePatchedItem(T var1);

    private int[] readDeltaIndiciesOrOffsets(int count) {
        int[] result = new int[count];
        int lastVal = 0;
        for (int i = 0; i < count; ++i) {
            int delta = this.patchFile.getBuffer().readSleb128();
            result[i] = lastVal += delta;
        }
        return result;
    }

    private int getItemOffsetOrIndex(int index, T item) {
        if (item instanceof TableOfContents.Section.Item) {
            return ((TableOfContents.Section.Item)item).off;
        }
        return index;
    }

    public void execute() {
        int deletedItemCount = this.patchFile.getBuffer().readUleb128();
        int[] deletedIndices = this.readDeltaIndiciesOrOffsets(deletedItemCount);
        int addedItemCount = this.patchFile.getBuffer().readUleb128();
        int[] addedIndices = this.readDeltaIndiciesOrOffsets(addedItemCount);
        int replacedItemCount = this.patchFile.getBuffer().readUleb128();
        int[] replacedIndices = this.readDeltaIndiciesOrOffsets(replacedItemCount);
        TableOfContents.Section tocSec = this.getTocSection(this.oldDex);
        Dex.Section oldSection = null;
        int oldItemCount = 0;
        if (tocSec.exists()) {
            oldSection = this.oldDex.openSection(tocSec);
            oldItemCount = tocSec.size;
        }
        this.doFullPatch(oldSection, oldItemCount, deletedIndices, addedIndices, replacedIndices);
    }

    private void doFullPatch(Dex.Section oldSection, int oldItemCount, int[] deletedIndices, int[] addedIndices, int[] replacedIndices) {
        int deletedItemCount = deletedIndices.length;
        int addedItemCount = addedIndices.length;
        int replacedItemCount = replacedIndices.length;
        int newItemCount = oldItemCount + addedItemCount - deletedItemCount;
        int deletedItemCounter = 0;
        int addActionCursor = 0;
        int replaceActionCursor = 0;
        int oldIndex = 0;
        int patchedIndex = 0;
        while (oldIndex < oldItemCount || patchedIndex < newItemCount) {
            T skippedOldItem;
            int patchedOffset;
            if (addActionCursor < addedItemCount && addedIndices[addActionCursor] == patchedIndex) {
                T addedItem = this.nextItem(this.patchFile.getBuffer());
                patchedOffset = this.writePatchedItem(addedItem);
                ++addActionCursor;
                ++patchedIndex;
                continue;
            }
            if (replaceActionCursor < replacedItemCount && replacedIndices[replaceActionCursor] == patchedIndex) {
                T replacedItem = this.nextItem(this.patchFile.getBuffer());
                patchedOffset = this.writePatchedItem(replacedItem);
                ++replaceActionCursor;
                ++patchedIndex;
                continue;
            }
            if (Arrays.binarySearch(deletedIndices, oldIndex) >= 0) {
                skippedOldItem = this.nextItem((DexDataBuffer)oldSection);
                this.markDeletedIndexOrOffset(this.oldToPatchedIndexMap, oldIndex, this.getItemOffsetOrIndex(oldIndex, skippedOldItem));
                ++oldIndex;
                ++deletedItemCounter;
                continue;
            }
            if (Arrays.binarySearch(replacedIndices, oldIndex) >= 0) {
                skippedOldItem = this.nextItem((DexDataBuffer)oldSection);
                this.markDeletedIndexOrOffset(this.oldToPatchedIndexMap, oldIndex, this.getItemOffsetOrIndex(oldIndex, skippedOldItem));
                ++oldIndex;
                continue;
            }
            if (oldIndex >= oldItemCount) continue;
            T oldItem = this.adjustItem(this.oldToPatchedIndexMap, this.nextItem((DexDataBuffer)oldSection));
            patchedOffset = this.writePatchedItem(oldItem);
            this.updateIndexOrOffset(this.oldToPatchedIndexMap, oldIndex, this.getItemOffsetOrIndex(oldIndex, oldItem), patchedIndex, patchedOffset);
            ++oldIndex;
            ++patchedIndex;
        }
        if (addActionCursor != addedItemCount || deletedItemCounter != deletedItemCount || replaceActionCursor != replacedItemCount) {
            throw new IllegalStateException(String.format("bad patch operation sequence. addCounter: %d, addCount: %d, delCounter: %d, delCount: %d, replaceCounter: %d, replaceCount:%d", addActionCursor, addedItemCount, deletedItemCounter, deletedItemCount, replaceActionCursor, replacedItemCount));
        }
    }
}

