/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.app.Activity;
import android.app.Application;
import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.IBinder;
import android.view.ContextThemeWrapper;
import com.tencent.tinker.loader.shareutil.InstrumentationProxy;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.reflect.Field;

public class ActivityResFixInstrumentation
extends InstrumentationProxy {
    private static Field mResourcesField = null;
    private final Context mContext;

    public ActivityResFixInstrumentation(Context context, Instrumentation instrumentation) {
        super(instrumentation);
        this.mContext = context;
        mResourcesField = ShareReflectUtil.findField(ContextThemeWrapper.class, "mResources");
    }

    @Override
    public Activity newActivity(ClassLoader classLoader, String string, Intent intent) {
        classLoader = super.newActivity(classLoader, string, intent);
        this.replaceResources((ContextThemeWrapper)classLoader);
        return classLoader;
    }

    @Override
    public Activity newActivity(Class<?> activity, Context context, IBinder iBinder, Application application, Intent intent, ActivityInfo activityInfo, CharSequence charSequence, Activity activity2, String string, Object object) {
        activity = super.newActivity((Class<?>)activity, context, iBinder, application, intent, activityInfo, charSequence, activity2, string, object);
        this.replaceResources((ContextThemeWrapper)activity);
        return activity;
    }

    private void replaceResources(ContextThemeWrapper contextThemeWrapper) {
        if (contextThemeWrapper == null) {
            return;
        }
        try {
            mResourcesField.set(contextThemeWrapper, this.mContext.getApplicationContext().getResources());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            new IllegalStateException("cannot access 'mResources' field of component " + contextThemeWrapper);
            return;
        }
    }
}

