/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.app;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import com.tencent.tinker.loader.TinkerLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerUncaughtHandler;
import com.tencent.tinker.loader.app.ApplicationLike;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;

public abstract class TinkerApplication
extends Application {
    private static final int TINKER_DISABLE = 0;
    private static final String INTENT_PATCH_EXCEPTION = "intent_patch_exception";
    private static final String TINKER_LOADER_METHOD = "tryLoad";
    private final int tinkerFlags;
    private final boolean tinkerLoadVerifyFlag;
    private final String delegateClassName;
    private final String loaderClassName;
    private boolean useSafeMode;
    private Intent tinkerResultIntent;
    private ApplicationLike applicationLike = null;
    private long applicationStartElapsedTime;
    private long applicationStartMillisTime;

    protected TinkerApplication(int n) {
        this(n, "com.tencent.tinker.loader.app.DefaultApplicationLike", TinkerLoader.class.getName(), false);
    }

    protected TinkerApplication(int n, String string, String string2, boolean bl) {
        this.tinkerFlags = n;
        this.delegateClassName = string;
        this.loaderClassName = string2;
        this.tinkerLoadVerifyFlag = bl;
    }

    protected TinkerApplication(int n, String string) {
        this(n, string, TinkerLoader.class.getName(), false);
    }

    private ApplicationLike createDelegate() {
        try {
            GenericDeclaration genericDeclaration = Class.forName(this.delegateClassName, false, this.getClassLoader());
            genericDeclaration = genericDeclaration.getConstructor(Application.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Intent.class);
            return (ApplicationLike)((Constructor)genericDeclaration).newInstance(new Object[]{this, this.tinkerFlags, this.tinkerLoadVerifyFlag, this.applicationStartElapsedTime, this.applicationStartMillisTime, this.tinkerResultIntent});
        }
        catch (Throwable throwable) {
            throw new TinkerRuntimeException("createDelegate failed", throwable);
        }
    }

    private synchronized void ensureDelegate() {
        if (this.applicationLike == null) {
            this.applicationLike = this.createDelegate();
        }
    }

    private void onBaseContextAttached(Context object) {
        this.applicationStartElapsedTime = SystemClock.elapsedRealtime();
        this.applicationStartMillisTime = System.currentTimeMillis();
        this.loadTinker();
        this.ensureDelegate();
        this.applicationLike.onBaseContextAttached((Context)object);
        if (this.useSafeMode) {
            object = ShareTinkerInternals.getProcessName((Context)this);
            object = "tinker_own_config_" + (String)object;
            object = this.getSharedPreferences((String)object, 0);
            object.edit().putInt("safe_mode_count", 0).commit();
        }
    }

    protected void attachBaseContext(Context context) {
        super.attachBaseContext(context);
        Thread.setDefaultUncaughtExceptionHandler(new TinkerUncaughtHandler((Context)this));
        this.onBaseContextAttached(context);
    }

    private void loadTinker() {
        if (this.tinkerFlags == 0) {
            return;
        }
        this.tinkerResultIntent = new Intent();
        try {
            GenericDeclaration genericDeclaration = Class.forName(this.loaderClassName, false, this.getClassLoader());
            Method method = ((Class)genericDeclaration).getMethod(TINKER_LOADER_METHOD, TinkerApplication.class, Integer.TYPE, Boolean.TYPE);
            genericDeclaration = ((Class)genericDeclaration).getConstructor(new Class[0]);
            this.tinkerResultIntent = (Intent)method.invoke(((Constructor)genericDeclaration).newInstance(new Object[0]), new Object[]{this, this.tinkerFlags, this.tinkerLoadVerifyFlag});
            return;
        }
        catch (Throwable throwable) {
            ShareIntentUtil.setIntentReturnCode(this.tinkerResultIntent, -19);
            this.tinkerResultIntent.putExtra(INTENT_PATCH_EXCEPTION, (Serializable)throwable);
            return;
        }
    }

    public void onCreate() {
        super.onCreate();
        this.ensureDelegate();
        this.applicationLike.onCreate();
    }

    public void onTerminate() {
        super.onTerminate();
        if (this.applicationLike != null) {
            this.applicationLike.onTerminate();
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.applicationLike != null) {
            this.applicationLike.onLowMemory();
        }
    }

    @TargetApi(value=14)
    public void onTrimMemory(int n) {
        super.onTrimMemory(n);
        if (this.applicationLike != null) {
            this.applicationLike.onTrimMemory(n);
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.applicationLike != null) {
            this.applicationLike.onConfigurationChanged(configuration);
        }
    }

    public Resources getResources() {
        Resources resources = super.getResources();
        if (this.applicationLike != null) {
            return this.applicationLike.getResources(resources);
        }
        return resources;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = super.getClassLoader();
        if (this.applicationLike != null) {
            return this.applicationLike.getClassLoader(classLoader);
        }
        return classLoader;
    }

    public AssetManager getAssets() {
        AssetManager assetManager = super.getAssets();
        if (this.applicationLike != null) {
            return this.applicationLike.getAssets(assetManager);
        }
        return assetManager;
    }

    public Object getSystemService(String string) {
        Object object = super.getSystemService(string);
        if (this.applicationLike != null) {
            return this.applicationLike.getSystemService(string, object);
        }
        return object;
    }

    public void setUseSafeMode(boolean bl) {
        this.useSafeMode = bl;
    }
}

