/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.app.Instrumentation;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ActivityResFixInstrumentation;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class TinkerResourcePatcher {
    private static final String TAG = "Tinker.ResourcePatcher";
    private static final String TEST_ASSETS_VALUE = "only_use_to_test_tinker_resource.txt";
    private static Collection<WeakReference<Resources>> references;
    private static AssetManager newAssetManager;
    private static Method addAssetPathMethod;
    private static Method ensureStringBlocksMethod;
    private static Field assetsFiled;
    private static Field resourcesImplFiled;
    private static Field resDir;
    private static Field packagesFiled;
    private static Field resourcePackagesFiled;
    private static Field instrumentationField;
    private static Field publicSourceDirField;

    TinkerResourcePatcher() {
    }

    public static void isResourceCanPatch(Context object) {
        Object object2;
        Class<?> clazz = Class.forName("android.app.ActivityThread");
        try {
            object2 = Class.forName("android.app.LoadedApk");
        }
        catch (ClassNotFoundException classNotFoundException) {
            object2 = Class.forName("android.app.ActivityThread$PackageInfo");
        }
        Field field = ((Class)object2).getDeclaredField("mApplication");
        field.setAccessible(true);
        resDir = ((Class)object2).getDeclaredField("mResDir");
        resDir.setAccessible(true);
        packagesFiled = clazz.getDeclaredField("mPackages");
        packagesFiled.setAccessible(true);
        resourcePackagesFiled = clazz.getDeclaredField("mResourcePackages");
        resourcePackagesFiled.setAccessible(true);
        object2 = object.getAssets();
        if (object2.getClass().getName().equals("android.content.res.BaiduAssetManager")) {
            object2 = Class.forName("android.content.res.BaiduAssetManager");
            newAssetManager = (AssetManager)((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            newAssetManager = (AssetManager)AssetManager.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        addAssetPathMethod = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
        addAssetPathMethod.setAccessible(true);
        ensureStringBlocksMethod = AssetManager.class.getDeclaredMethod("ensureStringBlocks", new Class[0]);
        ensureStringBlocksMethod.setAccessible(true);
        if (Build.VERSION.SDK_INT >= 19) {
            object2 = Class.forName("android.app.ResourcesManager");
            object = ((Class)object2).getDeclaredMethod("getInstance", new Class[0]);
            ((Method)object).setAccessible(true);
            object = ((Method)object).invoke(null, new Object[0]);
            try {
                field = ((Class)object2).getDeclaredField("mActiveResources");
                field.setAccessible(true);
                field = (ArrayMap)field.get(object);
                references = field.values();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = ((Class)object2).getDeclaredField("mResourceReferences");
                field.setAccessible(true);
                references = (Collection)field.get(object);
            }
        } else {
            object2 = clazz.getDeclaredField("mActiveResources");
            ((Field)object2).setAccessible(true);
            object = ShareReflectUtil.getActivityThread((Context)object, clazz);
            object = (HashMap)((Field)object2).get(object);
            references = ((HashMap)object).values();
        }
        if (references == null) {
            throw new IllegalStateException("resource references is null");
        }
        try {
            assetsFiled = Resources.class.getDeclaredField("mAssets");
            assetsFiled.setAccessible(true);
        }
        catch (Throwable throwable) {
            resourcesImplFiled = Resources.class.getDeclaredField("mResourcesImpl");
            resourcesImplFiled.setAccessible(true);
        }
        try {
            instrumentationField = ShareReflectUtil.findField(clazz, "mInstrumentation");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException("cannot find 'mInstrumentation' field");
        }
        try {
            publicSourceDirField = ShareReflectUtil.findField(ApplicationInfo.class, "publicSourceDir");
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException("cannot find 'mInstrumentation' field");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void monkeyPatchExistingResources(Context context, String string) {
        block10: {
            void weakReference;
            if (string == null) {
                return;
            }
            Object object2 = Class.forName("android.app.ActivityThread");
            object2 = ShareReflectUtil.getActivityThread(context, object2);
            Object object3 = new Field[]{packagesFiled, resourcePackagesFiled};
            boolean i = false;
            while (weakReference < 2) {
                Field field = object3[weakReference];
                Object object = field.get(object2);
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    Object t = ((WeakReference)entry.getValue()).get();
                    if (t == null || string == null) continue;
                    resDir.set(t, string);
                }
                ++weakReference;
            }
            if ((Integer)addAssetPathMethod.invoke((Object)newAssetManager, string) == 0) {
                throw new IllegalStateException("Could not create new AssetManager");
            }
            ensureStringBlocksMethod.invoke((Object)newAssetManager, new Object[0]);
            for (WeakReference activityResFixInstrumentation : references) {
                Resources resources = (Resources)activityResFixInstrumentation.get();
                if (resources == null) continue;
                try {
                    assetsFiled.set(resources, newAssetManager);
                }
                catch (Throwable throwable) {
                    Object object = resourcesImplFiled.get(resources);
                    Field field = ShareReflectUtil.findField(object, "mAssets");
                    field.setAccessible(true);
                    field.set(object, newAssetManager);
                }
                resources.updateConfiguration(resources.getConfiguration(), resources.getDisplayMetrics());
            }
            try {
                object3 = (Instrumentation)instrumentationField.get(object2);
                ActivityResFixInstrumentation activityResFixInstrumentation = new ActivityResFixInstrumentation(context, (Instrumentation)object3);
                instrumentationField.set(object2, (Object)activityResFixInstrumentation);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (Build.VERSION.SDK_INT < 17) break block10;
                throw noSuchFieldException;
            }
        }
        publicSourceDirField.set(context.getApplicationInfo(), string);
        if (!TinkerResourcePatcher.checkResUpdate(context)) {
            throw new TinkerRuntimeException("checkResInstall failed");
        }
    }

    private static boolean checkResUpdate(Context context) {
        try {
            Log.e((String)TAG, (String)"checkResUpdate success, found test resource assets file only_use_to_test_tinker_resource.txt");
            context.getAssets().open(TEST_ASSETS_VALUE);
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)("checkResUpdate failed, can't find test resource assets file only_use_to_test_tinker_resource.txt e:" + throwable.getMessage()));
            return false;
        }
        return true;
    }

    static {
        newAssetManager = null;
        addAssetPathMethod = null;
        ensureStringBlocksMethod = null;
        assetsFiled = null;
        resourcesImplFiled = null;
        resDir = null;
        packagesFiled = null;
        resourcePackagesFiled = null;
        instrumentationField = null;
        publicSourceDirField = null;
    }
}

