/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.util.Log;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public final class TinkerParallelDexOptimizer {
    private static final String TAG = "Tinker.ParallelDex";

    public static synchronized boolean optimizeAll(File[] fileArray, File file, ResultCallback resultCallback) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return TinkerParallelDexOptimizer.optimizeAllLocked(Arrays.asList(fileArray), file, atomicInteger, resultCallback);
    }

    public static synchronized boolean optimizeAll(Collection<File> collection, File file, ResultCallback resultCallback) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return TinkerParallelDexOptimizer.optimizeAllLocked(collection, file, atomicInteger, resultCallback);
    }

    private static boolean optimizeAllLocked(Collection<File> collection, File file, AtomicInteger atomicInteger, ResultCallback resultCallback) {
        CountDownLatch countDownLatch = new CountDownLatch(collection.size());
        ExecutorService executorService = Executors.newCachedThreadPool();
        long l = System.nanoTime();
        for (File file2 : collection) {
            OptimizeWorker object = new OptimizeWorker(file2, file, atomicInteger, countDownLatch, resultCallback);
            executorService.submit(object);
        }
        try {
            countDownLatch.await();
            long l2 = (System.nanoTime() - l) / 1000000L;
            if (atomicInteger.get() == collection.size()) {
                Log.i((String)TAG, (String)("All dexes are optimized successfully, cost: " + l2 + " ms."));
                return true;
            }
            Log.e((String)TAG, (String)"Dexes optimizing failed, some dexes are not optimized.");
            return false;
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)TAG, (String)"Dex optimizing was interrupted.", (Throwable)interruptedException);
            return false;
        }
        finally {
            executorService.shutdown();
        }
    }

    static class OptimizeWorker
    implements Runnable {
        private final File dexFile;
        private final File optimizedDir;
        private final AtomicInteger successCount;
        private final CountDownLatch waitingLauch;
        private final ResultCallback callback;

        OptimizeWorker(File file, File file2, AtomicInteger atomicInteger, CountDownLatch countDownLatch, ResultCallback resultCallback) {
            this.dexFile = file;
            this.optimizedDir = file2;
            this.successCount = atomicInteger;
            this.waitingLauch = countDownLatch;
            this.callback = resultCallback;
        }

        @Override
        public void run() {
            try {
                if (!SharePatchFileUtil.isLegalFile(this.dexFile) && this.callback != null) {
                    this.callback.onFailed(this.dexFile, this.optimizedDir, new IOException("dex file " + this.dexFile.getAbsolutePath() + " is not exist!"));
                }
                if (this.callback != null) {
                    this.callback.onStart(this.dexFile, this.optimizedDir);
                }
                String string = SharePatchFileUtil.optimizedPathFor(this.dexFile, this.optimizedDir);
                DexFile.loadDex((String)this.dexFile.getAbsolutePath(), (String)string, (int)0);
                this.successCount.incrementAndGet();
                if (this.callback != null) {
                    this.callback.onSuccess(this.dexFile, this.optimizedDir, new File(string));
                }
                return;
            }
            catch (Throwable throwable) {
                Log.e((String)TinkerParallelDexOptimizer.TAG, (String)("Failed to optimize dex: " + this.dexFile.getAbsolutePath()), (Throwable)throwable);
                if (this.callback != null) {
                    this.callback.onFailed(this.dexFile, this.optimizedDir, throwable);
                }
                return;
            }
            finally {
                this.waitingLauch.countDown();
            }
        }
    }

    public static interface ResultCallback {
        public void onStart(File var1, File var2);

        public void onSuccess(File var1, File var2, File var3);

        public void onFailed(File var1, File var2, Throwable var3);
    }
}

