/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.TinkerResourcePatcher;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareResPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import java.io.File;
import java.io.Serializable;

public class TinkerResourceLoader {
    protected static final String RESOURCE_META_FILE = "assets/res_meta.txt";
    protected static final String RESOURCE_FILE = "resources.apk";
    protected static final String RESOURCE_PATH = "res";
    private static final String TAG = "Tinker.ResourceLoader";
    private static ShareResPatchInfo resPatchInfo = new ShareResPatchInfo();

    private TinkerResourceLoader() {
    }

    public static boolean loadTinkerResources(Context context, boolean bl, String string, Intent intent) {
        if (resPatchInfo == null || TinkerResourceLoader.resPatchInfo.resArscMd5 == null) {
            return true;
        }
        string = string + "/res" + "/resources.apk";
        File file = new File(string);
        long l = System.currentTimeMillis();
        if (bl) {
            if (!SharePatchFileUtil.checkResourceArscMd5(file, TinkerResourceLoader.resPatchInfo.resArscMd5)) {
                Log.e((String)TAG, (String)("Failed to load resource file, path: " + file.getPath() + ", expect md5: " + TinkerResourceLoader.resPatchInfo.resArscMd5));
                ShareIntentUtil.setIntentReturnCode(intent, -23);
                return false;
            }
            Log.i((String)TAG, (String)("verify resource file:" + file.getPath() + " md5, use time: " + (System.currentTimeMillis() - l)));
        }
        try {
            TinkerResourcePatcher.monkeyPatchExistingResources(context, string);
            Log.i((String)TAG, (String)("monkeyPatchExistingResources resource file:" + string + ", use time: " + (System.currentTimeMillis() - l)));
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"install resources failed");
            try {
                SystemClassLoaderAdder.uninstallPatchDex(context.getClassLoader());
            }
            catch (Throwable throwable2) {
                Log.e((String)TAG, (String)"uninstallPatchDex failed", (Throwable)throwable);
            }
            intent.putExtra("intent_patch_exception", (Serializable)throwable);
            ShareIntentUtil.setIntentReturnCode(intent, -22);
            return false;
        }
        return true;
    }

    public static boolean checkComplete(Context context, String object, ShareSecurityCheck object2, Intent intent) {
        if ((object2 = ((ShareSecurityCheck)object2).getMetaContentMap().get(RESOURCE_META_FILE)) == null) {
            return true;
        }
        ShareResPatchInfo.parseResPatchInfoFirstLine((String)object2, resPatchInfo);
        if (TinkerResourceLoader.resPatchInfo.resArscMd5 == null) {
            return true;
        }
        if (!ShareResPatchInfo.checkResPatchInfo(resPatchInfo)) {
            intent.putExtra("intent_patch_package_patch_check", -8);
            ShareIntentUtil.setIntentReturnCode(intent, -8);
            return false;
        }
        object2 = new File((String)(object = (String)object + "/res" + "/"));
        if (!((File)object2).exists() || !((File)object2).isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intent, -20);
            return false;
        }
        if (!((File)(object = new File((String)object + RESOURCE_FILE))).exists()) {
            ShareIntentUtil.setIntentReturnCode(intent, -21);
            return false;
        }
        try {
            TinkerResourcePatcher.isResourceCanPatch(context);
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"resource hook check failed.", (Throwable)throwable);
            intent.putExtra("intent_patch_exception", (Serializable)throwable);
            ShareIntentUtil.setIntentReturnCode(intent, -22);
            return false;
        }
        return true;
    }
}

