/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.app;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import com.tencent.tinker.loader.TinkerLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerUncaughtHandler;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;

public abstract class TinkerApplication
extends Application {
    private static final int TINKER_DISABLE = 0;
    private static final String INTENT_PATCH_EXCEPTION = "intent_patch_exception";
    private static final String TINKER_LOADER_METHOD = "tryLoad";
    private final int tinkerFlags;
    private final boolean tinkerLoadVerifyFlag;
    private final String delegateClassName;
    private final String loaderClassName;
    private boolean useSafeMode;
    private Intent tinkerResultIntent;
    private Object delegate = null;
    private Resources[] resources = new Resources[1];
    private ClassLoader[] classLoader = new ClassLoader[1];
    private AssetManager[] assetManager = new AssetManager[1];
    private long applicationStartElapsedTime;
    private long applicationStartMillisTime;

    protected TinkerApplication(int n) {
        this(n, "com.tencent.tinker.loader.app.DefaultApplicationLike", TinkerLoader.class.getName(), false);
    }

    protected TinkerApplication(int n, String string, String string2, boolean bl) {
        this.tinkerFlags = n;
        this.delegateClassName = string;
        this.loaderClassName = string2;
        this.tinkerLoadVerifyFlag = bl;
    }

    protected TinkerApplication(int n, String string) {
        this(n, string, TinkerLoader.class.getName(), false);
    }

    private Object createDelegate() {
        try {
            GenericDeclaration genericDeclaration = Class.forName(this.delegateClassName, false, this.getClassLoader());
            genericDeclaration = genericDeclaration.getConstructor(Application.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Intent.class, Resources[].class, ClassLoader[].class, AssetManager[].class);
            return ((Constructor)genericDeclaration).newInstance(new Object[]{this, this.tinkerFlags, this.tinkerLoadVerifyFlag, this.applicationStartElapsedTime, this.applicationStartMillisTime, this.tinkerResultIntent, this.resources, this.classLoader, this.assetManager});
        }
        catch (Throwable throwable) {
            throw new TinkerRuntimeException("createDelegate failed", throwable);
        }
    }

    private synchronized void ensureDelegate() {
        if (this.delegate == null) {
            this.delegate = this.createDelegate();
        }
    }

    private void onBaseContextAttached(Context object) {
        Object object2;
        this.applicationStartElapsedTime = SystemClock.elapsedRealtime();
        this.applicationStartMillisTime = System.currentTimeMillis();
        this.loadTinker();
        this.ensureDelegate();
        try {
            object2 = ShareReflectUtil.findMethod(this.delegate, "onBaseContextAttached", Context.class);
            ((Method)object2).invoke(this.delegate, object);
        }
        catch (Throwable throwable) {
            throw new TinkerRuntimeException("onBaseContextAttached method not found", throwable);
        }
        if (this.useSafeMode) {
            object2 = ShareTinkerInternals.getProcessName((Context)this);
            object = "tinker_own_config_" + (String)object2;
            object = this.getSharedPreferences((String)object, 0);
            object.edit().putInt("safe_mode_count", 0).commit();
        }
    }

    protected void attachBaseContext(Context context) {
        super.attachBaseContext(context);
        Thread.setDefaultUncaughtExceptionHandler(new TinkerUncaughtHandler((Context)this));
        this.onBaseContextAttached(context);
    }

    private void loadTinker() {
        if (this.tinkerFlags == 0) {
            return;
        }
        this.tinkerResultIntent = new Intent();
        try {
            GenericDeclaration genericDeclaration = Class.forName(this.loaderClassName, false, this.getClassLoader());
            Method method = ((Class)genericDeclaration).getMethod(TINKER_LOADER_METHOD, TinkerApplication.class, Integer.TYPE, Boolean.TYPE);
            genericDeclaration = ((Class)genericDeclaration).getConstructor(new Class[0]);
            this.tinkerResultIntent = (Intent)method.invoke(((Constructor)genericDeclaration).newInstance(new Object[0]), new Object[]{this, this.tinkerFlags, this.tinkerLoadVerifyFlag});
            return;
        }
        catch (Throwable throwable) {
            ShareIntentUtil.setIntentReturnCode(this.tinkerResultIntent, -19);
            this.tinkerResultIntent.putExtra(INTENT_PATCH_EXCEPTION, (Serializable)throwable);
            return;
        }
    }

    private void delegateMethod(String string) {
        if (this.delegate != null) {
            try {
                Method method = ShareReflectUtil.findMethod(this.delegate, string, new Class[0]);
                method.invoke(this.delegate, new Object[0]);
                return;
            }
            catch (Throwable throwable) {
                throw new TinkerRuntimeException(String.format("%s method not found", string), throwable);
            }
        }
    }

    public void onCreate() {
        super.onCreate();
        this.ensureDelegate();
        this.delegateMethod("onCreate");
    }

    public void onTerminate() {
        super.onTerminate();
        this.delegateMethod("onTerminate");
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.delegateMethod("onLowMemory");
    }

    private void delegateTrimMemory(int n) {
        if (this.delegate != null) {
            try {
                Method method = ShareReflectUtil.findMethod(this.delegate, "onTrimMemory", Integer.TYPE);
                method.invoke(this.delegate, n);
                return;
            }
            catch (Throwable throwable) {
                throw new TinkerRuntimeException("onTrimMemory method not found", throwable);
            }
        }
    }

    @TargetApi(value=14)
    public void onTrimMemory(int n) {
        super.onTrimMemory(n);
        this.delegateTrimMemory(n);
    }

    private void delegateConfigurationChanged(Configuration configuration) {
        if (this.delegate != null) {
            try {
                Method method = ShareReflectUtil.findMethod(this.delegate, "onConfigurationChanged", Configuration.class);
                method.invoke(this.delegate, configuration);
                return;
            }
            catch (Throwable throwable) {
                throw new TinkerRuntimeException("onConfigurationChanged method not found", throwable);
            }
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.delegateConfigurationChanged(configuration);
    }

    public Resources getResources() {
        if (this.resources[0] != null) {
            return this.resources[0];
        }
        return super.getResources();
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader[0] != null) {
            return this.classLoader[0];
        }
        return super.getClassLoader();
    }

    public AssetManager getAssets() {
        if (this.assetManager[0] != null) {
            return this.assetManager[0];
        }
        return super.getAssets();
    }

    public void setUseSafeMode(boolean bl) {
        this.useSafeMode = bl;
    }
}

