/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpatch.sdk.server.callback;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerInstaller;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tinkerpatch.sdk.a;
import com.tinkerpatch.sdk.a.c;
import com.tinkerpatch.sdk.server.callback.PatchRequestCallback;
import com.tinkerpatch.sdk.server.callback.RollbackCallBack;
import com.tinkerpatch.sdk.server.d.d;
import java.io.File;

public class TinkerPatchRequestCallback
implements PatchRequestCallback {
    private static final String TAG = "Tinker.PatchRequestCallback";
    public static final String TINKER_DOWNLOAD_FAIL_TIMES = "tinker_download_fail";
    public static final int DOWNLOAD_FAIL_MAX_TIMES = 3;
    public static final int PATCH_MAX_RETRY_COUNT = 3;
    public static final int ERROR_DOWNLOAD_FAIL = -1;
    public static final int ERROR_PATCH_FAIL = -2;
    public static final int ERROR_LOAD_FAIL = -3;
    private static boolean rollbackOnScreenOff;
    private static RollbackCallBack rollbackCallBack;

    public static void setRollbackOnScreenOff(boolean bl) {
        rollbackOnScreenOff = bl;
    }

    public static void setPatchRollbackCallBack(RollbackCallBack rollbackCallBack) {
        TinkerPatchRequestCallback.rollbackCallBack = rollbackCallBack;
    }

    @Override
    public boolean beforePatchRequest() {
        Object object = com.tinkerpatch.sdk.server.a.a();
        Context context = ((com.tinkerpatch.sdk.server.a)object).b();
        Object object2 = Tinker.with(context);
        if (!com.tinkerpatch.sdk.a.a.a(((com.tinkerpatch.sdk.server.a)object).b())) {
            TinkerLog.w(TAG, "TinkerPatchRequestCallback: beforePatchRequest return false, not connect to internet", new Object[0]);
            return false;
        }
        if (TinkerServiceInternals.isTinkerPatchServiceRunning(((com.tinkerpatch.sdk.server.a)object).b())) {
            TinkerLog.w(TAG, "TinkerPatchRequestCallback: beforePatchRequest return false, tinker service is running", new Object[0]);
            return false;
        }
        if (!((Tinker)object2).isMainProcess()) {
            TinkerLog.w(TAG, "TinkerPatchRequestCallback: beforePatchRequest return false, only request on the main process", new Object[0]);
            return false;
        }
        if (c.b()) {
            TinkerLog.e(TAG, "TinkerPatchRequestCallback: beforePatchRequest return false, is in ignore channel, current channel:%s", c.a());
            return false;
        }
        Object object3 = a.a();
        String string = ((a)object3).g();
        object2 = ((Tinker)object2).getTinkerLoadResultIfPresent();
        return ((TinkerLoadResult)object2).currentVersion != null && string.equals(((TinkerLoadResult)object2).currentVersion) || (Integer)(object2 = ((a)object3).c()) <= 0 || !((File)(object = d.a(context, ((com.tinkerpatch.sdk.server.a)object).c(), String.valueOf(object2)))).exists() || !((File)object).isFile() || !((String)(object3 = SharePatchFileUtil.getMD5((File)object))).equals(string) || !this.retryPendingPatch(context, (Integer)object2, (String)object3, (File)object);
    }

    @Override
    public void onPatchRollback() {
        Object object = com.tinkerpatch.sdk.server.a.a();
        Tinker tinker = Tinker.with(((com.tinkerpatch.sdk.server.a)object).b());
        if (!tinker.isTinkerLoaded()) {
            TinkerLog.w(TAG, "TinkerPatchRequestCallback: onPatchRollback, tinker is not loaded, just return", new Object[0]);
            return;
        }
        if (rollbackCallBack != null) {
            rollbackCallBack.onPatchRollback();
        }
        if (rollbackOnScreenOff) {
            TinkerLog.i(TAG, "tinker wait screen to clean patch and kill all process", new Object[0]);
            new c.b(((com.tinkerpatch.sdk.server.a)object).b(), new c.a(){

                @Override
                public void onScreenOff() {
                    TinkerPatchRequestCallback.this.rollbackPatchDirectly();
                }
            });
        }
        object = tinker.getTinkerLoadResultIfPresent().currentVersion;
        object = new SharePatchInfo((String)object, "00000000000000000000000000000000", Build.FINGERPRINT);
        SharePatchInfo.rewritePatchInfoFileWithLock(tinker.getPatchInfoFile(), (SharePatchInfo)object, tinker.getPatchInfoLockFile());
    }

    @Override
    public void onPatchDownloadFail(Exception exception, Integer n, Integer n2) {
        TinkerLog.w(TAG, "TinkerPatchRequestCallback: onPatchDownloadFail e:" + exception, new Object[0]);
    }

    @Override
    public boolean onPatchUpgrade(File file, Integer n, Integer object) {
        TinkerLog.w(TAG, "TinkerPatchRequestCallback: onPatchUpgrade, file:%s, newVersion:%d, currentVersion:%d", file.getPath(), n, object);
        object = com.tinkerpatch.sdk.server.a.a();
        Context context = ((com.tinkerpatch.sdk.server.a)object).b();
        ShareSecurityCheck shareSecurityCheck = new ShareSecurityCheck(context);
        if (!shareSecurityCheck.verifyPatchMetaSignature(file)) {
            TinkerLog.e(TAG, "onPatchUpgrade, signature check fail. file: %s, version:%d", file.getPath(), n);
            if (this.increaseDownloadError(context)) {
                a.a().a(n, SharePatchFileUtil.getMD5(file));
                ((com.tinkerpatch.sdk.server.a)object).a(n, -1);
            }
            SharePatchFileUtil.safeDeleteFile(file);
            return false;
        }
        this.handleUpgradePatch(file, n);
        file = context.getSharedPreferences("patch_server_config", 0);
        file.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, 0).apply();
        return true;
    }

    @Override
    public void onPatchSyncFail(Exception exception) {
        TinkerLog.w(TAG, "TinkerPatchRequestCallback: onPatchSyncFail error:" + exception, new Object[0]);
        TinkerLog.printErrStackTrace(TAG, exception, "onPatchSyncFail stack:", new Object[0]);
    }

    @Override
    public void updatePatchConditions() {
        TinkerLog.i(TAG, "TinkerPatchRequestCallback: updatePatchConditions", new Object[0]);
        com.tinkerpatch.sdk.server.a a2 = com.tinkerpatch.sdk.server.a.a();
        a2.a("wifi", com.tinkerpatch.sdk.a.a.b(a2.b()) ? "1" : "0");
    }

    private boolean retryPendingPatch(Context context, Integer n, String string, File file) {
        a a2 = a.a();
        int n2 = a2.e() + 1;
        if (n2 < 3) {
            TinkerLog.w(TAG, "beforePatchRequest, have pending patch to install, version: %d, patch:%s", n, file.getPath());
            a2.b(string);
            TinkerInstaller.onReceiveUpgradePatch(context, file.getAbsolutePath());
            return true;
        }
        SharePatchFileUtil.safeDeleteFile(file);
        TinkerLog.w(TAG, "beforePatchRequest, retry patch install more than %d times, version: %d, patch:%s", n2, n, file.getPath());
        return false;
    }

    private void rollbackPatchDirectly() {
        com.tinkerpatch.sdk.server.a a2 = com.tinkerpatch.sdk.server.a.a();
        a2 = a2.b();
        Tinker tinker = Tinker.with((Context)a2);
        ShareTinkerInternals.killAllOtherProcess((Context)a2);
        tinker.cleanPatch();
        Process.killProcess((int)Process.myPid());
    }

    private void handleUpgradePatch(File file, Integer fileArray) {
        Object object = com.tinkerpatch.sdk.server.a.a();
        Context context = ((com.tinkerpatch.sdk.server.a)object).b();
        a a2 = a.a();
        ((com.tinkerpatch.sdk.server.a)object).a((Integer)fileArray);
        object = SharePatchFileUtil.getMD5(file);
        a2.a((Integer)fileArray, (String)object);
        fileArray = d.c(context).listFiles();
        if (fileArray != null) {
            object = file.getName();
            for (File file2 : fileArray) {
                String string = file2.getName();
                if (string.equals(object) || string.equals("version.info") || string.equals("version.lock")) continue;
                SharePatchFileUtil.safeDeleteFile(file2);
            }
        }
        TinkerInstaller.onReceiveUpgradePatch(context, file.getAbsolutePath());
    }

    private boolean increaseDownloadError(Context context) {
        context = context.getSharedPreferences("patch_server_config", 0);
        int n = context.getInt(TINKER_DOWNLOAD_FAIL_TIMES, 0);
        TinkerLog.w(TAG, "TinkerPatchRequestCallback: increaseDownloadError, current count:%d", n);
        if (n >= 3) {
            context.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, 0).commit();
            return true;
        }
        context.edit().putInt(TINKER_DOWNLOAD_FAIL_TIMES, ++n).commit();
        return false;
    }
}

