/*
 * Decompiled with CFR 0.152.
 */
package com.timehop.stickyheadersrecyclerview;

import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.timehop.stickyheadersrecyclerview.StickyRecyclerHeadersAdapter;
import com.timehop.stickyheadersrecyclerview.StickyRecyclerHeadersDecoration;

class StickyRecyclerHeadersTouchListener
implements RecyclerView.OnItemTouchListener {
    private final GestureDetector mTapDetector;
    private final RecyclerView mRecyclerView;
    private final StickyRecyclerHeadersDecoration mDecor;
    private OnHeaderClickListener mOnHeaderClickListener;

    public StickyRecyclerHeadersTouchListener(RecyclerView recyclerView, StickyRecyclerHeadersDecoration decor) {
        this.mTapDetector = new GestureDetector(recyclerView.getContext(), (GestureDetector.OnGestureListener)new SingleTapDetector());
        this.mRecyclerView = recyclerView;
        this.mDecor = decor;
    }

    public StickyRecyclerHeadersAdapter getAdapter() {
        if (this.mRecyclerView.getAdapter() instanceof StickyRecyclerHeadersAdapter) {
            return (StickyRecyclerHeadersAdapter)this.mRecyclerView.getAdapter();
        }
        throw new IllegalStateException("A RecyclerView with " + StickyRecyclerHeadersTouchListener.class.getSimpleName() + " requires a " + StickyRecyclerHeadersAdapter.class.getSimpleName());
    }

    public void setOnHeaderClickListener(OnHeaderClickListener listener) {
        this.mOnHeaderClickListener = listener;
    }

    public boolean onInterceptTouchEvent(RecyclerView view, MotionEvent e) {
        return this.mOnHeaderClickListener != null && this.mTapDetector.onTouchEvent(e);
    }

    public void onTouchEvent(RecyclerView view, MotionEvent e) {
    }

    private class SingleTapDetector
    extends GestureDetector.SimpleOnGestureListener {
        private SingleTapDetector() {
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            int position = StickyRecyclerHeadersTouchListener.this.mDecor.findHeaderPositionUnder((int)e.getX(), (int)e.getY());
            if (position != -1) {
                View headerView = StickyRecyclerHeadersTouchListener.this.mDecor.getHeaderView(StickyRecyclerHeadersTouchListener.this.mRecyclerView, position);
                long headerId = StickyRecyclerHeadersTouchListener.this.getAdapter().getHeaderId(position);
                StickyRecyclerHeadersTouchListener.this.mOnHeaderClickListener.onHeaderClick(headerView, position, headerId);
                return true;
            }
            return false;
        }
    }

    public static interface OnHeaderClickListener {
        public void onHeaderClick(View var1, int var2, long var3);
    }
}

