package com.tikerdev.tikerdevlibrary;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;

import com.tikerdev.tikerdevlibrary.state.BundleSavedState;

import fr.castorflex.android.circularprogressbar.CircularProgressBar;

/**
 * Created by Error404 on 14/6/2559.
 */

public class TikerDevCircularProgressBar extends CircularProgressBar {
    private int visibility;

    public TikerDevCircularProgressBar(Context context) {
        super(context);
        init();
    }

    public TikerDevCircularProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
        initWithAttrs(attrs, 0, 0);
    }

    public TikerDevCircularProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
        initWithAttrs(attrs, defStyleAttr, 0);
    }

    private void init() {
        setSaveEnabled(true);
    }

    private void initWithAttrs(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        /*
        TypedArray a = getContext().getTheme().obtainStyledAttributes(
                attrs,
                R.styleable.StyleableName,
                defStyleAttr, defStyleRes);

        try {

        } finally {
            a.recycle();
        }
        */
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();

        BundleSavedState savedState = new BundleSavedState(superState);
        // Save Instance State(s) here to the 'savedState.getBundle()'
        // for example,
        // savedState.getBundle().putString("key", value);
        savedState.getBundle().putInt("visibility", this.getVisibility());

        return savedState;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        BundleSavedState ss = (BundleSavedState) state;
        super.onRestoreInstanceState(ss.getSuperState());

        Bundle bundle = ss.getBundle();
        // Restore State from bundle here
        visibility = bundle.getInt("visibility");

        switch (visibility) {
            case VISIBLE:
                this.setVisibility(View.VISIBLE);
                break;
            case INVISIBLE:
                this.setVisibility(View.INVISIBLE);
                break;
            case GONE:
                this.setVisibility(View.GONE);
                break;
            default:
                this.setVisibility(View.VISIBLE);
                break;
        }
    }

}
