package com.tikerdev.tikerdevlibrary;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;

/**
 * Created by Error404 on 18/5/2559.
 */
public class TikerDevTextView extends AppCompatTextView {

    public TikerDevTextView(Context context) {
        super(context);
    }

    public TikerDevTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initWithAttrs(attrs, 0, 0);
    }

    public TikerDevTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initWithAttrs(attrs, defStyleAttr, 0);
    }

    private void initWithAttrs(AttributeSet attrs, int defStyleAttr, int defStyleRes) {

        TypedArray a = getContext().getTheme().obtainStyledAttributes(
                attrs,
                R.styleable.tikerDev,
                defStyleAttr, defStyleRes);

        String fontName = a.getString(R.styleable.tikerDev_fontName);
        try {
            if (fontName != null) {
                setTypeface(Typeface.createFromAsset(getContext().getAssets(), "fonts/" + fontName + ".ttf"));
            } else {
                setTypeface(Typeface.createFromAsset(getContext().getAssets(), "fonts/CSChatThaiUI.ttf"));
            }
        } finally {

            a.recycle();
        }

    }
}