/*
 * Decompiled with CFR 0.152.
 */
package com.tikerdev.views.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.AttributeSet;
import java.util.HashMap;

public class FontCache {
    private static HashMap<String, Typeface> fontCache = new HashMap();

    public static Typeface getTypeface(String fontName, Context context) {
        Typeface typeface = fontCache.get(fontName);
        if (typeface == null) {
            try {
                typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontName);
            }
            catch (Exception e) {
                return null;
            }
            fontCache.put(fontName, typeface);
        }
        return typeface;
    }

    public static Typeface selectTypeface(Context context, String fontName, int textStyle) {
        switch (textStyle) {
            case 1: {
                return FontCache.getTypeface(fontName + "-Bold.ttf", context);
            }
            case 3: {
                return FontCache.getTypeface(fontName + "-BoldItalic.ttf", context);
            }
            case 2: {
                return FontCache.getTypeface(fontName + "-Italic.ttf", context);
            }
        }
        return FontCache.getTypeface(fontName + "-Regular.ttf", context);
    }

    public static Typeface applyCustomFont(Context context, AttributeSet attrs, int fontName) {
        int textStyle = attrs.getAttributeIntValue("http://schemas.android.com/apk/res/android", "textStyle", 0);
        switch (fontName) {
            case 1: {
                String font = "fonts/kanit/Kanit";
                return FontCache.selectTypeface(context, font, textStyle);
            }
        }
        String font = "fonts/chatthai/CSChatThaiUI";
        return FontCache.selectTypeface(context, font, textStyle);
    }
}

