/*
 * Decompiled with CFR 0.152.
 */
package com.tikerdev.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatRadioButton;
import android.util.AttributeSet;
import com.tikerdev.views.R;
import com.tikerdev.views.util.FontCache;

public class TRadioButton
extends AppCompatRadioButton {
    private Typeface mTypeface;

    public TRadioButton(Context context) {
        super(context);
    }

    public TRadioButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initWithAttrs(attrs, 0, 0);
    }

    public TRadioButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initWithAttrs(attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWithAttrs(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.TDevTextView, defStyleAttr, defStyleRes);
        try {
            int fontName = a.getInt(R.styleable.TDevTextView_fontName, 1);
            this.mTypeface = FontCache.applyCustomFont(this.getContext(), attrs, fontName);
            this.updateFontName();
        }
        finally {
            a.recycle();
        }
    }

    public void setFontName(Typeface typeface) {
        this.mTypeface = typeface;
        this.updateFontName();
    }

    private void updateFontName() {
        if (this.mTypeface != null) {
            this.setTypeface(this.mTypeface);
        }
    }
}

