/*
 * Decompiled with CFR 0.152.
 */
package com.tigether.logger.http;

public class JsonUtil {
    public static String formatJson(String jsonStr) {
        if (null == jsonStr || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char current = '\u0000';
        int indent = 0;
        block5: for (int i = 0; i < jsonStr.length(); ++i) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '[': 
                case '{': {
                    sb.append(current);
                    sb.append('\n');
                    JsonUtil.addIndentBlank(sb, ++indent);
                    continue block5;
                }
                case ']': 
                case '}': {
                    sb.append('\n');
                    JsonUtil.addIndentBlank(sb, --indent);
                    sb.append(current);
                    continue block5;
                }
                case ',': {
                    sb.append(current);
                    if (last == '\\') continue block5;
                    sb.append('\n');
                    JsonUtil.addIndentBlank(sb, indent);
                    continue block5;
                }
                default: {
                    sb.append(current);
                }
            }
        }
        return sb.toString();
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
    }

    public static String decodeUnicode(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }
}

