/*
 * Decompiled with CFR 0.152.
 */
package com.tigether.logger;

import com.orhanobut.logger.AndroidLogAdapter;
import com.orhanobut.logger.FormatStrategy;
import com.orhanobut.logger.LogAdapter;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.PrettyFormatStrategy;

public class LogUtil {
    private static boolean isDebug = true;
    private static final String TAG = "LogUtil";

    public static boolean isDebug() {
        return isDebug;
    }

    public static void setIsDebug(boolean isDebug) {
        LogUtil.isDebug = isDebug;
    }

    public static void initLogger(Boolean isDebug) {
        LogUtil.isDebug = isDebug;
        PrettyFormatStrategy formatStrategy = PrettyFormatStrategy.newBuilder().showThreadInfo(false).tag(TAG).build();
        Logger.addLogAdapter((LogAdapter)new AndroidLogAdapter((FormatStrategy)formatStrategy));
    }

    private LogUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static void i(String msg) {
        if (isDebug) {
            Logger.i((String)msg, (Object[])new Object[0]);
        }
    }

    public static void d(String msg) {
        if (isDebug) {
            Logger.d((Object)msg);
        }
    }

    public static void w(String tag, String msg, Exception e) {
        if (isDebug) {
            Logger.w((String)msg, (Object[])new Object[]{e});
        }
    }

    public static void e(String msg) {
        if (isDebug) {
            Logger.e((String)msg, (Object[])new Object[0]);
        }
    }

    public static void v(String msg) {
        if (isDebug) {
            Logger.v((String)msg, (Object[])new Object[0]);
        }
    }

    public static void i(String tag, String msg) {
        if (isDebug) {
            Logger.i((String)"tag:%s  data:%s", (Object[])new Object[]{tag, msg});
        }
    }

    public static void d(String tag, String msg) {
        if (isDebug) {
            Logger.d((String)"tag:%s  data:%s", (Object[])new Object[]{tag, msg});
        }
    }

    public static void e(String tag, String msg) {
        if (isDebug) {
            Logger.e((String)"tag:%s  data:%s", (Object[])new Object[]{tag, msg});
        }
    }

    public static void e(String tag, String msg, Exception e) {
        if (isDebug) {
            Logger.e((String)"tag:%s  data:%s exception:%s", (Object[])new Object[]{tag, msg, e.getMessage()});
        }
    }

    public static void v(String tag, String msg) {
        if (isDebug) {
            Logger.v((String)"tag:%s  data:%s", (Object[])new Object[]{tag, msg});
        }
    }
}

