/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.saas.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Point;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.tiger.saas.widget.Rectangle30Item;
import com.tiger.saas.widget.utils.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Rectangle30View
extends View {
    public static final int MARGIN_LEFT_ITEM = (int)Dimension.dp2px(14.0f);
    public static final int RECTANGLE_MARGIN_LEFT = (int)Dimension.dp2px(21.0f);
    public static final int MARGIN_RIGHT_ITEM = (int)Dimension.dp2px(14.0f);
    public static final int BOTTOM_TEXT_WIDTH = (int)Dimension.dp2px(33.0f);
    public static final int BOTTOM_TEXT_HEIGHT = (int)Dimension.dp2px(29.0f);
    public static final int BOTTOM_TEXT_MARGIN_TOP = (int)Dimension.dp2px(7.0f);
    public static final int BOTTOM_TEXT_MARGIN_LIFT = (int)Dimension.dp2px(10.0f);
    public static final int BOTTOM_TEXT_MARGIN_RIGHT = (int)Dimension.dp2px(10.0f);
    public static final int RECTANGLE_WIDTH = (int)Dimension.dp2px(23.0f);
    public static final int RECTANGLE_MARGIN = (int)Dimension.dp2px(28.0f);
    public static final int DOTTED_LINE_MARGIN = (int)Dimension.dp2px(40.0f);
    private int rectangleColor = Color.parseColor((String)"#50ABFF");
    private int rectangleRightColor = Color.parseColor((String)"#1CCC50");
    private int dottedLineColor = Color.parseColor((String)"#50abff");
    private int dashedColor = Color.parseColor((String)"#e9e9e9");
    private int bottomTextColor = Color.parseColor((String)"#333333");
    private int bottomLineColor = Color.parseColor((String)"#969FA9");
    private int textColor = Color.parseColor((String)"#333333");
    private int dottedLineHeight = (int)Dimension.dp2px(1.0f);
    private int bottomLineHeight = (int)Dimension.dp2px(1.0f);
    private float textSize = Dimension.sp2px(11.0f);
    Paint dashedPaint = new Paint();
    Paint bottomLinePaint = new Paint();
    private Paint textPaint = new Paint();
    private Paint rectanglePaint = new Paint();
    private Paint rectanglePaintRight = new Paint();
    private int mHeight;
    private int mWidth;
    private int itemCount = 10;
    private int tempBaseTop;
    private int tempBaseBottom;
    private double maxTemp = 26.0;
    private double minTemp = 5.0;
    private List<Rectangle30Item> itemList = new ArrayList<Rectangle30Item>();

    public Rectangle30View(Context context) {
        this(context, null);
    }

    public Rectangle30View(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Rectangle30View(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.itemList = new ArrayList<Rectangle30Item>();
        Random random = new Random();
        for (int i = 0; i < this.itemCount; ++i) {
            Rectangle30Item materials30Item = new Rectangle30Item();
            double s = (double)random.nextInt(26) % (this.maxTemp - this.minTemp + 1.0) + this.minTemp;
            double s2 = (double)random.nextInt(26) % (this.maxTemp - this.minTemp + 1.0) + this.minTemp;
            materials30Item.setTonLeft(s);
            materials30Item.setTonRight(s2);
            materials30Item.setTime("07-" + i);
            this.itemList.add(materials30Item);
        }
        this.mWidth = MARGIN_LEFT_ITEM + MARGIN_RIGHT_ITEM + this.itemCount * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT);
        this.mHeight = MARGIN_LEFT_ITEM + DOTTED_LINE_MARGIN * 4 + BOTTOM_TEXT_HEIGHT;
        this.tempBaseTop = MARGIN_LEFT_ITEM;
        this.tempBaseBottom = MARGIN_LEFT_ITEM + DOTTED_LINE_MARGIN * 4;
        this.dashedPaint.setAntiAlias(true);
        this.dashedPaint.setStyle(Paint.Style.STROKE);
        this.dashedPaint.setStrokeWidth(Dimension.dp2px(1.0f));
        this.dashedPaint.setColor(this.dashedColor);
        this.dashedPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{6.0f, 6.0f}, 0.0f));
        this.bottomLinePaint.setAntiAlias(true);
        this.bottomLinePaint.setStrokeWidth(Dimension.dp2px(1.0f));
        this.bottomLinePaint.setColor(this.bottomLineColor);
        this.textPaint.setTextSize(Dimension.sp2px(12.0f));
        this.textPaint.setColor(this.bottomTextColor);
        this.textPaint.setAntiAlias(true);
        this.rectanglePaint.setStyle(Paint.Style.FILL);
        this.rectanglePaint.setColor(this.rectangleColor);
        this.rectanglePaint.setAntiAlias(true);
        this.rectanglePaintRight.setStyle(Paint.Style.FILL);
        this.rectanglePaintRight.setColor(this.rectangleRightColor);
        this.rectanglePaintRight.setAntiAlias(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = MARGIN_LEFT_ITEM + MARGIN_RIGHT_ITEM + this.itemCount * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT);
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.onDrawLine(canvas);
        this.onDrawBottomText(canvas);
        this.onDrawRectangle(canvas);
    }

    private void onDrawLine(Canvas canvas) {
        for (int i = 0; i < 4; ++i) {
            canvas.drawLine((float)MARGIN_LEFT_ITEM, (float)(MARGIN_LEFT_ITEM + DOTTED_LINE_MARGIN * i), (float)(MARGIN_LEFT_ITEM + this.itemCount * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT)), (float)(MARGIN_LEFT_ITEM + DOTTED_LINE_MARGIN * i), this.dashedPaint);
        }
        canvas.drawLine((float)MARGIN_LEFT_ITEM, (float)(MARGIN_LEFT_ITEM + DOTTED_LINE_MARGIN * 4), (float)(MARGIN_LEFT_ITEM + this.itemCount * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT)), (float)(MARGIN_LEFT_ITEM + DOTTED_LINE_MARGIN * 4), this.bottomLinePaint);
    }

    private void onDrawRectangle(Canvas canvas) {
        int i;
        ArrayList<Double> temp = new ArrayList<Double>();
        for (i = 0; i < this.itemCount; ++i) {
            double tonLeft = this.itemList.get(i).getTonLeft();
            double tonRight = this.itemList.get(i).getTonRight();
            temp.add(tonLeft);
            temp.add(tonRight);
        }
        this.maxTemp = (Double)Collections.max(temp);
        this.minTemp = (Double)Collections.min(temp);
        for (i = 0; i < this.itemCount; ++i) {
            int left = (int)Dimension.dp2px(10.0f) + MARGIN_LEFT_ITEM + i * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT);
            int right = left + (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT) - (int)Dimension.dp2px(10.0f) * 2;
            int width = right - left;
            Point point = this.calculateTempPoint(left, left + width / 2, (int)this.itemList.get(i).getTonLeft());
            int top = point.y;
            int bottom = DOTTED_LINE_MARGIN * 4 + MARGIN_LEFT_ITEM - (int)Dimension.dp2px(1.0f);
            Rect rect = new Rect(left, top, left + width / 2, bottom);
            canvas.drawRect(rect, this.rectanglePaint);
            Point point1 = this.calculateTempPoint(left + width / 2, right, (int)this.itemList.get(i).getTonRight());
            int top1 = point1.y;
            Rect rect1 = new Rect(left + width / 2, top1, right, bottom);
            canvas.drawRect(rect1, this.rectanglePaintRight);
        }
    }

    private Point calculateTempPoint(int left, int right, int temp) {
        double minHeight = this.tempBaseTop;
        double maxHeight = this.tempBaseBottom;
        double tempY = temp == 0 ? (double)this.tempBaseBottom : maxHeight - ((double)temp - this.minTemp) * 1.0 / (this.maxTemp - this.minTemp) * (maxHeight - minHeight);
        Point point = new Point((left + right) / 2, (int)tempY);
        return point;
    }

    private void onDrawBottomText(Canvas canvas) {
        for (int i = 0; i < this.itemCount; ++i) {
            int left = MARGIN_LEFT_ITEM + i * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT);
            int right = left + (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT) - 1;
            int top = DOTTED_LINE_MARGIN * 4;
            int bottom = DOTTED_LINE_MARGIN * 4 + BOTTOM_TEXT_HEIGHT;
            Rect rect = new Rect(left, top, right, bottom);
            Rect targetRect = new Rect(rect.left, rect.bottom, rect.right, rect.bottom);
            Paint.FontMetricsInt fontMetrics = this.textPaint.getFontMetricsInt();
            int baseline = (targetRect.bottom + targetRect.top - fontMetrics.bottom - fontMetrics.top) / 2;
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            String text = this.itemList.get(i).getTime();
            canvas.drawText(text, (float)targetRect.centerX(), (float)baseline, this.textPaint);
        }
    }

    public void setData(List<Rectangle30Item> itemList) {
        this.itemList = itemList;
        this.itemCount = itemList.size();
        this.invalidate();
        this.requestLayout();
    }
}

