/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.saas.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.tiger.saas.widget.MaterialsConsumption;
import com.tiger.saas.widget.OnMaterialsClickListener;
import com.tiger.saas.widget.utils.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class MaterialsConsumptionView
extends View {
    private String TAG = MaterialsConsumptionView.class.getSimpleName();
    public static final int LEFT_TEXT_HEIGHT = (int)Dimension.dp2px(17.0f);
    public static final int LEFT_TEXT_PADDING_TOP = (int)Dimension.dp2px(10.0f);
    public static final int LEFT_TEXT_PADDING_BOTTOM = (int)Dimension.dp2px(10.0f);
    public static final int LEFT_TEXT_WIDTH = (int)Dimension.dp2px(50.0f);
    public static final int LINE_WIDTH = (int)Dimension.dp2px(1.0f);
    public static final int MARGIN_RIGHT = (int)Dimension.dp2px(14.0f);
    public static final int BOTTOME_TEXT_HEIGHT = (int)Dimension.dp2px(15.0f);
    public static final int BOTTOM_TEXT_PADDING_TOP = (int)Dimension.dp2px(7.0f);
    public static final int BOTTOM_TEXT_PADDING_BOTTOM = (int)Dimension.dp2px(7.0f);
    private float LEFT_TEXT_SIZE = Dimension.sp2px(12.0f);
    private float BOTTOM_TEXT_SIZE = Dimension.sp2px(11.0f);
    private float PURCHASE_TEXT_SIZE = Dimension.sp2px(13.0f);
    private float CONSUME_TEXT_SIZE = Dimension.sp2px(13.0f);
    private Paint leftTextPaint = new Paint();
    private Paint bottomTextPaint = new Paint();
    private Paint linePaint = new Paint();
    private Paint dottedLinePaint = new Paint();
    private Paint blueRectanglePaint = new Paint();
    private Paint grayRectanglePaint = new Paint();
    private int leftTextColor = Color.parseColor((String)"#666666");
    private int bottomTextColor = Color.parseColor((String)"#333333");
    private int lineColor = Color.parseColor((String)"#969fa9");
    private int blueRectangleColor = Color.parseColor((String)"#50abff");
    private int grayRectangleColor = Color.parseColor((String)"#eeeeee");
    private int dottedLineColor = Color.parseColor((String)"#e9e9e9");
    private int mHeight;
    private int mWidth;
    private int itemCount = 7;
    private int tempBaseTop;
    private int tempBaseBottom;
    private int selectPosition = -1;
    private double maxTemp = 10.0;
    private double minTemp = 0.0;
    private List<MaterialsConsumption> itemList = new ArrayList<MaterialsConsumption>();
    private OnMaterialsClickListener clickListener;

    public MaterialsConsumptionView(Context context) {
        this(context, null);
    }

    public MaterialsConsumptionView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialsConsumptionView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.itemList = new ArrayList<MaterialsConsumption>();
        Random random = new Random();
        for (int i = 0; i < this.itemCount; ++i) {
            MaterialsConsumption materials30Item = new MaterialsConsumption();
            double s = (double)random.nextInt((int)this.maxTemp) % (this.maxTemp - this.minTemp + 1.0) + this.minTemp;
            double s2 = (double)random.nextInt((int)this.maxTemp) % (this.maxTemp - this.minTemp + 1.0) + this.minTemp;
            materials30Item.setTotalConsumeTon(s);
            materials30Item.setTotalSignTon(s2 + 10.0);
            materials30Item.setRawMaterial("\u6c34\u6ce5" + i);
            this.itemList.add(materials30Item);
        }
        this.mWidth = Dimension.getScreenWidth();
        this.mHeight = this.itemCount * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM) + 100;
        this.tempBaseTop = LEFT_TEXT_WIDTH;
        this.tempBaseBottom = this.mWidth - MARGIN_RIGHT - LEFT_TEXT_WIDTH;
        this.leftTextPaint.setTextSize(this.LEFT_TEXT_SIZE);
        this.leftTextPaint.setColor(this.leftTextColor);
        this.leftTextPaint.setAntiAlias(true);
        this.linePaint.setColor(this.lineColor);
        this.linePaint.setAntiAlias(true);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setStrokeWidth(Dimension.dp2px(1.0f));
        this.dottedLinePaint.setAntiAlias(true);
        this.dottedLinePaint.setStyle(Paint.Style.STROKE);
        this.dottedLinePaint.setStrokeWidth(Dimension.dp2px(1.0f));
        this.dottedLinePaint.setColor(this.dottedLineColor);
        this.dottedLinePaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{6.0f, 6.0f}, 0.0f));
        this.blueRectanglePaint.setStyle(Paint.Style.FILL);
        this.blueRectanglePaint.setColor(this.blueRectangleColor);
        this.blueRectanglePaint.setAntiAlias(true);
        this.grayRectanglePaint.setStyle(Paint.Style.FILL);
        this.grayRectanglePaint.setColor(this.grayRectangleColor);
        this.grayRectanglePaint.setAntiAlias(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = Dimension.getScreenWidth();
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.onDrawLeftText(canvas);
        this.onDrawLine(canvas);
        this.onDrawRectangle(canvas);
        this.onDrawBottomText(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        switch (event.getAction()) {
            case 0: {
                for (int i = 0; i < this.itemCount; ++i) {
                    left = LEFT_TEXT_WIDTH;
                    right = left + this.getX((int)this.itemList.get(i).getTotalConsumeTon()) + 1;
                    top = i * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM) + (int)Dimension.dp2px(10.0f);
                    bottom = i * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM) + LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM - (int)Dimension.dp2px(10.0f);
                    Rect rect = new Rect(left, top, right, bottom);
                    int right1 = left + this.getX((int)this.itemList.get(i).getTotalSignTon()) + 1;
                    Rect rect1 = new Rect(left, top, right1, bottom);
                    if (!rect1.contains(x, y) && !rect.contains(x, y)) continue;
                    this.selectPosition = i;
                    if (this.clickListener != null) {
                        this.clickListener.onClick(i);
                    }
                    this.invalidate();
                }
                break;
            }
            case 3: {
                this.selectPosition = -1;
                this.invalidate();
            }
        }
        return true;
    }

    private void onDrawLeftText(Canvas canvas) {
        for (int i = 0; i < this.itemCount; ++i) {
            int left = 0;
            int right = LEFT_TEXT_WIDTH;
            int top = i * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM);
            int bottom = i * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM) + LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM;
            Rect rect = new Rect(left, top, right, bottom);
            Rect targetRect = new Rect(rect.left, rect.top, rect.right, rect.bottom);
            Paint.FontMetricsInt fontMetrics = this.leftTextPaint.getFontMetricsInt();
            int baseline = (targetRect.bottom + targetRect.top - fontMetrics.bottom - fontMetrics.top) / 2;
            this.leftTextPaint.setTextAlign(Paint.Align.CENTER);
            String text = this.itemList.get(i).getRawMaterial();
            canvas.drawText(text, (float)targetRect.centerX(), (float)baseline, this.leftTextPaint);
        }
    }

    private void onDrawLine(Canvas canvas) {
        canvas.drawLine((float)LEFT_TEXT_WIDTH, 0.0f, (float)LEFT_TEXT_WIDTH, (float)(this.itemCount * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM)), this.linePaint);
        canvas.drawLine((float)LEFT_TEXT_WIDTH, (float)(this.itemCount * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM)), (float)(this.mWidth - MARGIN_RIGHT), (float)(this.itemCount * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM)), this.linePaint);
        for (int i = 1; i < 5; ++i) {
            canvas.drawLine((float)(LEFT_TEXT_WIDTH + (this.mWidth - LEFT_TEXT_WIDTH - MARGIN_RIGHT) / 4 * i), 0.0f, (float)(LEFT_TEXT_WIDTH + (this.mWidth - LEFT_TEXT_WIDTH - MARGIN_RIGHT) / 4 * i), (float)(this.itemCount * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM)), this.dottedLinePaint);
        }
    }

    private void onDrawRectangle(Canvas canvas) {
        int i;
        ArrayList<Double> temp = new ArrayList<Double>();
        for (i = 0; i < this.itemList.size(); ++i) {
            double tonLeft = this.itemList.get(i).getTotalConsumeTon();
            double tonRight = this.itemList.get(i).getTotalSignTon();
            temp.add(tonLeft);
            temp.add(tonRight);
        }
        this.maxTemp = (Double)Collections.max(temp);
        this.minTemp = (Double)Collections.min(temp);
        for (i = 0; i < this.itemCount; ++i) {
            int left = LEFT_TEXT_WIDTH;
            int right = left + this.getX((int)this.itemList.get(i).getTotalConsumeTon()) + 1;
            int top = i * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM) + (int)Dimension.dp2px(10.0f);
            int bottom = i * (LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM) + LEFT_TEXT_HEIGHT + LEFT_TEXT_PADDING_TOP + LEFT_TEXT_PADDING_BOTTOM - (int)Dimension.dp2px(10.0f);
            Rect rect = new Rect(left, top, right, bottom);
            int right1 = left + this.getX((int)this.itemList.get(i).getTotalSignTon()) + 1;
            Rect rect1 = new Rect(left, top, right1, bottom);
            canvas.drawRect(rect, this.grayRectanglePaint);
            canvas.drawRect(rect1, this.blueRectanglePaint);
            if (i != this.selectPosition) continue;
            this.onDrawFloatText(canvas);
        }
    }

    private void onDrawFloatText(Canvas canvas) {
    }

    private int getX(int temp) {
        double v = (double)(this.tempBaseBottom - this.tempBaseTop) / this.maxTemp * (double)temp;
        return (int)v;
    }

    private void onDrawBottomText(Canvas canvas) {
    }

    public void setData(List<MaterialsConsumption> itemList) {
        if (itemList.size() == 0) {
            this.init();
        } else {
            this.itemList = itemList;
            this.itemCount = itemList.size();
        }
        this.invalidate();
        this.requestLayout();
    }

    public void setOnMaterialsClickListener(OnMaterialsClickListener clickListener) {
        this.clickListener = clickListener;
    }
}

