/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.saas.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.tiger.saas.widget.Materials30Item;
import com.tiger.saas.widget.utils.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Materials30View
extends View {
    public static final int MARGIN_LEFT_ITEM = (int)Dimension.dp2px(14.0f);
    public static final int MARGIN_RIGHT_ITEM = (int)Dimension.dp2px(14.0f);
    public static final int BOTTOM_TEXT_WIDTH = (int)Dimension.dp2px(33.0f);
    public static final int BOTTOM_TEXT_HEIGHT = (int)Dimension.dp2px(27.0f);
    public static final int BOTTOM_TEXT_MARGIN_TOP = (int)Dimension.dp2px(7.0f);
    public static final int BOTTOM_TEXT_MARGIN_LIFT = (int)Dimension.dp2px(10.0f);
    public static final int BOTTOM_TEXT_MARGIN_RIGHT = (int)Dimension.dp2px(10.0f);
    public static final int BOX_WIDTH = (int)Dimension.dp2px(130.0f);
    public static final int BOX_HEIGHT = (int)Dimension.dp2px(60.0f);
    public static final int BOX_MARGIN = (int)Dimension.dp2px(10.0f);
    public static final int BOX_MARGIN_TOP = (int)Dimension.dp2px(40.0f);
    private int mHeight;
    private int mWidth;
    private int itemCount = 7;
    private int dashedBetweenHeight = (int)Dimension.dp2px(40.0f);
    private int bottomLineMarginDashedLine = (int)Dimension.dp2px(6.0f);
    private int clickPosition = -1;
    private int dashedColor = Color.parseColor((String)"#e9e9e9");
    private int bottomLineColor = Color.parseColor((String)"#969fa9");
    private int verticalLineColor = Color.parseColor((String)"#BFBFBF");
    private int bottomTextColor = Color.parseColor((String)"#333333");
    private int pointColor = Color.parseColor((String)"#0084ff");
    private int lineColor = Color.parseColor((String)"#0084ff");
    private int brokenLineColor = Color.parseColor((String)"#ffffff");
    private int tempBaseTop;
    private int tempBaseBottom;
    Paint dashedPaint = new Paint();
    Paint bottomLinePaint = new Paint();
    private Paint textPaint = new Paint();
    private Paint pointPaint = new Paint();
    private Paint linePaint = new Paint();
    private Paint brokenPaint = new Paint();
    private Paint verticalLinePaint = new Paint();
    private Path brokenPath;
    private ArrayList<Point> linePoint;
    private double maxTemp = 26.0;
    private double minTemp = 5.0;
    private List<Materials30Item> itemList = new ArrayList<Materials30Item>();

    public Materials30View(Context context) {
        this(context, null);
    }

    public Materials30View(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Materials30View(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.itemList = new ArrayList<Materials30Item>();
        Random random = new Random();
        for (int i = 0; i < this.itemCount; ++i) {
            Materials30Item materials30Item = new Materials30Item();
            double s = (double)random.nextInt(26) % (this.maxTemp - this.minTemp + 1.0) + this.minTemp;
            materials30Item.setCountTon(s);
            materials30Item.setCountMaterial(i);
            materials30Item.setTime("07-" + i);
            this.itemList.add(materials30Item);
        }
        this.mWidth = MARGIN_LEFT_ITEM + MARGIN_RIGHT_ITEM + this.itemCount * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT);
        this.mHeight = MARGIN_LEFT_ITEM + this.dashedBetweenHeight * 4 + this.bottomLineMarginDashedLine + BOTTOM_TEXT_HEIGHT;
        this.tempBaseTop = MARGIN_LEFT_ITEM;
        this.tempBaseBottom = MARGIN_LEFT_ITEM + this.dashedBetweenHeight * 4;
        this.dashedPaint.setAntiAlias(true);
        this.dashedPaint.setStyle(Paint.Style.STROKE);
        this.dashedPaint.setStrokeWidth(Dimension.dp2px(1.0f));
        this.dashedPaint.setColor(this.dashedColor);
        this.dashedPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{6.0f, 6.0f}, 0.0f));
        this.bottomLinePaint.setAntiAlias(true);
        this.bottomLinePaint.setStrokeWidth(Dimension.dp2px(1.0f));
        this.bottomLinePaint.setColor(this.bottomLineColor);
        this.textPaint.setTextSize(Dimension.sp2px(12.0f));
        this.textPaint.setColor(this.bottomTextColor);
        this.textPaint.setAntiAlias(true);
        this.pointPaint.setColor(this.pointColor);
        this.pointPaint.setAntiAlias(true);
        this.linePaint.setColor(this.lineColor);
        this.linePaint.setAntiAlias(true);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setStrokeWidth(Dimension.dp2px(1.0f));
        this.brokenPath = new Path();
        this.brokenPaint.setAntiAlias(true);
        this.brokenPaint.setStyle(Paint.Style.STROKE);
        this.brokenPaint.setStrokeWidth(Dimension.dp2px(1.0f));
        this.brokenPaint.setStrokeCap(Paint.Cap.ROUND);
        int shadowColor = Color.parseColor((String)"#999999");
        int shadowSize = (int)Dimension.dp2px(4.0f);
        this.brokenPaint.setShadowLayer((float)shadowSize, 0.0f, 0.0f, shadowColor);
        this.verticalLinePaint.setAntiAlias(true);
        this.verticalLinePaint.setStrokeWidth(Dimension.dp2px(1.0f));
        this.verticalLinePaint.setColor(this.verticalLineColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = MARGIN_LEFT_ITEM + MARGIN_RIGHT_ITEM + this.itemCount * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT);
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.onDrawDashedLineAndBottomLine(canvas);
        this.onDrawBottomText(canvas);
        this.onDrawPoint(canvas);
        this.onDrawLine(canvas);
        this.onDrawFloatBackground(canvas);
    }

    private void onDrawFloatBackground(Canvas canvas) {
        for (int i = 0; i < this.itemCount; ++i) {
            if (i != this.clickPosition) continue;
            this.drawFloatTextBackground(canvas, this.linePoint.get((int)i).x, this.linePoint.get((int)i).y, i);
        }
    }

    private void onDrawLine(Canvas canvas) {
        for (int i = 0; i < this.itemCount; ++i) {
            Point point = this.linePoint.get(i);
            if (i == 0) continue;
            Point pointPre = this.linePoint.get(i - 1);
            Path path = new Path();
            path.moveTo((float)pointPre.x, (float)pointPre.y);
            if (i % 2 == 0) {
                path.cubicTo((float)((pointPre.x + point.x) / 2), (float)((pointPre.y + point.y) / 2 - 7), (float)((pointPre.x + point.x) / 2), (float)((pointPre.y + point.y) / 2 + 7), (float)point.x, (float)point.y);
            } else {
                path.cubicTo((float)((pointPre.x + point.x) / 2), (float)((pointPre.y + point.y) / 2 + 7), (float)((pointPre.x + point.x) / 2), (float)((pointPre.y + point.y) / 2 - 7), (float)point.x, (float)point.y);
            }
            canvas.drawPath(path, this.linePaint);
        }
    }

    private void onDrawPoint(Canvas canvas) {
        int i;
        ArrayList<Double> temp = new ArrayList<Double>();
        for (i = 0; i < this.itemCount; ++i) {
            double countTon = this.itemList.size() == 0 ? 7.0 : this.itemList.get(i).getCountTon();
            temp.add(countTon);
        }
        this.maxTemp = (Double)Collections.max(temp);
        this.minTemp = (Double)Collections.min(temp);
        this.linePoint = new ArrayList();
        for (i = 0; i < this.itemCount; ++i) {
            int left = MARGIN_LEFT_ITEM + i * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT);
            int right = left + (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT) - 1;
            int top = this.dashedBetweenHeight * 4 + this.bottomLineMarginDashedLine;
            int bottom = this.dashedBetweenHeight * 4 + this.bottomLineMarginDashedLine + BOTTOM_TEXT_HEIGHT;
            Rect rect = new Rect(left, top, right, bottom);
            Point point = this.calculateTempPoint(left, right, (int)this.itemList.get(i).getCountTon());
            this.linePoint.add(point);
            if (i == this.clickPosition) {
                canvas.drawLine((float)this.linePoint.get((int)i).x, (float)this.tempBaseTop, (float)this.linePoint.get((int)i).x, (float)(this.tempBaseBottom + this.bottomLineMarginDashedLine), this.verticalLinePaint);
            }
            canvas.drawCircle((float)point.x, (float)point.y, Dimension.dp2px(3.0f), this.pointPaint);
        }
    }

    private void drawFloatTextBackground(Canvas canvas, int x, int y, int i) {
        this.brokenPath.reset();
        this.brokenPaint.setColor(this.brokenLineColor);
        this.brokenPaint.setStyle(Paint.Style.FILL);
        Point point = new Point(x, BOX_MARGIN_TOP + MARGIN_LEFT_ITEM);
        this.brokenPath.moveTo((float)(point.x + BOX_MARGIN), (float)point.y);
        point.x += BOX_WIDTH;
        this.brokenPath.lineTo((float)point.x, (float)point.y);
        point.y += BOX_HEIGHT;
        this.brokenPath.lineTo((float)point.x, (float)point.y);
        this.brokenPath.lineTo((float)(x + BOX_MARGIN), (float)(BOX_MARGIN_TOP + MARGIN_LEFT_ITEM + BOX_HEIGHT));
        canvas.drawPath(this.brokenPath, this.brokenPaint);
        int left = (int)((double)x + (double)BOX_MARGIN * 3.5);
        int right = left + BOX_WIDTH;
        int top = BOX_MARGIN_TOP;
        int bottom = BOX_MARGIN_TOP + BOX_HEIGHT / 2;
        Rect rect = new Rect(left, top, right, bottom);
        Rect targetRect = new Rect(rect.left, rect.bottom, rect.right, rect.bottom);
        Paint.FontMetricsInt fontMetrics = this.textPaint.getFontMetricsInt();
        int baseline = (targetRect.bottom + targetRect.top - fontMetrics.bottom - fontMetrics.top) / 2;
        this.textPaint.setTextAlign(Paint.Align.RIGHT);
        int countMaterial = this.itemList.size() == 0 ? 0 : this.itemList.get(i).getCountMaterial();
        String text = "\u5165\u573a" + countMaterial + "\u79cd\u539f\u6750\u6599";
        canvas.drawText(text, (float)targetRect.centerX(), (float)baseline, this.textPaint);
        int left1 = (int)((double)x + (double)BOX_MARGIN * 3.5);
        int right1 = left + BOX_WIDTH;
        int top1 = BOX_MARGIN_TOP + BOX_HEIGHT / 2;
        int bottom1 = BOX_MARGIN_TOP + BOX_HEIGHT;
        Rect rect1 = new Rect(left1, top1, right1, bottom1);
        Rect targetRect1 = new Rect(rect1.left, rect1.bottom, rect1.right, rect1.bottom);
        Paint.FontMetricsInt fontMetrics1 = this.textPaint.getFontMetricsInt();
        int baseline1 = (targetRect1.bottom + targetRect1.top - fontMetrics1.bottom - fontMetrics1.top) / 2;
        this.textPaint.setTextAlign(Paint.Align.RIGHT);
        double countTon = this.itemList.size() == 0 ? 0.0 : this.itemList.get(i).getCountTon();
        String textTotal = "\u5408\u8ba1 +" + countTon + " \u5428";
        canvas.drawText(textTotal, (float)targetRect1.centerX(), (float)baseline1, this.textPaint);
    }

    private Point calculateTempPoint(int left, int right, int temp) {
        double minHeight = this.tempBaseTop;
        double maxHeight = this.tempBaseBottom;
        double tempY = temp == 0 ? (double)this.tempBaseBottom : maxHeight - ((double)temp - this.minTemp) * 1.0 / (this.maxTemp - this.minTemp) * (maxHeight - minHeight);
        Log.e((String)"====", (String)("Y\uff1a" + temp));
        Point point = new Point((left + right) / 2, (int)tempY);
        return point;
    }

    private void onDrawBottomText(Canvas canvas) {
        for (int i = 0; i < this.itemCount; ++i) {
            int left = MARGIN_LEFT_ITEM + i * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT);
            int right = left + (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT) - 1;
            int top = this.dashedBetweenHeight * 4 + this.bottomLineMarginDashedLine;
            int bottom = this.dashedBetweenHeight * 4 + this.bottomLineMarginDashedLine + BOTTOM_TEXT_HEIGHT;
            Rect rect = new Rect(left, top, right, bottom);
            Rect targetRect = new Rect(rect.left, rect.bottom, rect.right, rect.bottom);
            Paint.FontMetricsInt fontMetrics = this.textPaint.getFontMetricsInt();
            int baseline = (targetRect.bottom + targetRect.top - fontMetrics.bottom - fontMetrics.top) / 2;
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            String text = this.itemList.size() == 0 ? "00-00" : this.itemList.get(i).getTime();
            canvas.drawText(text, (float)targetRect.centerX(), (float)baseline, this.textPaint);
        }
    }

    private void onDrawDashedLineAndBottomLine(Canvas canvas) {
        for (int i = 0; i < 5; ++i) {
            canvas.drawLine((float)MARGIN_LEFT_ITEM, (float)(MARGIN_LEFT_ITEM + this.dashedBetweenHeight * i), (float)(this.itemCount * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT)), (float)(MARGIN_LEFT_ITEM + this.dashedBetweenHeight * i), this.dashedPaint);
        }
        canvas.drawLine((float)MARGIN_LEFT_ITEM, (float)(MARGIN_LEFT_ITEM + this.dashedBetweenHeight * 4 + this.bottomLineMarginDashedLine), (float)(this.itemCount * (BOTTOM_TEXT_WIDTH + BOTTOM_TEXT_MARGIN_LIFT + BOTTOM_TEXT_MARGIN_RIGHT)), (float)(MARGIN_LEFT_ITEM + this.dashedBetweenHeight * 4 + this.bottomLineMarginDashedLine), this.bottomLinePaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.onActionUpEvent(event);
                break;
            }
        }
        return true;
    }

    private void onActionUpEvent(MotionEvent event) {
        boolean isValidTouch = this.validateTouch(event.getX(), event.getY());
        if (isValidTouch) {
            this.invalidate();
        }
    }

    private boolean validateTouch(float x, float y) {
        for (int i = 0; i < this.linePoint.size(); ++i) {
            if (!(x > (float)this.linePoint.get((int)i).x - Dimension.dp2px(8.0f) * 2.0f) || !(x < (float)this.linePoint.get((int)i).x + Dimension.dp2px(8.0f) * 2.0f) || !(y > (float)this.linePoint.get((int)i).y - Dimension.dp2px(8.0f) * 2.0f) || !(y < (float)this.linePoint.get((int)i).y + Dimension.dp2px(8.0f) * 2.0f)) continue;
            this.clickPosition = i;
            System.out.println("\u89e6\u6478\u4e8b\u4ef6\uff1a" + this.clickPosition);
            return true;
        }
        return false;
    }

    public void setData(List<Materials30Item> itemList) {
        this.itemList = itemList;
        this.itemCount = itemList.size() == 0 ? 7 : itemList.size();
        this.invalidate();
        this.requestLayout();
    }
}

