/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.saas.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import com.tiger.saas.widget.utils.Dimension;

public class CircleView
extends View {
    private int radius = (int)Dimension.dp2px(5.0f);
    private int color = Color.parseColor((String)"#58CC74");
    private Paint paint = new Paint();

    public void setColor(@ColorInt int color) {
        this.color = color;
        this.invalidate();
    }

    public CircleView(Context context) {
        this(context, null);
    }

    public CircleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int verticalCenter = this.getHeight() / 2;
        int horizontalCenter = this.getWidth() / 2;
        this.paint.setAntiAlias(true);
        this.paint.setColor(this.color);
        canvas.drawCircle((float)horizontalCenter, (float)verticalCenter, (float)this.radius, this.paint);
    }
}

