/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml.processor.converter;

import com.tickaroo.tikxml.TypeConverter;
import com.tickaroo.tikxml.processor.ProcessingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0005\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u00062\u0006\u0010\b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/tickaroo/tikxml/processor/converter/ConverterChecker;", "T", "", "", "()V", "getConverterFromAnnotation", "Lkotlin/reflect/KClass;", "Lcom/tickaroo/tikxml/TypeConverter;", "annotation", "(Ljava/lang/annotation/Annotation;)Lkotlin/reflect/KClass;", "getQualifiedConverterName", "", "element", "Ljavax/lang/model/element/Element;", "(Ljavax/lang/model/element/Element;Ljava/lang/annotation/Annotation;)Ljava/lang/String;", "processor-common"})
public abstract class ConverterChecker<T extends Annotation> {
    @Nullable
    public final String getQualifiedConverterName(@NotNull Element element, @NotNull T annotation) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(annotation, (String)"annotation");
        try {
            Constructor<?>[] constructors;
            Class converterClass = JvmClassMappingKt.getJavaClass(this.getConverterFromAnnotation(annotation));
            if (Intrinsics.areEqual((Object)converterClass, TypeConverter.NoneTypeConverter.class)) {
                return null;
            }
            if (!Modifier.isPublic(converterClass.getModifiers())) {
                throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " must be a public class!");
            }
            if (Modifier.isAbstract(converterClass.getModifiers())) {
                throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " cannot be a abstract");
            }
            if (Modifier.isInterface(converterClass.getModifiers())) {
                throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " cannot be an interface. Only classes are allowed!");
            }
            Constructor<?>[] constructorArray = constructors = converterClass.getConstructors();
            int n = constructorArray.length;
            for (int i = 0; i < n; ++i) {
                Constructor<?> c;
                Constructor<?> constructor = c = constructorArray[i];
                Intrinsics.checkExpressionValueIsNotNull(constructor, (String)"c");
                boolean isPublicConstructor = Modifier.isPublic(constructor.getModifiers());
                Class<?>[] paramTypes = c.getParameterTypes();
                Intrinsics.checkExpressionValueIsNotNull(paramTypes, (String)"paramTypes");
                Class<?>[] classArray = paramTypes;
                if (!(classArray.length == 0) || !isPublicConstructor) continue;
                return converterClass.getCanonicalName();
            }
            throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " must provide an empty (parameter-less) public constructor");
        }
        catch (MirroredTypeException mte) {
            Element typeConverterElement;
            TypeMirror typeMirror = mte.getTypeMirror();
            if (Intrinsics.areEqual((Object)((Object)typeMirror).toString(), (Object)Reflection.getOrCreateKotlinClass(TypeConverter.NoneTypeConverter.class).getQualifiedName())) {
                return null;
            }
            TypeMirror typeMirror2 = typeMirror;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"typeMirror");
            if (typeMirror2.getKind() != TypeKind.DECLARED) {
                throw (Throwable)new ProcessingException(element, "TypeConverter must be a class");
            }
            DeclaredType typeConverterType = (DeclaredType)typeMirror;
            Element element2 = typeConverterElement = typeConverterType.asElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"typeConverterElement");
            if (element2.getKind() != ElementKind.CLASS) {
                throw (Throwable)new ProcessingException(element, "TypeConverter " + typeConverterElement + " must be a public class!");
            }
            if (!typeConverterElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
                throw (Throwable)new ProcessingException(element, "TypeConverter " + typeConverterElement + " class is not public!");
            }
            Iterator<? extends Element> iterator = ((TypeElement)typeConverterElement).getEnclosedElements().iterator();
            while (iterator.hasNext()) {
                ExecutableElement constructor;
                Element e;
                Element element3 = e = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"e");
                if (element3.getKind() != ElementKind.CONSTRUCTOR || !(constructor = (ExecutableElement)e).getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
                return ((Object)typeMirror).toString();
            }
            throw (Throwable)new ProcessingException(element, "TypeConverter class " + typeMirror + " must provide an empty (parameter-less) public constructor");
        }
    }

    @NotNull
    protected abstract KClass<? extends TypeConverter<Object>> getConverterFromAnnotation(@NotNull T var1);
}

