/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml;

import com.tickaroo.tikxml.XmlScope;
import java.io.Closeable;
import java.io.IOException;
import okio.BufferedSink;
import okio.ByteString;

public class XmlWriter
implements Closeable {
    private static final Byte DOUBLE_QUOTE = 34;
    private static final Byte OPENING_XML_ELEMENT = 60;
    private static final Byte CLOSING_XML_ELEMENT = 62;
    private static final ByteString CLOSING_XML_ELEMENT_START = ByteString.encodeUtf8((String)"</");
    private static final ByteString INLINE_CLOSING_XML_ELEMENT = ByteString.encodeUtf8((String)"/>");
    private static final ByteString ATTRIBUTE_ASSIGNMENT_BEGIN = ByteString.encodeUtf8((String)"=\"");
    private static final ByteString OPENING_CDATA = ByteString.encodeUtf8((String)"<![CDATA[");
    private static final ByteString CLOSING_CDATA = ByteString.encodeUtf8((String)"]]>");
    private static final ByteString XML_DECLARATION = ByteString.encodeUtf8((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    private final BufferedSink sink;
    private boolean xmlDeclarationWritten = false;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String[] pathNames = new String[32];
    private int[] pathIndices = new int[32];

    private XmlWriter(BufferedSink sink) {
        this.stack[this.stackSize++] = 0;
        if (sink == null) {
            throw new NullPointerException("sink == null");
        }
        this.sink = sink;
    }

    public static XmlWriter of(BufferedSink source) {
        return new XmlWriter(source);
    }

    private void pushStack(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            int[] newPathIndices = new int[this.stackSize * 2];
            String[] newPathNames = new String[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            System.arraycopy(this.pathIndices, 0, newPathIndices, 0, this.stackSize);
            System.arraycopy(this.pathNames, 0, newPathNames, 0, this.stackSize);
            this.stack = newStack;
            this.pathIndices = newPathIndices;
            this.pathNames = newPathNames;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private void popStack() {
        this.stack[this.stackSize - 1] = 0;
        --this.stackSize;
        this.pathNames[this.stackSize] = null;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
    }

    private int peekStack() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("XML Writer is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTopOfStack(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    @Override
    public void close() throws IOException {
        this.sink.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 1) {
            throw new IOException("Incomplete document. Abrupt end at " + XmlScope.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices) + " in scope " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
        }
        this.stackSize = 0;
    }

    private IOException syntaxError(String message) throws IOException {
        throw new IOException(message + " at path " + XmlScope.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices));
    }

    public XmlWriter beginElement(String elementTagName) throws IOException {
        int topOfStack = this.peekStack();
        switch (topOfStack) {
            case 0: {
                this.replaceTopOfStack(1);
                this.pushStack(3);
                this.pathNames[this.stackSize - 1] = elementTagName;
                this.sink.writeByte((int)OPENING_XML_ELEMENT.byteValue()).writeUtf8(elementTagName);
                break;
            }
            case 5: {
                this.pushStack(3);
                this.pathNames[this.stackSize - 1] = elementTagName;
                this.sink.writeByte((int)OPENING_XML_ELEMENT.byteValue()).writeUtf8(elementTagName);
                break;
            }
            case 3: {
                this.replaceTopOfStack(5);
                this.pushStack(3);
                this.pathNames[this.stackSize - 1] = elementTagName;
                this.sink.writeByte((int)CLOSING_XML_ELEMENT.byteValue()).writeByte((int)OPENING_XML_ELEMENT.byteValue()).writeUtf8(elementTagName);
                break;
            }
            case 1: {
                throw new IOException("A xml document can only have one root xml element. There is already one but you try to add another one <" + elementTagName + ">");
            }
            default: {
                throw this.syntaxError("Unexpected begin of a new xml element <" + elementTagName + ">. New xml elements can only begin on a empty document or in a text content but tried to insert a element on scope " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
            }
        }
        return this;
    }

    public XmlWriter endElement() throws IOException {
        int topOfStack = this.peekStack();
        switch (topOfStack) {
            case 3: {
                this.sink.write(INLINE_CLOSING_XML_ELEMENT);
                this.popStack();
                break;
            }
            case 5: {
                this.sink.write(CLOSING_XML_ELEMENT_START).writeUtf8(this.pathNames[this.stackSize - 1]).writeByte((int)CLOSING_XML_ELEMENT.byteValue());
                this.popStack();
                break;
            }
            default: {
                String elementName = this.pathNames[this.stackSize - 1];
                if (elementName != null) {
                    throw this.syntaxError("Trying to close the xml element </" + elementName + "> but I'm in xml scope " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
                }
                throw this.syntaxError("Trying to close the xml element, but all xml elements are already closed properly. Xml scope is " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
            }
        }
        return this;
    }

    public XmlWriter textContent(String textContentValue) throws IOException {
        int topOfStack = this.peekStack();
        switch (topOfStack) {
            case 3: {
                this.sink.writeByte((int)CLOSING_XML_ELEMENT.byteValue());
                this.replaceTopOfStack(5);
                this.sink.writeUtf8(textContentValue);
                break;
            }
            case 5: {
                this.sink.writeUtf8(textContentValue);
                break;
            }
            default: {
                String elementName = this.pathNames[this.stackSize - 1];
                if (elementName != null) {
                    throw this.syntaxError("Error while trying to write text content into xml element <" + elementName + ">" + textContentValue + "</" + elementName + ">. Xml scope was " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
                }
                throw this.syntaxError("Error while trying to write text content \"" + textContentValue + "\". Xml scope was " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
            }
        }
        return this;
    }

    public XmlWriter textContent(int textContentValue) throws IOException {
        return this.textContent(Integer.toString(textContentValue));
    }

    public XmlWriter textContent(long textContentValue) throws IOException {
        return this.textContent(Long.toString(textContentValue));
    }

    public XmlWriter textContent(double textContentValue) throws IOException {
        return this.textContent(Double.toString(textContentValue));
    }

    public XmlWriter textContent(boolean textContentValue) throws IOException {
        return this.textContent(Boolean.toString(textContentValue));
    }

    public XmlWriter textContentAsCData(String textContentValue) throws IOException {
        int topOfStack = this.peekStack();
        switch (topOfStack) {
            case 3: {
                this.replaceTopOfStack(5);
                this.sink.writeByte((int)CLOSING_XML_ELEMENT.byteValue()).write(OPENING_CDATA).writeUtf8(textContentValue).write(CLOSING_CDATA);
                break;
            }
            case 5: {
                this.sink.write(OPENING_CDATA).writeUtf8(textContentValue).write(CLOSING_CDATA);
                break;
            }
            default: {
                String elementName = this.pathNames[this.stackSize - 1];
                if (elementName != null) {
                    throw this.syntaxError("Error while trying to write text content into xml element <" + elementName + ">" + textContentValue + "</" + elementName + ">. Xml scope was " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
                }
                throw this.syntaxError("Error while trying to write text content \"" + textContentValue + "\". Xml scope was " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
            }
        }
        return this;
    }

    public XmlWriter attribute(String attributeName, String value) throws IOException {
        if (3 != this.peekStack()) {
            throw this.syntaxError("Error while trying to write attribute " + attributeName + "=\"" + value + "\". Attributes can only be written in a opening xml element but was in xml scope " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
        }
        this.sink.writeByte(32).writeUtf8(attributeName).write(ATTRIBUTE_ASSIGNMENT_BEGIN).writeUtf8(value).writeByte((int)DOUBLE_QUOTE.byteValue());
        return this;
    }

    public XmlWriter attribute(String attributeName, int value) throws IOException {
        return this.attribute(attributeName, Integer.toString(value));
    }

    public XmlWriter attribute(String attributeName, long value) throws IOException {
        return this.attribute(attributeName, Long.toString(value));
    }

    public XmlWriter attribute(String attributeName, boolean value) throws IOException {
        return this.attribute(attributeName, Boolean.toString(value));
    }

    public XmlWriter attribute(String attributeName, double value) throws IOException {
        return this.attribute(attributeName, Double.toString(value));
    }

    public XmlWriter xmlDeclaration() throws IOException {
        if (!this.xmlDeclarationWritten) {
            if (this.peekStack() != 0) {
                throw this.syntaxError("Xml Declatraion " + XML_DECLARATION.utf8() + " can only be written at the beginning of a xml document! You are not at the beginning of a xml document: current xml scope is " + XmlScope.getTopStackElementAsToken(this.stackSize, this.stack));
            }
        } else {
            throw new IOException("Xml declaration " + XML_DECLARATION.utf8() + " has already been written in this xml document. Xml declaration can only be written once at the beginning of the document.");
        }
        this.sink.write(XML_DECLARATION);
        this.xmlDeclarationWritten = true;
        return this;
    }

    public XmlWriter namespace(String prefix, String uri) throws IOException {
        if (prefix != null && prefix.length() > 0) {
            return this.attribute("xmlns:" + prefix, uri);
        }
        return this.attribute("xmlns", uri);
    }

    public XmlWriter namespace(String uri) throws IOException {
        return this.namespace(null, uri);
    }
}

