/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml;

import java.io.IOException;

final class XmlScope {
    static final int EMPTY_DOCUMENT = 0;
    static final int NONEMPTY_DOCUMENT = 1;
    static final int ELEMENT_OPENING = 3;
    static final int ELEMENT_ATTRIBUTE = 4;
    static final int ELEMENT_CONTENT = 5;
    static final int CLOSED = 6;

    XmlScope() {
    }

    static String getTopStackElementAsToken(int stackSize, int[] stack) throws IOException {
        switch (stack[stackSize - 1]) {
            case 3: {
                return "ELEMENT_OPENING";
            }
            case 0: {
                return "EMPTY_DOCUMENT";
            }
            case 1: {
                return "NONEMPTY_DOCUMENT";
            }
            case 4: {
                return "ELEMENT_ATTRIBUTE";
            }
            case 5: {
                return "ELEMENT_CONTENT";
            }
            case 6: {
                return "CLOSED";
            }
        }
        throw new IOException("Unexpected token on top of the stack. Was " + stack[stackSize - 1]);
    }

    static String getPath(int stackSize, int[] stack, String[] pathNames, int[] pathIndices) {
        StringBuilder result = new StringBuilder();
        int size = stackSize;
        block5: for (int i = 0; i < size; ++i) {
            switch (stack[i]) {
                case 3: {
                    result.append('/');
                    if (pathNames[i] == null) continue block5;
                    result.append(pathNames[i]);
                    continue block5;
                }
                case 5: {
                    result.append('/');
                    if (pathNames[i] == null) continue block5;
                    result.append(pathNames[i]);
                    if (i != stackSize - 1) continue block5;
                    result.append("/text()");
                    continue block5;
                }
                case 4: {
                    if (pathNames[i] == null) continue block5;
                    result.append("[@");
                    result.append(pathNames[i]);
                    result.append(']');
                    continue block5;
                }
            }
        }
        return result.length() == 0 ? "/" : result.toString();
    }
}

