/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml;

import com.tickaroo.tikxml.XmlDataException;
import com.tickaroo.tikxml.XmlScope;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

public class XmlReader
implements Closeable {
    private static final ByteString UNQUOTED_STRING_TERMINALS = ByteString.encodeUtf8((String)" >/=\n");
    private static final ByteString CDATA_CLOSE = ByteString.encodeUtf8((String)"]]>");
    private static final ByteString CDATA_OPEN = ByteString.encodeUtf8((String)"<![CDATA[");
    private static final ByteString DOCTYPE_OPEN = ByteString.encodeUtf8((String)"<!DOCTYPE");
    private static final ByteString COMMENT_CLOSE = ByteString.encodeUtf8((String)"-->");
    private static final ByteString XML_DECLARATION_CLOSE = ByteString.encodeUtf8((String)"?>");
    private static final ByteString UTF8_BOM = ByteString.of((byte[])new byte[]{-17, -69, -65});
    private static final byte DOUBLE_QUOTE = 34;
    private static final byte SINGLE_QUOTE = 39;
    private static final byte OPENING_XML_ELEMENT = 60;
    private static final byte CLOSING_XML_ELEMENT = 62;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_ELEMENT_BEGIN = 1;
    private static final int PEEKED_ELEMENT_END = 2;
    private static final int PEEKED_ELEMENT_TEXT_CONTENT = 3;
    private static final int PEEKED_EOF = 4;
    private static final int PEEKED_ELEMENT_NAME = 5;
    private static final int PEEKED_DOUBLE_QUOTED = 6;
    private static final int PEEKED_SINGLE_QUOTED = 7;
    private static final int PEEKED_ATTRIBUTE_NAME = 8;
    private static final int PEEKED_CDATA = 9;
    private int peeked = 0;
    private String[] pathNames = new String[32];
    private int[] pathIndices = new int[32];
    private int[] stack = new int[32];
    private int stackSize = 0;
    private final BufferedSource source;
    private final Buffer buffer;

    private XmlReader(BufferedSource source) {
        this.stack[this.stackSize++] = 0;
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        this.source = source;
        this.buffer = source.buffer();
    }

    public static XmlReader of(BufferedSource source) {
        return new XmlReader(source);
    }

    public XmlToken peek() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        switch (p) {
            case 1: {
                return XmlToken.ELEMENT_BEGIN;
            }
            case 5: {
                return XmlToken.ELEMENT_NAME;
            }
            case 2: {
                return XmlToken.ELEMENT_END;
            }
            case 8: {
                return XmlToken.ATTRIBUTE_NAME;
            }
            case 6: 
            case 7: {
                return XmlToken.ATTRIBUTE_VALUE;
            }
            case 3: 
            case 9: {
                return XmlToken.ELEMENT_TEXT_CONTENT;
            }
            case 4: {
                return XmlToken.END_OF_DOCUMENT;
            }
        }
        throw new AssertionError((Object)("Unknown XmlToken: Peeked = " + p));
    }

    private int doPeek() throws IOException {
        int c;
        int peekStack;
        block35: {
            block34: {
                peekStack = this.stack[this.stackSize - 1];
                if (peekStack == 3) {
                    int c2 = this.nextNonWhitespace(true);
                    if (this.isLiteral((char)c2)) {
                        this.peeked = 5;
                        return 5;
                    }
                    throw this.syntaxError("Expected xml element name (literal expected)");
                }
                if (peekStack != 4) break block34;
                c = this.nextNonWhitespace(true);
                if (this.isLiteral(c)) {
                    this.peeked = 8;
                    return 8;
                }
                switch (c) {
                    case 62: {
                        this.popStack();
                        this.stack[this.stackSize - 1] = 5;
                        this.buffer.readByte();
                        int nextChar = this.nextNonWhitespace(true);
                        if (nextChar != 60) {
                            this.peeked = 3;
                            return 3;
                        }
                        if (this.isCDATA()) {
                            this.buffer.skip(9L);
                            this.peeked = 9;
                            return 9;
                        }
                        break block35;
                    }
                    case 47: {
                        if (this.fillBuffer(2L) && this.buffer.getByte(1L) == 62) {
                            this.popStack();
                            this.buffer.skip(2L);
                            this.peeked = 2;
                            return 2;
                        }
                        throw this.syntaxError("Expected closing />");
                    }
                    case 61: {
                        this.buffer.readByte();
                        c = this.nextNonWhitespace(true);
                        switch (c) {
                            case 34: {
                                this.buffer.readByte();
                                this.peeked = 6;
                                return 6;
                            }
                            case 39: {
                                this.buffer.readByte();
                                this.peeked = 7;
                                return 7;
                            }
                        }
                        throw this.syntaxError("Expected double quote (\") or single quote (') while reading xml elements attribute");
                    }
                    default: {
                        throw this.syntaxError("Unexpected character '" + (char)c + "' while trying to read xml elements attribute");
                    }
                }
            }
            if (peekStack == 5) {
                c = this.nextNonWhitespace(true);
                if (c != 60) {
                    this.peeked = 3;
                    return 3;
                }
                if (this.isCDATA()) {
                    this.buffer.skip(9L);
                    this.peeked = 9;
                    return 9;
                }
            } else if (peekStack == 0) {
                this.stack[this.stackSize - 1] = 1;
            } else if (peekStack == 1) {
                c = this.nextNonWhitespace(false);
                if (c == -1) {
                    this.peeked = 4;
                    return 4;
                }
            } else if (peekStack == 6) {
                throw new IllegalStateException("XmlReader is closed");
            }
        }
        c = this.nextNonWhitespace(true, peekStack == 0);
        switch (c) {
            case 60: {
                this.buffer.readByte();
                if (this.fillBuffer(1L) && this.buffer.getByte(0L) == 47) {
                    this.buffer.readByte();
                    String closingElementName = this.nextUnquotedValue();
                    if (closingElementName != null && closingElementName.equals(this.pathNames[this.stackSize - 1])) {
                        if (this.nextNonWhitespace(false) == 62) {
                            this.buffer.readByte();
                            this.peeked = 2;
                            return 2;
                        }
                        this.syntaxError("Missing closing '>' character in </" + this.pathNames[this.stackSize - 1]);
                    } else {
                        this.syntaxError("Expected a closing element tag </" + this.pathNames[this.stackSize - 1] + "> but found </" + closingElementName + ">");
                    }
                }
                this.peeked = 1;
                return 1;
            }
            case 34: {
                this.buffer.readByte();
                this.peeked = 6;
                return 6;
            }
            case 39: {
                this.buffer.readByte();
                this.peeked = 7;
                return 7;
            }
        }
        return 0;
    }

    private boolean isCDATA() throws IOException {
        return this.buffer.rangeEquals(0L, CDATA_OPEN);
    }

    private boolean isDocTypeDefinition() throws IOException {
        return this.buffer.size() >= (long)DOCTYPE_OPEN.size() && this.buffer.snapshot(DOCTYPE_OPEN.size()).toAsciiUppercase().equals((Object)DOCTYPE_OPEN);
    }

    public void beginElement() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 1) {
            throw new XmlDataException("Expected " + (Object)((Object)XmlToken.ELEMENT_BEGIN) + " but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.pushStack(3);
        this.peeked = 0;
    }

    public void endElement() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 2) {
            throw this.syntaxError("Expected end of element but was " + (Object)((Object)this.peek()));
        }
        this.popStack();
        this.peeked = 0;
    }

    public boolean hasElement() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        return p == 1;
    }

    public boolean hasAttribute() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        return p == 8;
    }

    public String nextAttributeName() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 8) {
            throw this.syntaxError("Expected xml element attribute name but was " + (Object)((Object)this.peek()));
        }
        String result = this.nextUnquotedValue();
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        return result;
    }

    public String nextAttributeValue() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 6 || p == 7) {
            String attributeValue = this.nextQuotedValue(p == 6 ? (byte)34 : 39);
            this.peeked = 0;
            this.pathNames[this.stackSize - 1] = null;
            return attributeValue;
        }
        throw new XmlDataException("Expected xml element attribute value (in double quotes or single quotes) but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
    }

    public int nextAttributeValueAsInt() throws IOException {
        return Integer.parseInt(this.nextAttributeValue());
    }

    public long nextAttributeValueAsLong() throws IOException {
        return Long.parseLong(this.nextAttributeValue());
    }

    public boolean nextAttributeValueAsBoolean() throws IOException {
        return Boolean.parseBoolean(this.nextAttributeValue());
    }

    public double nextAttributeValueAsDouble() throws IOException {
        return Double.parseDouble(this.nextAttributeValue());
    }

    public void skipAttributeValue() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 6 && p != 7) {
            throw new XmlDataException("Expected xml element attribute value (in double quotes or single quotes) but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = null;
        this.skipQuotedValue(p == 6 ? (byte)34 : 39);
    }

    public void skipAttribute() throws IOException {
        this.nextAttributeName();
        this.skipAttributeValue();
    }

    public boolean hasTextContent() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        return p == 3 || p == 9;
    }

    public String nextTextContent() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 3) {
            this.peeked = 0;
            long index = this.source.indexOf((byte)60);
            if (index == -1L) {
                throw this.syntaxError("Unterminated element text content. Expected </" + this.pathNames[this.stackSize - 1] + "> but haven't found");
            }
            return this.buffer.readUtf8(index);
        }
        if (p == 9) {
            this.peeked = 0;
            long index = this.indexOfClosingCDATA();
            String result = this.buffer.readUtf8(index);
            this.buffer.skip(3L);
            return result;
        }
        if (p == 2) {
            return "";
        }
        throw new XmlDataException("Expected xml element text content but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
    }

    public int nextTextContentAsInt() throws IOException {
        String content = this.nextTextContent();
        if (content.equals("")) {
            return 0;
        }
        return Integer.parseInt(content);
    }

    public long nextTextContentAsLong() throws IOException {
        String content = this.nextTextContent();
        if (content.equals("")) {
            return 0L;
        }
        return Long.parseLong(content);
    }

    public double nextTextContentAsDouble() throws IOException {
        String content = this.nextTextContent();
        if (content.equals("")) {
            return 0.0;
        }
        return Double.parseDouble(content);
    }

    public boolean nextTextContentAsBoolean() throws IOException {
        String content = this.nextTextContent();
        if (content.equals("")) {
            return false;
        }
        return Boolean.parseBoolean(content);
    }

    private long indexOfClosingCDATA() throws IOException {
        long index = this.source.indexOf(CDATA_CLOSE);
        if (index == -1L) {
            throw new EOFException("<![CDATA[ at " + this.getPath() + " has never been closed with ]]>");
        }
        return index;
    }

    public void skipTextContent() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 3) {
            this.peeked = 0;
            long index = this.source.indexOf((byte)60);
            if (index == -1L) {
                throw this.syntaxError("Unterminated element text content. Expected </" + this.pathNames[this.stackSize - 1] + "> but haven't found");
            }
            this.buffer.skip(index);
        } else if (p == 9) {
            this.peeked = 0;
            long index = this.indexOfClosingCDATA();
            this.buffer.skip(index + 3L);
        } else {
            throw new XmlDataException("Expected xml element text content but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
    }

    private void pushStack(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            int[] newPathIndices = new int[this.stackSize * 2];
            String[] newPathNames = new String[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            System.arraycopy(this.pathIndices, 0, newPathIndices, 0, this.stackSize);
            System.arraycopy(this.pathNames, 0, newPathNames, 0, this.stackSize);
            this.stack = newStack;
            this.pathIndices = newPathIndices;
            this.pathNames = newPathNames;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private void popStack() {
        this.stack[this.stackSize - 1] = 0;
        --this.stackSize;
        this.pathNames[this.stackSize] = null;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
    }

    public String getPath() {
        return XmlScope.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices);
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.buffer.clear();
        this.source.close();
    }

    private boolean fillBuffer(long minimum) throws IOException {
        return this.source.request(minimum);
    }

    private int nextNonWhitespace(boolean throwOnEof) throws IOException {
        return this.nextNonWhitespace(throwOnEof, false);
    }

    private int nextNonWhitespace(boolean throwOnEof, boolean isDocumentBeginning) throws IOException {
        if (isDocumentBeginning && this.source.rangeEquals(0L, UTF8_BOM)) {
            this.source.skip(3L);
        }
        int p = 0;
        while (this.fillBuffer(p + 1)) {
            byte c;
            if ((c = this.buffer.getByte((long)p++)) == 10 || c == 32 || c == 13 || c == 9) continue;
            this.buffer.skip((long)(p - 1));
            if (c == 60 && !this.isCDATA()) {
                long index;
                byte peek = this.buffer.getByte(1L);
                int peekStack = this.stack[this.stackSize - 1];
                if (peekStack == 1 && this.isDocTypeDefinition()) {
                    index = this.source.indexOf((byte)62, (long)DOCTYPE_OPEN.size());
                    if (index == -1L) {
                        throw this.syntaxError("Unterminated <!DOCTYPE> . Inline DOCTYPE is not support at the moment.");
                    }
                    this.source.skip(index + 1L);
                    p = 0;
                    continue;
                }
                if (peek == 33 && this.fillBuffer(4L)) {
                    index = this.source.indexOf(COMMENT_CLOSE, 4L);
                    if (index == -1L) {
                        throw this.syntaxError("Unterminated comment");
                    }
                    this.source.skip(index + (long)COMMENT_CLOSE.size());
                    p = 0;
                    continue;
                }
                if (peek == 63) {
                    index = this.source.indexOf(XML_DECLARATION_CLOSE, 2L);
                    if (index == -1L) {
                        throw this.syntaxError("Unterminated xml declaration or processing instruction \"<?\"");
                    }
                    this.source.skip(index + (long)XML_DECLARATION_CLOSE.size());
                    p = 0;
                    continue;
                }
            }
            return c;
        }
        if (throwOnEof) {
            throw new EOFException("Unexpected end of input at path " + this.getPath());
        }
        return -1;
    }

    private IOException syntaxError(String message) throws IOException {
        throw new IOException(message + " at path " + this.getPath());
    }

    public String nextElementName() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 5) {
            throw this.syntaxError("Expected XML Tag Element name, but have " + (Object)((Object)this.peek()));
        }
        String result = this.nextUnquotedValue();
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        this.pushStack(4);
        return result;
    }

    private String nextUnquotedValue() throws IOException {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        return i != -1L ? this.buffer.readUtf8(i) : this.buffer.readUtf8();
    }

    private String nextQuotedValue(byte runTerminator) throws IOException {
        long index;
        StringBuilder builder = null;
        while (true) {
            if ((index = this.source.indexOf(runTerminator)) == -1L) {
                throw this.syntaxError("Unterminated string (" + (runTerminator == 34 ? "double quote \"" : "single quote '") + " is missing)");
            }
            if (this.buffer.getByte(index) != 92) break;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            builder.append(this.readEscapeCharacter());
        }
        if (builder == null) {
            String result = this.buffer.readUtf8(index);
            this.buffer.readByte();
            return result;
        }
        builder.append(this.buffer.readUtf8(index));
        this.buffer.readByte();
        return builder.toString();
    }

    private boolean isLiteral(int c) {
        switch (c) {
            case 32: 
            case 47: 
            case 60: 
            case 61: 
            case 62: {
                return false;
            }
        }
        return true;
    }

    private char readEscapeCharacter() throws IOException {
        if (!this.fillBuffer(1L)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        byte escaped = this.buffer.readByte();
        switch (escaped) {
            case 117: {
                int i;
                if (!this.fillBuffer(4L)) {
                    throw new EOFException("Unterminated escape sequence at path " + this.getPath());
                }
                char result = '\u0000';
                int end = i + 4;
                for (i = 0; i < end; ++i) {
                    byte c = this.buffer.getByte((long)i);
                    result = (char)(result << 4);
                    if (c >= 48 && c <= 57) {
                        result = (char)(result + (c - 48));
                        continue;
                    }
                    if (c >= 97 && c <= 102) {
                        result = (char)(result + (c - 97 + 10));
                        continue;
                    }
                    if (c >= 65 && c <= 70) {
                        result = (char)(result + (c - 65 + 10));
                        continue;
                    }
                    throw this.syntaxError("\\u" + this.buffer.readUtf8(4L));
                }
                this.buffer.skip(4L);
                return result;
            }
            case 116: {
                return '\t';
            }
            case 98: {
                return '\b';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 102: {
                return '\f';
            }
        }
        return (char)escaped;
    }

    private void skipQuotedValue(Byte runTerminator) throws IOException {
        long index;
        while (true) {
            if ((index = this.source.indexOf(runTerminator.byteValue())) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(index) != 92) break;
            this.buffer.skip(index + 1L);
            this.readEscapeCharacter();
        }
        this.buffer.skip(index + 1L);
    }

    public void skipRemainingElement() throws IOException {
        int stackPeek = this.stack[this.stackSize - 1];
        if (stackPeek != 3 && stackPeek != 4) {
            throw new AssertionError((Object)"This method can only be invoked after having consumed the opening element via beginElement()");
        }
        int count = 1;
        do {
            switch (this.peek()) {
                case ELEMENT_BEGIN: {
                    this.beginElement();
                    ++count;
                    break;
                }
                case ELEMENT_END: {
                    this.endElement();
                    --count;
                    break;
                }
                case ELEMENT_NAME: {
                    this.nextElementName();
                    break;
                }
                case ATTRIBUTE_NAME: {
                    this.nextAttributeName();
                    break;
                }
                case ATTRIBUTE_VALUE: {
                    this.skipAttributeValue();
                    break;
                }
                case ELEMENT_TEXT_CONTENT: {
                    this.skipTextContent();
                    break;
                }
                case END_OF_DOCUMENT: {
                    if (count == 0) break;
                    throw this.syntaxError("Unexpected end of file! At least one xml element is not closed!");
                }
                default: {
                    throw new AssertionError((Object)"Oops, there is something not implemented correctly internally. Please fill an issue on https://github.com/Tickaroo/tikxml/issues . Please include stacktrace and the model class you try to parse");
                }
            }
            this.peeked = 0;
        } while (count != 0);
    }

    public static enum XmlToken {
        ELEMENT_BEGIN,
        ELEMENT_NAME,
        ELEMENT_END,
        ATTRIBUTE_NAME,
        ATTRIBUTE_VALUE,
        ELEMENT_TEXT_CONTENT,
        END_OF_DOCUMENT;

    }
}

