/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml;

import com.tickaroo.tikxml.TypeAdapterNotFoundException;
import com.tickaroo.tikxml.Types;
import com.tickaroo.tikxml.typeadapter.TypeAdapter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

final class TypeAdapters {
    private static final String AUTO_VALUE_NAME_PREFIX = "\\$*AutoValue_.+";
    private final Map<Type, TypeAdapter<?>> adaptersCache = new HashMap();

    TypeAdapters() {
    }

    <T> void add(Type clazz, TypeAdapter<T> adapter) {
        this.adaptersCache.put(clazz, adapter);
    }

    public <T> TypeAdapter<T> get(Type type) throws TypeAdapterNotFoundException {
        TypeAdapter<?> adapter = this.adaptersCache.get(type = Types.canonicalize(type));
        if (adapter != null) {
            return adapter;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            StringBuilder qualifiedTypeAdapterClassName = new StringBuilder();
            try {
                String packageName;
                Package packageElement = clazz.getPackage();
                if (packageElement != null && (packageName = packageElement.getName()) != null && packageName.length() > 0) {
                    qualifiedTypeAdapterClassName.append(packageElement.getName());
                    qualifiedTypeAdapterClassName.append('.');
                }
                qualifiedTypeAdapterClassName.append(clazz.getSimpleName());
                qualifiedTypeAdapterClassName.append("$$TypeAdapter");
                try {
                    Class<?> adapterClass = Class.forName(qualifiedTypeAdapterClassName.toString());
                    TypeAdapter adapterInstance = (TypeAdapter)adapterClass.newInstance();
                    this.adaptersCache.put(clazz, adapterInstance);
                    return adapterInstance;
                }
                catch (ClassNotFoundException e) {
                    if (clazz.getSimpleName().matches(AUTO_VALUE_NAME_PREFIX)) {
                        Class superClass = clazz.getSuperclass();
                        if (superClass != null) {
                            TypeAdapter<T> superClassAdapter = this.get(superClass);
                            this.adaptersCache.put(clazz, superClassAdapter);
                            return superClassAdapter;
                        }
                        throw new TypeAdapterNotFoundException("No TypeAdapter for class " + clazz.getCanonicalName() + " found. Expected name of the type adapter is " + qualifiedTypeAdapterClassName.toString(), e);
                    }
                    throw new TypeAdapterNotFoundException("No TypeAdapter for class " + clazz.getCanonicalName() + " found. Expected name of the type adapter is " + qualifiedTypeAdapterClassName.toString(), e);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new TypeAdapterNotFoundException("No TypeAdapter for class " + clazz.getCanonicalName() + " found. Expected name of the type adapter is " + qualifiedTypeAdapterClassName.toString(), e);
            }
        }
        throw new TypeAdapterNotFoundException("No generated nor manually added TypeAdapter has been found for " + type.toString());
    }
}

