/*
 * Decompiled with CFR 0.152.
 */
package com.tiancaicc.springfloatingactionmenu;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.DimenRes;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import com.readystatesoftware.systembartint.SystemBarTintManager;

public class Utils {
    private static final String TAG = "Utils";

    public static int getDimension(Context context, @DimenRes int id2) {
        return context.getResources().getDimensionPixelSize(id2);
    }

    public static final int dpToPx(float dp, Resources res) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)res.getDisplayMetrics());
    }

    public static final FrameLayout.LayoutParams createLayoutParams(int width, int height) {
        return new FrameLayout.LayoutParams(width, height);
    }

    public static final FrameLayout.LayoutParams createMatchParams() {
        return Utils.createLayoutParams(-1, -1);
    }

    public static final FrameLayout.LayoutParams createWrapParams() {
        return Utils.createLayoutParams(-2, -2);
    }

    public static final FrameLayout.LayoutParams createWrapMatchParams() {
        return Utils.createLayoutParams(-2, -1);
    }

    public static final FrameLayout.LayoutParams createMatchWrapParams() {
        return Utils.createLayoutParams(-1, -2);
    }

    public static void setInsets(Activity context, View view) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        SystemBarTintManager tintManager = new SystemBarTintManager(context);
        SystemBarTintManager.SystemBarConfig config = tintManager.getConfig();
        view.setPadding(0, config.getPixelInsetTop(false), config.getPixelInsetRight(), config.getPixelInsetBottom());
    }

    public static int getInsetsTop(Activity context, View view) {
        if (Build.VERSION.SDK_INT < 19) {
            return 0;
        }
        SystemBarTintManager tintManager = new SystemBarTintManager(context);
        SystemBarTintManager.SystemBarConfig config = tintManager.getConfig();
        return config.getPixelInsetTop(false);
    }

    public static int getInsetsBottom(Activity context, View view) {
        if (Build.VERSION.SDK_INT < 19) {
            return 0;
        }
        SystemBarTintManager tintManager = new SystemBarTintManager(context);
        SystemBarTintManager.SystemBarConfig config = tintManager.getConfig();
        return config.getPixelInsetBottom();
    }
}

