/*
 * Decompiled with CFR 0.152.
 */
package com.tiancaicc.springfloatingactionmenu;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Handler;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import com.facebook.rebound.Spring;
import com.facebook.rebound.SpringListener;
import com.facebook.rebound.SpringSystem;
import com.facebook.rebound.ui.Util;
import com.melnykov.fab.FloatingActionButton;
import com.tiancaicc.springfloatingactionmenu.DestroySelfSpringListener;
import com.tiancaicc.springfloatingactionmenu.MenuItem;
import com.tiancaicc.springfloatingactionmenu.MenuItemView;
import com.tiancaicc.springfloatingactionmenu.OnFabClickListener;
import com.tiancaicc.springfloatingactionmenu.OnMenuActionListener;
import com.tiancaicc.springfloatingactionmenu.R;
import com.tiancaicc.springfloatingactionmenu.Utils;
import com.tumblr.backboard.Actor;
import com.tumblr.backboard.MotionProperty;
import com.tumblr.backboard.imitator.SpringImitator;
import com.tumblr.backboard.performer.MapPerformer;
import com.tumblr.backboard.performer.Performer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public class SpringFloatingActionMenu
extends FrameLayout
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final String TAG = "SFAM";
    public static final int ANIMATION_TYPE_BLOOM = 0;
    public static final int ANIMATION_TYPE_TUMBLR = 1;
    private Context mContext;
    private FloatingActionButton mFAB;
    private View mRevealCircle;
    private ArrayList<MenuItem> mMenuItems;
    private ArrayList<ImageButton> mFollowCircles;
    private ArrayList<MenuItemView> mMenuItemViews;
    private ViewGroup mContainerView;
    private ArrayList<OnMenuActionListener> mActionListeners;
    private OnFabClickListener mOnFabClickListener;
    @ColorRes
    private int mRevealColor;
    private int mMenuItemCount;
    private int mGravity;
    private int mMarginSize = 16;
    private boolean mMenuOpen = false;
    private int mAnimationType;
    private int mRevealDuration = 600;
    private int mTumblrTimeInterval = 70;
    private boolean mAnimating = false;
    private boolean mEnableFollowAnimation = true;

    public SpringFloatingActionMenu(Builder builder) {
        super(builder.context);
        this.mContext = builder.context;
        this.mMenuItems = builder.menuItems;
        this.mFAB = builder.fab;
        this.mMenuItemCount = builder.menuItems.size();
        this.mGravity = builder.gravity;
        this.mActionListeners = builder.actionListeners;
        this.mRevealColor = builder.revealColor;
        this.mAnimationType = builder.animationType;
        this.mOnFabClickListener = builder.onFabClickListener;
        this.mEnableFollowAnimation = builder.enableFollowAnimation;
        this.init(this.mContext);
    }

    public SpringFloatingActionMenu(Context context) {
        this(context, null, 0);
    }

    public SpringFloatingActionMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SpringFloatingActionMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mContainerView = new FrameLayout(context);
        this.mRevealCircle = this.generateRevealCircle();
        this.mContainerView.addView(this.mRevealCircle);
        if (this.mEnableFollowAnimation) {
            this.mFollowCircles = this.generateFollowCircles();
            for (int i = this.mFollowCircles.size() - 1; i >= 0; --i) {
                this.addView((View)this.mFollowCircles.get(i));
            }
        }
        this.mMenuItemViews = this.generateMenuItemViews();
        for (MenuItemView menuItemView : this.mMenuItemViews) {
            this.mContainerView.addView((View)menuItemView);
            this.addOnMenuActionListener(menuItemView);
        }
        this.mMenuItemViews.get(0).bringToFront();
        FrameLayout.LayoutParams fablp = Utils.createWrapParams();
        fablp.gravity = this.mGravity;
        this.addView((View)this.mFAB, (ViewGroup.LayoutParams)fablp);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        ViewGroup rootView = (ViewGroup)((Activity)this.mContext).findViewById(0x1020002);
        rootView.addView((View)this);
        this.bringToFront();
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.mFAB.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SpringFloatingActionMenu.this.mAnimating) {
                    return;
                }
                if (SpringFloatingActionMenu.this.mOnFabClickListener != null) {
                    SpringFloatingActionMenu.this.mOnFabClickListener.onClcik();
                }
                if (SpringFloatingActionMenu.this.mMenuOpen) {
                    SpringFloatingActionMenu.this.hideMenu();
                } else {
                    SpringFloatingActionMenu.this.showMenu();
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        Resources resources = this.getResources();
        Activity context = (Activity)this.mContext;
        int fabWidth = this.mFAB.getMeasuredWidth();
        int fabHeight = this.mFAB.getMeasuredHeight();
        int bottomInsets = Utils.getInsetsBottom(context, (View)this);
        int fabX = 0;
        int fabY = 0;
        if (this.mGravity == 85) {
            int marginX = Utils.dpToPx(this.mMarginSize, resources);
            int marginY = Utils.dpToPx(this.mMarginSize, resources) + bottomInsets;
            fabX = right - fabWidth - marginX;
            fabY = bottom - fabHeight - marginY;
            this.mFAB.layout(fabX, fabY, fabX + fabWidth, fabY + fabHeight);
        } else if (this.mGravity == 81) {
            int marginY = Utils.dpToPx(this.mMarginSize, resources) + bottomInsets;
            fabX = right / 2 - fabWidth / 2;
            fabY = bottom - fabHeight - marginY;
            this.mFAB.layout(fabX, fabY, fabX + fabWidth, fabY + fabHeight);
        } else {
            throw new IllegalStateException("gravity only support bottom center and bottom right");
        }
        int fabCenterX = fabX + fabWidth / 2;
        int fabCenterY = fabY + fabHeight / 2;
        for (ImageButton circle : this.mFollowCircles) {
            int x = fabCenterX - circle.getWidth() / 2;
            int y = fabCenterY - circle.getHeight() / 2;
            circle.layout(x, y, x + circle.getMeasuredWidth(), y + circle.getMeasuredHeight());
        }
        int x = fabCenterX - this.mRevealCircle.getWidth() / 2;
        int y = fabCenterY - this.mRevealCircle.getHeight() / 2;
        this.mRevealCircle.layout(x, y, x + this.mRevealCircle.getMeasuredWidth(), y + this.mRevealCircle.getMeasuredHeight());
        this.layoutMenuItems(left, top, right, bottom);
    }

    private void layoutMenuItems(int left, int top, int right, int bottom) {
        switch (this.mAnimationType) {
            case 0: {
                this.layoutMenuItemsAsGrid(left, top, right, bottom);
                break;
            }
            case 1: {
                this.layoutMenuItemsAsTumblr(left, top, right, bottom);
            }
        }
    }

    private void layoutMenuItemsAsGrid(int left, int top, int right, int bottom) {
        Resources resources = this.getResources();
        int edgeGap = Util.dpToPx((float)24.0f, (Resources)resources);
        int colCount = 3;
        int rowCount = this.mMenuItemCount % colCount == 0 ? this.mMenuItemCount / colCount : this.mMenuItemCount / colCount + 1;
        Log.d((String)TAG, (String)("row count:" + rowCount));
        int itemHeight = this.mMenuItemViews.get(0).getMeasuredHeight();
        int itemWidth = this.mMenuItemViews.get(0).getMeasuredWidth();
        int containerWidth = this.getMeasuredWidth();
        int containerHeight = this.getMeasuredHeight();
        int itemGap = (containerWidth - 2 * edgeGap - colCount * itemWidth) / (colCount - 1);
        int tbGap = (containerHeight - rowCount * itemHeight - itemGap * (rowCount - 1)) / 2;
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            int idxInItem;
            for (int colIdx = 0; colIdx < colCount && (idxInItem = rowIdx * colCount + colIdx) < this.mMenuItemCount; ++colIdx) {
                View item = (View)this.mMenuItemViews.get(rowIdx * colCount + colIdx);
                Log.d((String)TAG, (String)("menu item index:" + (rowIdx * colCount + colIdx)));
                int itemLeft = edgeGap + colIdx * itemWidth + colIdx * itemGap;
                int itemTop = tbGap + rowIdx * itemGap + rowIdx * itemHeight;
                item.layout(itemLeft, itemTop, itemLeft + itemWidth, itemTop + itemHeight);
            }
        }
    }

    private void layoutMenuItemsAsTumblr(int left, int top, int right, int bottom) {
        if (this.mMenuItemCount < 4 || this.mMenuItemCount > 7) {
            throw new IllegalStateException("layout as tumblr style must have morn than 4 items,less than 7 items");
        }
        int itemHeight = this.mMenuItemViews.get(0).getMeasuredHeight();
        int itemWidth = this.mMenuItemViews.get(0).getMeasuredWidth();
        int itemDiameter = this.mMenuItemViews.get(0).getDiameter();
        int itemRadius = itemDiameter / 2;
        int ringRadius = (int)((double)itemDiameter * 1.6);
        int containerWidth = this.getMeasuredWidth();
        int containerHeight = this.getMeasuredHeight();
        int ringCenterX = containerWidth / 2;
        int ringCenterY = containerHeight / 2;
        int firstX = containerWidth / 2 - itemRadius;
        int firstY = containerHeight / 2 - itemRadius;
        View firstItem = (View)this.mMenuItemViews.get(0);
        firstItem.layout(firstX, firstY, firstX + itemWidth, firstY + itemHeight);
        double arcunit = Math.PI * 2 / (double)(this.mMenuItemCount - 1);
        for (int i = 0; i < this.mMenuItemCount - 1; ++i) {
            View item = (View)this.mMenuItemViews.get(i + 1);
            double arc = arcunit * (double)i;
            int x = (int)((double)ringCenterX + (double)ringRadius * Math.sin(arc) - (double)itemRadius);
            int y = (int)((double)ringCenterY - (double)ringRadius * Math.cos(arc) - (double)itemRadius);
            item.layout(x, y, x + item.getMeasuredWidth(), y + item.getMeasuredHeight());
        }
    }

    private ArrayList<ImageButton> generateFollowCircles() {
        int diameter = this.mFAB.getType() == 0 ? Utils.getDimension(this.mContext, R.dimen.fab_size_normal) : Utils.getDimension(this.mContext, R.dimen.fab_size_mini);
        ArrayList<ImageButton> circles = new ArrayList<ImageButton>(this.mMenuItems.size());
        for (MenuItem item : this.mMenuItems) {
            ImageButton circle = new ImageButton(this.mContext);
            OvalShape ovalShape = new OvalShape();
            ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)ovalShape);
            shapeDrawable.getPaint().setColor(this.getResources().getColor(item.getBgColor()));
            circle.setBackgroundDrawable((Drawable)shapeDrawable);
            circle.setImageResource(item.getIcon());
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(diameter, diameter);
            circle.setLayoutParams((ViewGroup.LayoutParams)lp);
            circles.add(circle);
        }
        return circles;
    }

    private ArrayList<MenuItemView> generateMenuItemViews() {
        ArrayList<MenuItemView> menuItemViews = new ArrayList<MenuItemView>(this.mMenuItems.size());
        for (MenuItem item : this.mMenuItems) {
            MenuItemView menuItemView = new MenuItemView(this.mContext, item);
            menuItemView.setLayoutParams((ViewGroup.LayoutParams)Utils.createWrapParams());
            menuItemViews.add(menuItemView);
        }
        return menuItemViews;
    }

    private View generateRevealCircle() {
        int diameter = this.mFAB.getType() == 0 ? Utils.getDimension(this.mContext, R.dimen.fab_size_normal) : Utils.getDimension(this.mContext, R.dimen.fab_size_mini);
        View view = new View(this.mContext);
        OvalShape ovalShape = new OvalShape();
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)ovalShape);
        shapeDrawable.getPaint().setColor(ContextCompat.getColor((Context)this.mContext, (int)this.mRevealColor));
        view.setBackgroundDrawable((Drawable)shapeDrawable);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(diameter, diameter);
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
        view.setClickable(true);
        view.setVisibility(4);
        return view;
    }

    public void onGlobalLayout() {
        Log.d((String)TAG, (String)"onGlobalLayout");
        if (this.mEnableFollowAnimation) {
            this.applyFollowAnimation();
        }
    }

    private void addOnMenuActionListener(OnMenuActionListener listener) {
        this.mActionListeners.add(listener);
    }

    public void showMenu() {
        Log.d((String)TAG, (String)"showMenu");
        switch (this.mAnimationType) {
            case 0: {
                this.applyBloomOpenAnimation();
                break;
            }
            case 1: {
                this.applyTumblrOpenAniamtion();
            }
        }
        this.hideFollowCircles();
        this.revealIn();
        for (OnMenuActionListener listener : this.mActionListeners) {
            listener.onMenuOpen();
        }
        this.mMenuOpen = !this.mMenuOpen;
    }

    public void hideMenu() {
        Log.d((String)TAG, (String)"hideMenu");
        switch (this.mAnimationType) {
            case 0: {
                this.applyBloomCloseAnimation();
                break;
            }
            case 1: {
                this.applyTumblrCloseAnimation();
            }
        }
        this.showFollowCircles();
        this.revealOut();
        for (OnMenuActionListener listener : this.mActionListeners) {
            listener.onMenuClose();
        }
        this.mMenuOpen = !this.mMenuOpen;
    }

    public boolean isMenuOpen() {
        return this.mMenuOpen;
    }

    private void hideFollowCircles() {
        for (View view : this.mFollowCircles) {
            view.setVisibility(4);
        }
    }

    private void showFollowCircles() {
        for (View view : this.mFollowCircles) {
            view.setVisibility(0);
        }
    }

    private void revealIn() {
        this.mRevealCircle.setVisibility(0);
        this.mRevealCircle.animate().scaleX(100.0f).scaleY(100.0f).setDuration((long)this.mRevealDuration).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                SpringFloatingActionMenu.this.mAnimating = false;
                animation.removeAllListeners();
            }

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                SpringFloatingActionMenu.this.mAnimating = true;
            }
        }).start();
    }

    private void revealOut() {
        this.mRevealCircle.animate().scaleX(1.0f).scaleY(1.0f).setDuration((long)this.mRevealDuration).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                SpringFloatingActionMenu.this.mRevealCircle.setVisibility(4);
                animation.removeAllListeners();
                SpringFloatingActionMenu.this.mAnimating = false;
            }

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                SpringFloatingActionMenu.this.mAnimating = true;
            }
        }).start();
    }

    private void fadeIn() {
        int colorFrom = Color.parseColor((String)"#00000000");
        int colorTo = Color.parseColor((String)"#40000000");
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration(250L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                SpringFloatingActionMenu.this.setBackgroundColor((Integer)animator.getAnimatedValue());
            }
        });
        colorAnimation.start();
    }

    private void fadeOut() {
        int colorFrom = Color.parseColor((String)"#40000000");
        int colorTo = Color.parseColor((String)"#00000000");
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration(250L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                SpringFloatingActionMenu.this.setBackgroundColor((Integer)animator.getAnimatedValue());
            }
        });
        colorAnimation.start();
    }

    private void applyFollowAnimation() {
        SpringSystem springSystem = SpringSystem.create();
        Spring springX = springSystem.createSpring();
        Spring springY = springSystem.createSpring();
        new Actor.Builder(springSystem, (View)this.mFAB).addMotion(springX, 2, 1, new MotionProperty[]{MotionProperty.X}).addMotion(springY, 2, 1, new MotionProperty[]{MotionProperty.Y}).build();
        Spring[] followsX = new Spring[this.mMenuItemCount];
        Spring[] followsY = new Spring[this.mMenuItemCount];
        for (int i = 0; i < this.mFollowCircles.size(); ++i) {
            followsX[i] = springSystem.createSpring();
            followsY[i] = springSystem.createSpring();
            followsX[i].addListener((SpringListener)new Performer((View)this.mFollowCircles.get(i), View.TRANSLATION_X));
            followsY[i].addListener((SpringListener)new Performer((View)this.mFollowCircles.get(i), View.TRANSLATION_Y));
            SpringImitator followX = new SpringImitator(followsX[i]);
            SpringImitator followY = new SpringImitator(followsY[i]);
            if (i == 0) {
                springX.addListener((SpringListener)followX);
                springY.addListener((SpringListener)followY);
                continue;
            }
            followsX[i - 1].addListener((SpringListener)followX);
            followsY[i - 1].addListener((SpringListener)followY);
        }
    }

    private void applyBloomOpenAnimation() {
        SpringSystem springSystem = SpringSystem.create();
        for (int i = 0; i < this.mMenuItemCount; ++i) {
            Spring springX = springSystem.createSpring();
            Spring springY = springSystem.createSpring();
            MenuItemView menuItemView = this.mMenuItemViews.get(i);
            springX.addListener((SpringListener)new MapPerformer((View)menuItemView, View.X, (float)this.mFAB.getLeft(), (float)menuItemView.getLeft()));
            springY.addListener((SpringListener)new MapPerformer((View)menuItemView, View.Y, (float)this.mFAB.getTop(), (float)menuItemView.getTop()));
            DestroySelfSpringListener destroySelfSpringListener = new DestroySelfSpringListener((ViewGroup)this, (View)this.mContainerView, true);
            springX.addListener((SpringListener)destroySelfSpringListener);
            springY.addListener((SpringListener)destroySelfSpringListener);
            springX.setEndValue(1.0);
            springY.setEndValue(1.0);
        }
    }

    private void applyBloomCloseAnimation() {
        SpringSystem springSystem = SpringSystem.create();
        for (int i = 0; i < this.mMenuItemCount; ++i) {
            Spring springX = springSystem.createSpring();
            Spring springY = springSystem.createSpring();
            MenuItemView menuItemView = this.mMenuItemViews.get(i);
            springX.addListener((SpringListener)new MapPerformer((View)menuItemView, View.X, (float)menuItemView.getLeft(), (float)this.mFAB.getLeft()));
            springY.addListener((SpringListener)new MapPerformer((View)menuItemView, View.Y, (float)menuItemView.getTop(), (float)this.mFAB.getTop()));
            DestroySelfSpringListener destroySelfSpringListener = new DestroySelfSpringListener((ViewGroup)this, (View)this.mContainerView, false);
            springX.addListener((SpringListener)destroySelfSpringListener);
            springY.addListener((SpringListener)destroySelfSpringListener);
            springX.setEndValue(1.0);
            springY.setEndValue(1.0);
        }
    }

    private void applyTumblrOpenAniamtion() {
        final View firstItem = (View)this.mMenuItemViews.get(0);
        for (MenuItemView itemView : this.mMenuItemViews) {
            itemView.disableAlphaAnimation();
            itemView.setX(firstItem.getLeft());
            itemView.setY(firstItem.getY());
            itemView.setScaleX(0.0f);
            itemView.setScaleY(0.0f);
        }
        final SpringSystem springSystem = SpringSystem.create();
        Spring springScaleX = springSystem.createSpring();
        Spring springScaleY = springSystem.createSpring();
        springScaleX.addListener((SpringListener)new MapPerformer(firstItem, View.SCALE_X, 0.0f, 1.0f));
        springScaleY.addListener((SpringListener)new MapPerformer(firstItem, View.SCALE_Y, 0.0f, 1.0f));
        DestroySelfSpringListener destroySelfSpringListener = new DestroySelfSpringListener((ViewGroup)this, (View)this.mContainerView, true);
        springScaleX.addListener((SpringListener)destroySelfSpringListener);
        springScaleY.addListener((SpringListener)destroySelfSpringListener);
        springScaleX.setEndValue(1.0);
        springScaleY.setEndValue(1.0);
        for (int i = 1; i < this.mMenuItemCount; ++i) {
            final View menuItemView = (View)this.mMenuItemViews.get(i);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    Spring springScaleX = springSystem.createSpring();
                    Spring springScaleY = springSystem.createSpring();
                    springScaleX.addListener((SpringListener)new MapPerformer(menuItemView, View.SCALE_X, 0.0f, 1.0f));
                    springScaleY.addListener((SpringListener)new MapPerformer(menuItemView, View.SCALE_Y, 0.0f, 1.0f));
                    DestroySelfSpringListener destroySelfSpringListener = new DestroySelfSpringListener((ViewGroup)SpringFloatingActionMenu.this, (View)SpringFloatingActionMenu.this.mContainerView, true);
                    springScaleX.addListener((SpringListener)destroySelfSpringListener);
                    springScaleY.addListener((SpringListener)destroySelfSpringListener);
                    springScaleX.setEndValue(1.0);
                    springScaleY.setEndValue(1.0);
                    Spring springX = springSystem.createSpring();
                    Spring springY = springSystem.createSpring();
                    springX.addListener((SpringListener)new MapPerformer(menuItemView, View.X, (float)firstItem.getLeft(), (float)menuItemView.getLeft()));
                    springY.addListener((SpringListener)new MapPerformer(menuItemView, View.Y, (float)firstItem.getTop(), (float)menuItemView.getTop()));
                    springX.addListener((SpringListener)destroySelfSpringListener);
                    springY.addListener((SpringListener)destroySelfSpringListener);
                    springX.setEndValue(1.0);
                    springY.setEndValue(1.0);
                }
            }, (long)(this.mTumblrTimeInterval * (i - 1)));
        }
    }

    private void applyTumblrCloseAnimation() {
        int alphaDuration = 130;
        final SpringSystem springSystem = SpringSystem.create();
        final View firstItem = (View)this.mMenuItemViews.get(0);
        Spring springScaleX = springSystem.createSpring();
        Spring springScaleY = springSystem.createSpring();
        springScaleX.addListener((SpringListener)new MapPerformer(firstItem, View.SCALE_X, 1.0f, 0.0f));
        springScaleY.addListener((SpringListener)new MapPerformer(firstItem, View.SCALE_Y, 1.0f, 0.0f));
        DestroySelfSpringListener destroySelfSpringListener = new DestroySelfSpringListener((ViewGroup)this, (View)this.mContainerView, false);
        springScaleX.addListener((SpringListener)destroySelfSpringListener);
        springScaleY.addListener((SpringListener)destroySelfSpringListener);
        springScaleX.setEndValue(1.0);
        springScaleY.setEndValue(1.0);
        firstItem.animate().alpha(160.0f);
        for (int i = this.mMenuItemCount - 1; i >= 1; --i) {
            final View menuItemView = (View)this.mMenuItemViews.get(i);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    Spring springScaleX = springSystem.createSpring();
                    Spring springScaleY = springSystem.createSpring();
                    springScaleX.addListener((SpringListener)new MapPerformer(menuItemView, View.SCALE_X, 1.0f, 0.0f));
                    springScaleY.addListener((SpringListener)new MapPerformer(menuItemView, View.SCALE_Y, 1.0f, 0.0f));
                    DestroySelfSpringListener destroySelfSpringListener = new DestroySelfSpringListener((ViewGroup)SpringFloatingActionMenu.this, (View)SpringFloatingActionMenu.this.mContainerView, false);
                    springScaleX.addListener((SpringListener)destroySelfSpringListener);
                    springScaleY.addListener((SpringListener)destroySelfSpringListener);
                    springScaleX.setEndValue(1.0);
                    springScaleY.setEndValue(1.0);
                    Spring springX = springSystem.createSpring();
                    Spring springY = springSystem.createSpring();
                    springX.addListener((SpringListener)new MapPerformer(menuItemView, View.X, (float)menuItemView.getLeft(), (float)firstItem.getLeft()));
                    springY.addListener((SpringListener)new MapPerformer(menuItemView, View.Y, (float)menuItemView.getTop(), (float)firstItem.getTop()));
                    springX.addListener((SpringListener)destroySelfSpringListener);
                    springY.addListener((SpringListener)destroySelfSpringListener);
                    springX.setEndValue(1.0);
                    springY.setEndValue(1.0);
                    menuItemView.animate().alpha(0.0f).setDuration(130L);
                }
            }, (long)(this.mTumblrTimeInterval * (this.mMenuItemCount - i - 1)));
        }
    }

    public FloatingActionButton getFAB() {
        return this.mFAB;
    }

    public static class Builder {
        private Context context;
        private ArrayList<MenuItem> menuItems = new ArrayList();
        private FloatingActionButton fab;
        private int gravity = 85;
        private int animationType = 0;
        private boolean enableFollowAnimation = true;
        @ColorRes
        private int revealColor = 17170458;
        private OnFabClickListener onFabClickListener;
        private ArrayList<OnMenuActionListener> actionListeners = new ArrayList();

        public Builder(Context context) {
            this.context = context;
        }

        public SpringFloatingActionMenu build() {
            return new SpringFloatingActionMenu(this);
        }

        public Builder addMenuItem(@ColorRes int bgColor, int icon, String label, @ColorRes int textColor, View.OnClickListener onClickListener) {
            this.menuItems.add(new MenuItem(bgColor, icon, label, textColor, onClickListener));
            return this;
        }

        public Builder addMenuItem(@ColorRes int bgColor, int icon, String label, @ColorRes int textColor, int diameter, View.OnClickListener onClickListener) {
            this.menuItems.add(new MenuItem(bgColor, icon, label, textColor, diameter, onClickListener));
            return this;
        }

        public Builder fab(FloatingActionButton fab) {
            this.fab = fab;
            return this;
        }

        public Builder gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder onMenuActionListner(OnMenuActionListener listener) {
            this.actionListeners.add(listener);
            return this;
        }

        public Builder animationType(int type) {
            this.animationType = type;
            return this;
        }

        public Builder revealColor(@ColorRes int color2) {
            this.revealColor = color2;
            return this;
        }

        public Builder enableFollowAnimation(boolean enable) {
            this.enableFollowAnimation = enable;
            return this;
        }

        public Builder onFabClickListener(OnFabClickListener listener) {
            this.onFabClickListener = listener;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ANIMATION_TYPE {
    }
}

