/*
 * Decompiled with CFR 0.152.
 */
package com.tiancaicc.springfloatingactionmenu;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.facebook.rebound.Spring;
import com.facebook.rebound.SpringListener;
import com.facebook.rebound.SpringSystem;
import com.facebook.rebound.ui.Util;
import com.tiancaicc.springfloatingactionmenu.MenuItem;
import com.tiancaicc.springfloatingactionmenu.OnMenuActionListener;
import com.tiancaicc.springfloatingactionmenu.Utils;
import com.tumblr.backboard.imitator.ToggleImitator;
import com.tumblr.backboard.performer.MapPerformer;
import com.tumblr.backboard.performer.Performer;

public class MenuItemView
extends LinearLayout
implements OnMenuActionListener {
    private static final String TAG = "MIV";
    private ImageButton mBtn;
    private TextView mLabel;
    private MenuItem mMenuItem;
    private static int mGapSize = 4;
    private static int mTextSize = 14;
    private int mDiameter;
    private boolean mAlphaAnimation = true;

    public MenuItemView(Context context, MenuItem menuItem) {
        super(context);
        this.mMenuItem = menuItem;
        this.init(context);
    }

    private void init(Context context) {
        int diameterPX;
        Resources resources = this.getResources();
        this.mDiameter = diameterPX = Utils.dpToPx(this.mMenuItem.getDiameter(), resources);
        this.mBtn = new ImageButton(context);
        LinearLayout.LayoutParams btnLp = new LinearLayout.LayoutParams(diameterPX, diameterPX);
        btnLp.gravity = 1;
        btnLp.bottomMargin = Util.dpToPx((float)mGapSize, (Resources)resources);
        this.mBtn.setLayoutParams((ViewGroup.LayoutParams)btnLp);
        OvalShape ovalShape = new OvalShape();
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)ovalShape);
        shapeDrawable.getPaint().setColor(resources.getColor(this.mMenuItem.getBgColor()));
        this.mBtn.setBackgroundDrawable((Drawable)shapeDrawable);
        this.mBtn.setImageResource(this.mMenuItem.getIcon());
        this.mBtn.setClickable(false);
        this.addView((View)this.mBtn);
        this.mLabel = new TextView(context);
        LinearLayout.LayoutParams labelLp = new LinearLayout.LayoutParams(-2, -2);
        labelLp.gravity = 1;
        this.mLabel.setLayoutParams((ViewGroup.LayoutParams)labelLp);
        this.mLabel.setText((CharSequence)this.mMenuItem.getLabel());
        this.mLabel.setTextColor(resources.getColor(this.mMenuItem.getTextColor()));
        this.mLabel.setTextSize(2, (float)mTextSize);
        this.addView((View)this.mLabel);
        this.setOrientation(1);
        if (this.mAlphaAnimation) {
            this.setAlpha(0.0f);
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                MenuItemView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                MenuItemView.this.applyPressAnimation();
                ViewGroup parent = (ViewGroup)MenuItemView.this.getParent();
                parent.setClipChildren(false);
                parent.setClipToPadding(false);
                MenuItemView.this.setClipChildren(false);
                MenuItemView.this.setClipToPadding(false);
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(Math.max(this.mBtn.getMeasuredWidth(), this.mLabel.getMeasuredWidth()), this.mBtn.getMeasuredHeight() + this.mLabel.getMeasuredHeight() + Util.dpToPx((float)4.0f, (Resources)this.getResources()));
    }

    private void applyPressAnimation() {
        SpringSystem springSystem = SpringSystem.create();
        Spring spring = springSystem.createSpring();
        spring.addListener((SpringListener)new Performer((View)this.mBtn, View.SCALE_X));
        spring.addListener((SpringListener)new Performer((View)this.mBtn, View.SCALE_Y));
        this.mBtn.setOnTouchListener((View.OnTouchListener)new ToggleImitator(spring, 1.0, 1.2){

            public void imitate(MotionEvent event) {
                super.imitate(event);
                switch (event.getAction()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        MenuItemView.this.callOnClick();
                        break;
                    }
                }
            }
        });
        spring.setCurrentValue(1.0);
    }

    public ImageButton getButton() {
        return this.mBtn;
    }

    public TextView getLabelTextView() {
        return this.mLabel;
    }

    public int getDiameter() {
        return this.mDiameter;
    }

    public void showLabel() {
        SpringSystem springSystem = SpringSystem.create();
        final Spring spring = springSystem.createSpring();
        spring.addListener((SpringListener)new MapPerformer((View)this.mLabel, View.SCALE_X, 0.0f, 1.0f));
        spring.addListener((SpringListener)new MapPerformer((View)this.mLabel, View.SCALE_Y, 0.0f, 1.0f));
        spring.setCurrentValue(0.0);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                spring.setEndValue(1.0);
            }
        }, 200L);
    }

    public void disableAlphaAnimation() {
        this.mAlphaAnimation = false;
        this.setAlpha(1.0f);
    }

    @Override
    public void onMenuOpen() {
        this.showLabel();
        if (this.mAlphaAnimation) {
            this.animate().alpha(1.0f).setDuration(120L);
        }
    }

    @Override
    public void onMenuClose() {
        if (this.mAlphaAnimation) {
            this.animate().alpha(0.0f).setDuration(120L);
        }
    }
}

