/*
 * Decompiled with CFR 0.152.
 */
package com.thycotic.jenkins.configuration;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.thycotic.jenkins.credentials.ThycoticVaultCredentials;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DevOpsSecretsVaultConfiguration
extends AbstractDescribableImpl<DevOpsSecretsVaultConfiguration>
implements Serializable {
    private String thycoticCredentialId;

    public DevOpsSecretsVaultConfiguration() {
    }

    @DataBoundConstructor
    public DevOpsSecretsVaultConfiguration(String thycoticCredentialId) {
        this.thycoticCredentialId = thycoticCredentialId;
    }

    public String getThycoticCredentialId() {
        return this.thycoticCredentialId;
    }

    @DataBoundSetter
    public void setThycoticCredentialId(String thycoticCredentialId) {
        this.thycoticCredentialId = thycoticCredentialId;
    }

    public DevOpsSecretsVaultConfiguration mergeWithParent(DevOpsSecretsVaultConfiguration parent) {
        if (parent == null) {
            return this;
        }
        DevOpsSecretsVaultConfiguration result = new DevOpsSecretsVaultConfiguration(this.getThycoticCredentialId());
        if (StringUtils.isBlank((String)result.getThycoticCredentialId())) {
            result.setThycoticCredentialId(parent.getThycoticCredentialId());
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DevOpsSecretsVaultConfiguration> {
        public String getDisplayName() {
            return "Thycotic DevOps Secrets Vault Configuration";
        }

        public ListBoxModel doFillThycoticCredentialIdItems(@AncestorInPath Item item, @QueryParameter String uri) {
            List domainRequirements = URIRequirementBuilder.fromUri((String)uri).build();
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, item, ThycoticVaultCredentials.class, domainRequirements);
        }
    }
}

