/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.collect.Lists;
import com.threerings.util.MessageBundle;
import java.util.ArrayList;

public class TimeUtil {
    public static final byte MILLISECOND = 0;
    public static final byte SECOND = 1;
    public static final byte MINUTE = 2;
    public static final byte HOUR = 3;
    public static final byte DAY = 4;
    protected static final byte MAX_UNIT = 4;

    public static int elapsedSeconds(long startStamp, long endStamp) {
        if (endStamp < startStamp) {
            throw new IllegalArgumentException("End time must be after start time [start=" + startStamp + ", end=" + endStamp + "]");
        }
        return (int)((endStamp - startStamp) / 1000L);
    }

    public static String getTimeOrderString(long duration, byte minUnit) {
        return TimeUtil.getTimeOrderString(duration, minUnit, (byte)4);
    }

    public static String getTimeOrderString(long duration, byte minUnit, byte maxUnit) {
        minUnit = (byte)Math.min(minUnit, maxUnit);
        maxUnit = (byte)Math.min(maxUnit, 4);
        for (byte uu = 0; uu <= 4; uu = (byte)(uu + 1)) {
            int quantity = TimeUtil.getQuantityPerUnit(uu);
            if (minUnit <= uu && (duration < (long)quantity || maxUnit == uu)) {
                duration = Math.max(1L, duration);
                return MessageBundle.tcompose(TimeUtil.getTransKey(uu), (Object)String.valueOf(duration));
            }
            duration = Math.round(duration / (long)quantity);
        }
        Thread.dumpStack();
        return null;
    }

    public static String getTimeString(long duration, byte minUnit) {
        return TimeUtil.getTimeString(duration, minUnit, false);
    }

    public static String getTimeString(long duration, byte minUnit, boolean roundUp) {
        byte uu;
        minUnit = (byte)Math.min(minUnit, 4);
        duration = Math.abs(duration);
        if (roundUp) {
            long quantity = 1L;
            for (uu = 0; uu < 3; uu = (byte)(uu + 1)) {
                quantity *= (long)TimeUtil.getQuantityPerUnit(uu);
            }
            if (duration % quantity > 0L) {
                duration += quantity;
            }
        }
        ArrayList list = Lists.newArrayList();
        int parts = 0;
        for (uu = 0; uu <= 4; uu = (byte)(uu + 1)) {
            long amt;
            int quantity = TimeUtil.getQuantityPerUnit(uu);
            if (minUnit <= uu && (amt = duration % (long)quantity) != 0L) {
                list.add(MessageBundle.tcompose(TimeUtil.getTransKey(uu), (Object)String.valueOf(amt)));
                ++parts;
            }
            if ((duration /= (long)quantity) <= 0L && parts > 0) break;
        }
        if (parts == 0) {
            return MessageBundle.tcompose(TimeUtil.getTransKey(minUnit), (Object)0);
        }
        if (parts == 1) {
            return (String)list.get(0);
        }
        return MessageBundle.compose("m.times_" + parts, list.toArray());
    }

    protected static int getQuantityPerUnit(byte unit) {
        switch (unit) {
            case 0: {
                return 1000;
            }
            case 1: 
            case 2: {
                return 60;
            }
            case 3: {
                return 24;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        return -1;
    }

    protected static String getTransKey(byte unit) {
        switch (unit) {
            case 0: {
                return "m.millisecond";
            }
            case 1: {
                return "m.second";
            }
            case 2: {
                return "m.minute";
            }
            case 3: {
                return "m.hour";
            }
            case 4: {
                return "m.day";
            }
        }
        return null;
    }
}

