/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.net;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.net.DownloadAbortedException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class Downloader
extends Thread {
    protected Collection<Resource> _resources;
    protected Map<Resource, Long> _sizes = new HashMap<Resource, Long>();
    protected Map<Resource, Long> _downloaded = new HashMap<Resource, Long>();
    protected Observer _obs;
    protected byte[] _buffer = new byte[4096];
    protected long _start;
    protected long _bytesPerSecond;
    protected long _lastUpdate;
    protected boolean _complete;
    protected static final long UPDATE_DELAY = 500L;

    public Downloader(Collection<Resource> collection, Observer observer) {
        super("Downloader");
        this._resources = collection;
        this._obs = observer;
    }

    @Override
    public void run() {
        this.download();
    }

    public boolean download() {
        try {
            if (this._obs != null) {
                this._obs.resolvingDownloads();
            }
            for (Resource resource : this._resources) {
                this.discoverSize(resource);
            }
            long l2 = Downloader.sum(this._sizes.values());
            Log.log.info("Downloading " + l2 + " bytes...", new Object[0]);
            this._start = System.currentTimeMillis();
            for (Resource resource : this._resources) {
                this.download(resource);
            }
            if (this._obs != null && !this._complete && !this._obs.downloadProgress(100, 0L)) {
                return false;
            }
        }
        catch (DownloadAbortedException downloadAbortedException) {
            return false;
        }
        catch (Exception exception) {
            if (this._obs != null) {
                this._obs.downloadFailed(null, exception);
            }
            Log.log.warning("Observer failed.", exception);
        }
        return true;
    }

    protected void discoverSize(Resource resource) throws IOException {
        this._sizes.put(resource, Math.max(this.checkSize(resource), 0L));
    }

    protected abstract long checkSize(Resource var1) throws IOException;

    protected void download(Resource resource) throws IOException {
        File file = new File(resource.getLocal().getParent());
        if (!file.exists() && !file.mkdirs()) {
            Log.log.warning("Failed to create target directory for resource '" + resource + "'. Download will certainly fail.", new Object[0]);
        }
        this.doDownload(resource);
    }

    protected void updateObserver(Resource resource, long l2, long l3) throws IOException {
        l3 = Math.max(l3, this._sizes.get(resource));
        this._sizes.put(resource, l3);
        this._downloaded.put(resource, Math.min(l3, l2));
        long l4 = System.currentTimeMillis();
        if (l4 - this._lastUpdate >= 500L) {
            long l5;
            this._lastUpdate = l4;
            long l6 = Downloader.sum(this._downloaded.values());
            long l7 = Downloader.sum(this._sizes.values());
            long l8 = (l4 - this._start) / 1000L;
            long l9 = l8 == 0L ? 0L : l6 / l8;
            int n2 = l7 == 0L ? 0 : (int)((float)l6 * 100.0f / (float)l7);
            long l10 = l5 = l9 <= 0L || l7 == 0L ? -1L : (l7 - l6) / l9;
            if (n2 < 100 || !this._complete) {
                boolean bl = this._complete = n2 == 100;
                if (!this._obs.downloadProgress(n2, l5)) {
                    throw new DownloadAbortedException();
                }
            }
        }
    }

    protected static long sum(Iterable<Long> object) {
        long l2 = 0L;
        object = object.iterator();
        while (object.hasNext()) {
            Long l3 = (Long)object.next();
            l2 += l3.longValue();
        }
        return l2;
    }

    protected abstract void doDownload(Resource var1) throws IOException;

    public static interface Observer {
        public void resolvingDownloads();

        public boolean downloadProgress(int var1, long var2);

        public void downloadFailed(Resource var1, Exception var2);
    }
}

