/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Build;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.launcher.AbortPanel;
import com.threerings.getdown.launcher.MultipleGetdownRunning;
import com.threerings.getdown.launcher.ProxyPanel;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import com.threerings.getdown.launcher.StatusPanel;
import com.threerings.getdown.launcher.a;
import com.threerings.getdown.launcher.b;
import com.threerings.getdown.launcher.c;
import com.threerings.getdown.launcher.d;
import com.threerings.getdown.launcher.f;
import com.threerings.getdown.launcher.g;
import com.threerings.getdown.net.Downloader;
import com.threerings.getdown.net.HTTPDownloader;
import com.threerings.getdown.tools.Patcher;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.ConnectionUtil;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.ProgressAggregator;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StringUtil;
import com.threerings.getdown.util.VersionUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JLayeredPane;

public abstract class Getdown
extends Thread
implements Application.StatusDisplay,
RotatingBackgrounds.ImageLoader {
    protected ProgressObserver _progobs = new g(this);
    protected Application _app;
    protected Application.UpdateInterface _ifc = new Application.UpdateInterface(Config.EMPTY);
    protected ResourceBundle _msgs;
    protected Container _container;
    protected JLayeredPane _layers;
    protected StatusPanel _status;
    protected JButton _patchNotes;
    protected AbortPanel _abort;
    protected RotatingBackgrounds _background;
    protected boolean _dead;
    protected boolean _silent;
    protected boolean _launchInSilent;
    protected long _startup;
    protected Set<Resource> _toInstallResources;
    protected boolean _readyToInstall;
    protected boolean _enableTracking = true;
    protected int _reportedProgress = 0;
    protected int _delay;
    protected int _stepMaxPercent;
    protected int _stepMinPercent;
    protected int _lastGlobalPercent;
    protected int _uiDisplayPercent;
    protected static final int MAX_LOOPS = 5;
    protected static final long FALLBACK_CHECK_TIME = 1000L;
    protected static final String PROXY_REGISTRY = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";

    public Getdown(EnvConfig envConfig) {
        super("Getdown");
        try {
            this._silent = SysProps.silent();
            if (this._silent) {
                this._launchInSilent = SysProps.launchInSilent();
            }
            this._delay = SysProps.startDelay();
        }
        catch (SecurityException securityException) {}
        try {
            this._msgs = ResourceBundle.getBundle("com.threerings.getdown.messages");
        }
        catch (Exception exception) {
            String string = envConfig.appDir.toString();
            if (string.equals(".")) {
                string = System.getProperty("user.dir");
            }
            String string2 = "The directory in which this application is installed:\n" + string + "\nis invalid (" + exception.getMessage() + "). If the full path to the app directory contains the '!' character, this will trigger this error.";
            this.fail(string2);
        }
        this._app = new Application(envConfig);
        this._startup = System.currentTimeMillis();
    }

    public boolean isUpdateAvailable() {
        return this._readyToInstall && !this._toInstallResources.isEmpty();
    }

    public void install() throws IOException {
        if (SysProps.noInstall()) {
            Log.log.info("Skipping install due to 'no_install' sysprop.", new Object[0]);
            return;
        }
        if (this._readyToInstall) {
            Log.log.info("Installing " + this._toInstallResources.size() + " downloaded resources:", new Object[0]);
            for (Resource resource : this._toInstallResources) {
                resource.install();
            }
            this._toInstallResources.clear();
            this._readyToInstall = false;
            Log.log.info("Install completed.", new Object[0]);
            return;
        }
        Log.log.info("Nothing to install.", new Object[0]);
    }

    @Override
    public void run() {
        block10: {
            if (this._msgs == null) {
                return;
            }
            Log.log.info("Getdown starting", "version", Build.version(), "built", Build.time());
            Object object = this._app.getLocalPath("");
            if (!((File)object).canWrite()) {
                if (((String)(object = ((File)object).getPath())).equals(".")) {
                    object = System.getProperty("user.dir");
                }
                this.fail(MessageUtil.tcompose("m.readonly_error", new String[]{object}));
                return;
            }
            try {
                this._dead = false;
                if (this.detectProxy() || this._app.allowOffline()) {
                    this.getdown();
                    break block10;
                }
                if (this._silent) {
                    Log.log.warning("Need a proxy, but we don't want to bother anyone.  Exiting.", new Object[0]);
                    break block10;
                }
                this._container = this.createContainer();
                Getdown getdown = this;
                this._container.add((Component)new ProxyPanel(getdown, getdown._msgs), "Center");
                this.showContainer();
                this._dead = true;
                return;
            }
            catch (Exception exception) {
                Log.log.warning("run() failed.", exception);
                String string = exception.getMessage();
                if (string == null) {
                    string = MessageUtil.compose("m.unknown_error", this._ifc.installError);
                } else if (!string.startsWith("m.")) {
                    string = exception instanceof FileNotFoundException ? MessageUtil.compose("m.missing_resource", MessageUtil.taint(string), this._ifc.installError) : MessageUtil.compose("m.init_error", MessageUtil.taint(string), this._ifc.installError);
                }
                this.fail(string);
            }
        }
    }

    public void configureProxy(String string, String string2) {
        Log.log.info("User configured proxy", "host", string, "port", string2);
        if (!StringUtil.isBlank(string)) {
            File file = this._app.getLocalPath("proxy.txt");
            try {
                PrintStream printStream = new PrintStream(new FileOutputStream(file));
                Throwable throwable = null;
                try {
                    printStream.println("host = " + string);
                    if (!StringUtil.isBlank(string2)) {
                        printStream.println("port = " + string2);
                    }
                    printStream.close();
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable != null) {
                            try {
                                printStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            printStream.close();
                        }
                        throw throwable4;
                    }
                }
            }
            catch (IOException iOException) {
                Log.log.warning("Error creating proxy file '" + file + "': " + iOException, new Object[0]);
            }
            this.setProxyProperties(string, string2);
        }
        this.disposeContainer();
        this._container = null;
        new Thread(this).start();
    }

    protected boolean detectProxy() {
        Object object;
        Object object2;
        Object object3;
        if (System.getProperty("http.proxyHost") != null) {
            return true;
        }
        if (LaunchUtil.isWindows()) {
            try {
                object3 = null;
                object2 = null;
                boolean bl = false;
                RegistryKey.initialize();
                object = new RegistryKey(RootKey.HKEY_CURRENT_USER, PROXY_REGISTRY);
                object = ((RegistryKey)object).values();
                while (object.hasNext()) {
                    RegistryValue registryValue = (RegistryValue)object.next();
                    if (registryValue.getName().equals("ProxyEnable")) {
                        bl = registryValue.getStringValue().equals("1");
                    }
                    if (!registryValue.getName().equals("ProxyServer")) continue;
                    object3 = registryValue.getStringValue();
                    int n2 = ((String)object3).indexOf(":");
                    if (n2 == -1) continue;
                    object2 = ((String)object3).substring(n2 + 1);
                    object3 = ((String)object3).substring(0, n2);
                }
                if (bl) {
                    this.setProxyProperties((String)object3, (String)object2);
                    return true;
                }
                Log.log.info("Detected no proxy settings in the registry.", new Object[0]);
            }
            catch (Throwable throwable) {
                Log.log.info("Failed to find proxy settings in Windows registry", "error", throwable);
            }
        }
        if (((File)(object3 = this._app.getLocalPath("proxy.txt"))).exists()) {
            try {
                object2 = Config.parseConfig((File)object3, Config.createOpts(false));
                this.setProxyProperties(((Config)object2).getString("host"), ((Config)object2).getString("port"));
                return true;
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to read '" + object3 + "': " + iOException, new Object[0]);
            }
        }
        Log.log.info("Checking whether we need to use a proxy...", new Object[0]);
        try {
            this._ifc = this._app.init(true);
        }
        catch (IOException iOException) {}
        this.updateStatus("m.detecting_proxy");
        object2 = this._app.getConfigResource().getRemote();
        try {
            URLConnection uRLConnection = ConnectionUtil.open((URL)object2, 5, 5);
            if (uRLConnection instanceof HttpURLConnection) {
                object = (HttpURLConnection)uRLConnection;
                try {
                    ((HttpURLConnection)object).setRequestMethod("HEAD");
                    ((URLConnection)object).connect();
                    if (((HttpURLConnection)object).getResponseCode() != 200) {
                        Log.log.warning("Got a non-200 response but assuming we're OK because we got something...", "url", object2, "rsp", ((HttpURLConnection)object).getResponseCode());
                    }
                }
                finally {
                    ((HttpURLConnection)object).disconnect();
                }
            }
            Log.log.info("No proxy appears to be needed.", new Object[0]);
            try {
                ((File)object3).createNewFile();
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to create blank proxy file '" + object3 + "': " + iOException, new Object[0]);
            }
            return true;
        }
        catch (IOException iOException) {
            Log.log.info("Failed to HEAD " + object2 + ": " + iOException, new Object[0]);
            Log.log.info("We probably need a proxy, but auto-detection failed.", new Object[0]);
            return false;
        }
    }

    protected void setProxyProperties(String string, String string2) {
        if (!StringUtil.isBlank(string)) {
            System.setProperty("http.proxyHost", string);
            System.setProperty("https.proxyHost", string);
            if (!StringUtil.isBlank(string2)) {
                System.setProperty("http.proxyPort", string2);
                System.setProperty("https.proxyPort", string2);
            }
            Log.log.info("Using proxy", "host", string, "port", string2);
        }
    }

    protected void getdown() {
        Log.log.info("---------------- Proxy Info -----------------", new Object[0]);
        Log.log.info("-- Proxy Host: " + System.getProperty("http.proxyHost"), new Object[0]);
        Log.log.info("-- Proxy Port: " + System.getProperty("http.proxyPort"), new Object[0]);
        Log.log.info("---------------------------------------------", new Object[0]);
        try {
            try {
                this._ifc = this._app.init(true);
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to initialize: " + iOException, new Object[0]);
                this._app.attemptRecovery(this);
                this._ifc = this._app.init(true);
                this.createInterfaceAsync(true);
            }
            if (!this._app.lockForUpdates()) {
                throw new MultipleGetdownRunning();
            }
            File file = this._app.getLocalPath("getdown.txt");
            if (!file.setLastModified(System.currentTimeMillis())) {
                Log.log.warning("Unable to set modtime on config file, will be unable to check for another instance of getdown running while this one waits.", new Object[0]);
            }
            if (this._delay > 0) {
                this._app.releaseLock();
                long l2 = file.lastModified();
                Log.log.info("Waiting " + this._delay + " minutes before beginning actual work.", new Object[0]);
                Thread.sleep(this._delay * 60 * 1000);
                if (l2 < file.lastModified()) {
                    Log.log.warning("getdown.txt was modified while getdown was waiting.", new Object[0]);
                    throw new MultipleGetdownRunning();
                }
            }
            int[] nArray = new int[1];
            HashSet<Resource> hashSet = new HashSet<Resource>();
            this._toInstallResources = new HashSet<Resource>();
            this._readyToInstall = false;
            for (int i2 = 0; i2 < 5; ++i2) {
                if (!this._app.haveValidJavaVersion()) {
                    Log.log.info("Attempting to update Java VM...", new Object[0]);
                    this.setStep(Application.UpdateInterface.Step.UPDATE_JAVA);
                    this._enableTracking = true;
                    try {
                        this.updateJava();
                        continue;
                    }
                    finally {
                        this._enableTracking = false;
                    }
                }
                this.setStep(Application.UpdateInterface.Step.VERIFY_METADATA);
                this.setStatusAsync("m.validating", -1, -1L, false);
                if (this._app.verifyMetadata(this)) {
                    Log.log.info("Application requires update.", new Object[0]);
                    this.update();
                    continue;
                }
                this.setStep(Application.UpdateInterface.Step.VERIFY_RESOURCES);
                this.setStatusAsync("m.validating", -1, -1L, false);
                HashSet<Resource> hashSet2 = new HashSet<Resource>();
                this._app.verifyResources(this._progobs, nArray, hashSet, this._toInstallResources, hashSet2);
                if (hashSet2.size() > 0) {
                    for (Resource resource : hashSet2) {
                        if (this._toInstallResources.contains(resource)) continue;
                        this._toInstallResources.add(resource);
                    }
                    try {
                        this._enableTracking = nArray[0] == 0;
                        this.reportTrackingEvent("app_start", -1);
                        Log.log.info(hashSet2.size() + " of " + this._app.getAllActiveResources().size() + " rsrcs require update (" + nArray[0] + " assumed valid).", new Object[0]);
                        this.setStep(Application.UpdateInterface.Step.REDOWNLOAD_RESOURCES);
                        this.download(hashSet2);
                        this.reportTrackingEvent("app_complete", -1);
                        continue;
                    }
                    finally {
                        this._enableTracking = false;
                    }
                }
                if (Boolean.getBoolean("check_unpacked")) {
                    File file2 = this._app.getLocalPath("unpacked.dat");
                    long l3 = -1L;
                    long l4 = this._app.getVersion();
                    if (!file2.exists()) {
                        file2.createNewFile();
                    } else {
                        l3 = VersionUtil.readVersion(file2);
                    }
                    if (l3 < l4) {
                        Log.log.info("Performing unpack", "version", l3, "aversion", l4);
                        this.setStep(Application.UpdateInterface.Step.UNPACK);
                        this.updateStatus("m.validating");
                        this._app.unpackResources(this._progobs, hashSet);
                        try {
                            VersionUtil.writeVersion(file2, l4);
                        }
                        catch (IOException iOException) {
                            Log.log.warning("Failed to update unpacked version", iOException);
                        }
                    }
                }
                this._readyToInstall = true;
                this.install();
                if (!this._silent || this._launchInSilent) {
                    this._app.lockForUpdates();
                    this.launch();
                }
                return;
            }
            Log.log.warning("Pants! We couldn't get the job done.", new Object[0]);
            throw new IOException("m.unable_to_repair");
        }
        catch (Exception exception) {
            Log.log.warning("getdown() failed.", exception);
            String string = exception.getMessage();
            if (string == null) {
                string = MessageUtil.compose("m.unknown_error", this._ifc.installError);
            } else if (!string.startsWith("m.")) {
                string = exception instanceof FileNotFoundException ? MessageUtil.compose("m.missing_resource", MessageUtil.taint(string), this._ifc.installError) : MessageUtil.compose("m.init_error", MessageUtil.taint(string), this._ifc.installError);
            }
            this.fail(string);
            this._app.releaseLock();
            return;
        }
    }

    @Override
    public void updateStatus(String string) {
        this.setStatusAsync(string, -1, -1L, true);
    }

    @Override
    public BufferedImage loadImage(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        File file = null;
        try {
            String string2 = Locale.getDefault().getLanguage();
            file = this._app.getLocalPath(string.replace(".", "_" + string2 + "."));
            return ImageIO.read(file);
        }
        catch (IOException iOException) {
            try {
                file = this._app.getLocalPath(string);
                return ImageIO.read(file);
            }
            catch (IOException iOException2) {
                Log.log.warning("Failed to load image", "path", file, "error", iOException2);
                return null;
            }
        }
    }

    protected void updateJava() throws IOException {
        Object object = this._app.getJavaVMResource();
        if (object == null) {
            throw new IOException("m.java_download_failed");
        }
        this.reportTrackingEvent("jvm_start", -1);
        this.updateStatus("m.downloading_java");
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.add((Resource)object);
        this.download(arrayList);
        this.reportTrackingEvent("jvm_unpack", -1);
        this.updateStatus("m.unpacking_java");
        ((Resource)object).install();
        object = "java_vm/";
        FileUtil.makeExecutable(this._app.getLocalPath((String)object + "bin/java"));
        FileUtil.makeExecutable(this._app.getLocalPath((String)object + "lib/jspawnhelper"));
        FileUtil.makeExecutable(this._app.getLocalPath((String)object + "lib/amd64/jspawnhelper"));
        object = LaunchUtil.getJVMPath(this._app.getLocalPath(""));
        try {
            Log.log.info("Regenerating classes.jsa for " + (String)object + "...", new Object[0]);
            Runtime.getRuntime().exec((String)object + " -Xshare:dump");
        }
        catch (Exception exception) {
            Log.log.warning("Failed to regenerate .jsa dump file", "error", exception);
        }
        this.reportTrackingEvent("jvm_complete", -1);
    }

    protected void update() throws IOException {
        this._app.clearValidationMarkers();
        Resource object3 = this._app.getPatchResource(null);
        if (object3 != null) {
            Object object = new ArrayList<Resource>();
            object.add(object3);
            for (Application.AuxGroup auxGroup : this._app.getAuxGroups()) {
                Resource resource;
                if (!this._app.isAuxGroupActive(auxGroup.name) || (resource = this._app.getPatchResource(auxGroup.name)) == null) continue;
                object.add((Resource)resource);
            }
            if (!StringUtil.isBlank(this._ifc.patchNotesUrl)) {
                this.createInterfaceAsync(false);
                EventQueue.invokeLater(new a(this));
            }
            this.setStep(Application.UpdateInterface.Step.DOWNLOAD);
            this.download((Collection<Resource>)object);
            this.setStep(Application.UpdateInterface.Step.PATCH);
            this.updateStatus("m.patching");
            long[] lArray = new long[object.size()];
            Object object2 = lArray;
            Arrays.fill(lArray, 1L);
            ProgressAggregator progressAggregator = new ProgressAggregator(this._progobs, (long[])object2);
            int n2 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Resource resource = (Resource)object.next();
                ProgressObserver progressObserver = progressAggregator.startElement(n2++);
                try {
                    Patcher patcher = new Patcher();
                    patcher.patch(resource.getLocal().getParentFile(), resource.getLocal(), progressObserver);
                }
                catch (Exception exception) {
                    Log.log.warning("Failed to apply patch", "prsrc", resource, exception);
                }
                if (FileUtil.deleteHarder(resource.getLocal())) continue;
                Log.log.warning("Failed to delete '" + resource + "'.", new Object[0]);
            }
        }
        this._app.updateMetadata();
        this._ifc = this._app.init(true);
    }

    protected void download(Collection<Resource> object) throws IOException {
        this.createInterfaceAsync(false);
        b b2 = new b(this);
        object = new HTTPDownloader((Collection<Resource>)object, b2);
        if (!((Downloader)object).download()) {
            throw new MultipleGetdownRunning();
        }
    }

    protected void launch() {
        this.setStep(Application.UpdateInterface.Step.LAUNCH);
        this.setStatusAsync("m.launching", this.stepToGlobalPercent(100), -1L, false);
        try {
            if (this.invokeDirect()) {
                this.disposeContainer();
                this._app.releaseLock();
                this._app.invokeDirect();
            } else {
                Process process;
                if (this._app.hasOptimumJvmArgs()) {
                    process = this._app.createProcess(true);
                    long l2 = System.currentTimeMillis() + 1000L;
                    boolean bl = false;
                    while (l2 > System.currentTimeMillis()) {
                        try {
                            bl = process.exitValue() != 0;
                            break;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            Thread.yield();
                        }
                    }
                    if (bl) {
                        Log.log.info("Failed to launch with optimum arguments; falling back.", new Object[0]);
                        process = this._app.createProcess(false);
                    }
                } else {
                    process = this._app.createProcess(false);
                }
                process.getInputStream().close();
                process.getOutputStream().close();
                InputStream inputStream = process.getErrorStream();
                if (LaunchUtil.mustMonitorChildren()) {
                    this.disposeContainer();
                    this._container = null;
                    Getdown.copyStream(inputStream, System.err);
                    Log.log.info("Process exited: " + process.waitFor(), new Object[0]);
                } else {
                    c c2 = new c(this, inputStream);
                    c2.setDaemon(true);
                    c2.start();
                }
            }
            long l3 = System.currentTimeMillis() - this._startup;
            long l4 = (long)this._ifc.minShowSeconds * 1000L;
            if (this._container != null && l3 < l4) {
                try {
                    Thread.sleep(l4 - l3);
                }
                catch (Exception exception) {}
            }
            this.setStatusAsync(null, 100, -1L, false);
            this.exit(0);
            return;
        }
        catch (Exception exception) {
            Log.log.warning("launch() failed.", exception);
            return;
        }
    }

    protected void createInterfaceAsync(boolean bl) {
        if (this._silent || this._container != null && !bl) {
            return;
        }
        EventQueue.invokeLater(new d(this, bl));
    }

    protected void initInterface() {
        Object object = this.getBackground();
        if (this._background == null || ((RotatingBackgrounds)object).getNumImages() > 0) {
            this._background = object;
        }
        this._status.init(this._ifc, this._background, this.getProgressImage());
        object = this._status.getPreferredSize();
        this._status.setSize((Dimension)object);
        this._layers.setPreferredSize((Dimension)object);
        this._patchNotes.setBounds(this._ifc.patchNotes.x, this._ifc.patchNotes.y, this._ifc.patchNotes.width, this._ifc.patchNotes.height);
        this._patchNotes.setVisible(false);
        this._uiDisplayPercent = this._lastGlobalPercent;
        Getdown getdown = this;
        getdown._lastGlobalPercent = 0;
        getdown._stepMinPercent = 0;
    }

    protected RotatingBackgrounds getBackground() {
        if (this._ifc.rotatingBackgrounds != null) {
            if (this._ifc.backgroundImage != null) {
                Log.log.warning("ui.background_image and ui.rotating_background were both specified. The rotating images are being used.", new Object[0]);
            }
            return new RotatingBackgrounds(this._ifc.rotatingBackgrounds, this._ifc.errorBackground, this);
        }
        if (this._ifc.backgroundImage != null) {
            Getdown getdown = this;
            return new RotatingBackgrounds(getdown.loadImage(getdown._ifc.backgroundImage));
        }
        return new RotatingBackgrounds();
    }

    protected Image getProgressImage() {
        Getdown getdown = this;
        return getdown.loadImage(getdown._ifc.progressImage);
    }

    protected void handleWindowClose() {
        if (this._dead) {
            this.exit(0);
            return;
        }
        if (this._abort == null) {
            Getdown getdown = this;
            this._abort = new AbortPanel(getdown, getdown._msgs);
        }
        this._abort.pack();
        com.a.a.a.a.a(this._abort);
        this._abort.setVisible(true);
        this._abort.setState(0);
        this._abort.requestFocus();
    }

    protected void fail(String string) {
        this._dead = true;
        this.setStatusAsync(string, this.stepToGlobalPercent(0), -1L, true);
    }

    protected void setStep(Application.UpdateInterface.Step object) {
        int n2 = -1;
        for (Integer n3 : this._ifc.stepPercentages.get(object)) {
            if (n3 <= this._stepMaxPercent) continue;
            n2 = n3;
            break;
        }
        if (n2 == -1) {
            return;
        }
        this._stepMaxPercent = n2;
        this._stepMinPercent = this._lastGlobalPercent;
    }

    protected int stepToGlobalPercent(int n2) {
        int n3 = (this._stepMaxPercent - this._uiDisplayPercent) * 100 / (100 - this._uiDisplayPercent);
        this._lastGlobalPercent = Math.max(this._lastGlobalPercent, this._stepMinPercent + n2 * (n3 - this._stepMinPercent) / 100);
        return this._lastGlobalPercent;
    }

    protected void setStatusAsync(String string, int n2, long l2, boolean bl) {
        if (this._status == null && bl) {
            this.createInterfaceAsync(false);
        }
        EventQueue.invokeLater(new f(this, string, n2, l2));
    }

    protected void reportTrackingEvent(String object, int n2) {
        if (!this._enableTracking) {
            return;
        }
        if (n2 > 0) {
            do {
                if ((object = this._app.getTrackingProgressURL(++this._reportedProgress)) == null) continue;
                new ProgressReporter((URL)object).start();
            } while (this._reportedProgress <= n2);
            return;
        }
        if ((object = this._app.getTrackingURL((String)object)) != null) {
            new ProgressReporter((URL)object).start();
        }
    }

    protected abstract Container createContainer();

    protected abstract void showContainer();

    protected abstract void disposeContainer();

    protected boolean invokeDirect() {
        return SysProps.direct();
    }

    protected abstract void showDocument(String var1);

    protected abstract void exit(int var1);

    protected static void copyStream(InputStream inputStream, PrintStream printStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                printStream.print(string);
                printStream.flush();
            }
            return;
        }
        catch (IOException iOException) {
            Log.log.warning("Failure copying", "in", inputStream, "out", printStream, "error", iOException);
            return;
        }
    }

    protected class ProgressReporter
    extends Thread {
        protected URL _url;

        public ProgressReporter(URL uRL) {
            this.setDaemon(true);
            this._url = uRL;
        }

        @Override
        public void run() {
            try {
                String string;
                HttpURLConnection httpURLConnection = ConnectionUtil.openHttp(this._url, 0, 0);
                if (Getdown.this._app.getTrackingCookieName() != null && Getdown.this._app.getTrackingCookieProperty() != null && (string = System.getProperty(Getdown.this._app.getTrackingCookieProperty())) != null) {
                    httpURLConnection.setRequestProperty("Cookie", Getdown.this._app.getTrackingCookieName() + "=" + string);
                }
                httpURLConnection.connect();
                try {
                    if (httpURLConnection.getResponseCode() != 200) {
                        Log.log.warning("Failed to report tracking event", "url", this._url, "rcode", httpURLConnection.getResponseCode());
                    }
                }
                finally {
                    httpURLConnection.disconnect();
                }
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to report tracking event", "url", this._url, "error", iOException);
            }
        }
    }
}

