/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class EnvConfig {
    public final File appDir;
    public final String appId;
    public final String appBase;
    public final List<Certificate> certs;
    public final List<String> appArgs;
    private static final String USER_HOME_KEY = "${user.home}";

    public static EnvConfig create(String[] object, List<Note> list) {
        Object object2;
        Object object3;
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        Object object7 = null;
        Object object8 = null;
        Object object9 = null;
        try {
            object3 = ResourceBundle.getBundle("bootstrap");
            if (((ResourceBundle)object3).containsKey("appdir")) {
                object4 = ((ResourceBundle)object3).getString("appdir");
                object2 = new File((String)(object4 = ((String)object4).replace(USER_HOME_KEY, System.getProperty("user.home"))));
                if (!((File)object2).exists()) {
                    ((File)object2).mkdirs();
                }
                object5 = "bootstrap.properties";
            }
            if (((ResourceBundle)object3).containsKey("appid")) {
                object6 = ((ResourceBundle)object3).getString("appid");
                object7 = "bootstrap.properties";
            }
            if (((ResourceBundle)object3).containsKey("appbase")) {
                object8 = ((ResourceBundle)object3).getString("appbase");
                object9 = "bootstrap.properties";
            }
        }
        catch (MissingResourceException missingResourceException) {}
        object3 = SysProps.appDir();
        if (!StringUtil.isBlank((String)object3)) {
            if (object4 == null) {
                object4 = object3;
                object5 = "system property";
            } else {
                list.add(Note.warn("Ignoring 'appdir' system property, have appdir via '" + (String)object5 + "'"));
            }
        }
        if (!StringUtil.isBlank((String)(object2 = SysProps.appId()))) {
            if (object6 == null) {
                object6 = object2;
                object7 = "system property";
            } else {
                list.add(Note.warn("Ignoring 'appid' system property, have appid via '" + (String)object7 + "'"));
            }
        }
        if (!StringUtil.isBlank((String)(object3 = SysProps.appBase()))) {
            if (object8 == null) {
                object8 = object3;
                object9 = "system property";
            } else {
                list.add(Note.warn("Ignoring 'appbase' system property, have appbase via '" + (String)object9 + "'"));
            }
        }
        if (!StringUtil.isBlank((String)(object3 = ((String[])object).length > 0 ? object[0] : null))) {
            if (object4 == null) {
                object4 = object3;
                object5 = "command line";
            } else {
                list.add(Note.warn("Ignoring 'appdir' command line arg, have appdir via '" + (String)object5 + "'"));
            }
        }
        Object object10 = object3 = ((String[])object).length > 1 ? object[1] : null;
        if (!StringUtil.isBlank((String)object2)) {
            if (object6 == null) {
                object6 = object3;
                object7 = "command line";
            } else {
                list.add(Note.warn("Ignoring 'appid' command line arg, have appid via '" + (String)object7 + "'"));
            }
        }
        if (object4 == null) {
            return null;
        }
        object3 = new File((String)object4);
        if (!((File)object3).exists() || !((File)object3).isDirectory()) {
            list.add(Note.error("Invalid appdir '" + (String)object4 + "'."));
            return null;
        }
        list.add(Note.info("Using appdir from " + (String)object5 + ": " + (String)object4));
        if (object6 != null) {
            list.add(Note.info("Using appid from " + (String)object7 + ": " + (String)object6));
        }
        if (object8 != null) {
            list.add(Note.info("Using appbase from " + (String)object9 + ": " + (String)object8));
        }
        object = ((String[])object).length > 2 ? Arrays.asList(object).subList(2, ((String[])object).length) : Collections.emptyList();
        object4 = new File((File)object3, Digest.digestFile(2) + ".crt");
        object5 = new ArrayList();
        if (((File)object4).exists()) {
            try {
                object4 = new FileInputStream((File)object4);
                object7 = null;
                try {
                    object9 = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate((InputStream)object4);
                    object5.add(object9);
                }
                catch (Throwable throwable) {
                    try {
                        object9 = throwable;
                        object7 = throwable;
                        throw object9;
                    }
                    catch (Throwable throwable2) {
                        if (object7 != null) {
                            try {
                                ((FileInputStream)object4).close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object7).addSuppressed(throwable3);
                            }
                        } else {
                            ((FileInputStream)object4).close();
                        }
                        throw throwable2;
                    }
                }
                ((FileInputStream)object4).close();
            }
            catch (Exception exception) {
                list.add(Note.error("Certificate error: " + exception.getMessage()));
            }
        }
        return new EnvConfig((File)object3, (String)object6, (String)object8, (List<Certificate>)object5, (List<String>)object);
    }

    public EnvConfig(File file) {
        this(file, null, null, Collections.emptyList(), Collections.emptyList());
    }

    private EnvConfig(File file, String string, String string2, List<Certificate> list, List<String> list2) {
        this.appDir = file;
        this.appId = string;
        this.appBase = string2;
        this.certs = list;
        this.appArgs = list2;
    }

    public static final class Note {
        public final Level level;
        public final String message;

        public static Note info(String string) {
            return new Note(Level.INFO, string);
        }

        public static Note warn(String string) {
            return new Note(Level.WARN, string);
        }

        public static Note error(String string) {
            return new Note(Level.ERROR, string);
        }

        public Note(Level level, String string) {
            this.level = level;
            this.message = string;
        }

        public static enum Level {
            INFO,
            WARN,
            ERROR;

        }
    }
}

