/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.classpath.ClassPath;
import com.threerings.getdown.classpath.ClassPaths;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.data.a;
import com.threerings.getdown.data.b;
import com.threerings.getdown.data.d;
import com.threerings.getdown.util.Base64;
import com.threerings.getdown.util.Color;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.ConnectionUtil;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.HostWhitelist;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.ProgressAggregator;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.Rectangle;
import com.threerings.getdown.util.StreamUtil;
import com.threerings.getdown.util.StringUtil;
import com.threerings.getdown.util.VersionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class Application {
    public static final String CONFIG_FILE = "getdown.txt";
    public static final String VERSION_FILE = "version.txt";
    public static final String PROP_PASSTHROUGH_PREFIX = "app.";
    public static final String SIGNATURE_SUFFIX = ".sig";
    public static final String MANIFEST_CLASS = "manifest";
    protected final EnvConfig _envc;
    protected File _config;
    protected Digest _digest;
    protected long _version = -1L;
    protected long _targetVersion = -1L;
    protected String _appbase;
    protected URL _vappbase;
    protected URL _latest;
    protected String _class;
    protected String _name;
    protected String _dockIconPath;
    protected boolean _strictComments;
    protected boolean _windebug;
    protected boolean _allowOffline;
    protected String _trackingURL;
    protected Set<Integer> _trackingPcts;
    protected String _trackingCookieName;
    protected String _trackingCookieProperty;
    protected String _trackingURLSuffix;
    protected String _trackingGAHash;
    protected long _trackingStart;
    protected int _trackingId;
    protected String _javaVersionProp = "java.version";
    protected String _javaVersionRegex = "(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(_\\d+)?)?)?";
    protected long _javaMinVersion;
    protected long _javaMaxVersion;
    protected boolean _javaExactVersionRequired;
    protected String _javaLocation;
    protected List<Resource> _codes = new ArrayList<Resource>();
    protected List<Resource> _resources = new ArrayList<Resource>();
    protected boolean _useCodeCache;
    protected int _codeCacheRetentionDays;
    protected Map<String, AuxGroup> _auxgroups = new HashMap<String, AuxGroup>();
    protected Map<String, Boolean> _auxactive = new HashMap<String, Boolean>();
    protected List<String> _jvmargs = new ArrayList<String>();
    protected List<String> _appargs = new ArrayList<String>();
    protected String[] _optimumJvmArgs;
    protected List<String> _txtJvmArgs = new ArrayList<String>();
    protected boolean _warnedAboutSetLastModified;
    protected FileLock _lock;
    protected FileChannel _lockChannel;
    protected Random _rando = new Random();
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final String ENV_VAR_PREFIX = "%ENV.";
    protected static final Pattern ENV_VAR_PATTERN = Pattern.compile("%ENV\\.(.*?)%");

    public Application(EnvConfig envConfig) {
        this._envc = envConfig;
        this._config = this.getLocalPath(envConfig.appDir, CONFIG_FILE);
    }

    public File getAppDir() {
        return this._envc.appDir;
    }

    public boolean useCodeCache() {
        return this._useCodeCache;
    }

    public int getCodeCacheRetentionDays() {
        return this._codeCacheRetentionDays;
    }

    public Resource getConfigResource() {
        try {
            return this.createResource(CONFIG_FILE, Resource.NORMAL);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid appbase '" + this._vappbase + "'.", exception);
        }
    }

    public List<Resource> getCodeResources() {
        return this._codes;
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    public String getDigest(Resource resource) {
        return this._digest.getDigest(resource);
    }

    public List<Resource> getAllActiveResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.addAll(this.getActiveCodeResources());
        arrayList.addAll(this.getActiveResources());
        return arrayList;
    }

    public AuxGroup getAuxGroup(String string) {
        return this._auxgroups.get(string);
    }

    public Iterable<AuxGroup> getAuxGroups() {
        return this._auxgroups.values();
    }

    public boolean isAuxGroupActive(String string) {
        Boolean bl = this._auxactive.get(string);
        if (bl == null) {
            bl = this.getLocalPath(string + ".dat").exists();
            this._auxactive.put(string, bl);
        }
        return bl;
    }

    public List<Resource> getActiveCodeResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.addAll(this.getCodeResources());
        for (AuxGroup auxGroup : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(auxGroup.name)) continue;
            arrayList.addAll(auxGroup.codes);
        }
        return arrayList;
    }

    public List<Resource> getActiveResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.addAll(this.getResources());
        for (AuxGroup auxGroup : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(auxGroup.name)) continue;
            arrayList.addAll(auxGroup.rsrcs);
        }
        return arrayList;
    }

    public Resource getPatchResource(String string) {
        if (this._targetVersion <= this._version) {
            Log.log.warning("Requested patch resource for up-to-date or non-versioned application", "cvers", this._version, "tvers", this._targetVersion);
            return null;
        }
        string = string == null ? "" : "-" + string;
        string = "patch" + string + this._version + ".dat";
        try {
            Application application = this;
            URL uRL = new URL(application.createVAppBase(application._targetVersion), Application.encodePath(string));
            return new Resource(string, uRL, this.getLocalPath(string), Resource.NORMAL);
        }
        catch (Exception exception) {
            Log.log.warning("Failed to create patch resource path", "pfile", string, "appbase", this._appbase, "tvers", this._targetVersion, "error", exception);
            return null;
        }
    }

    public Resource getJavaVMResource() {
        if (StringUtil.isBlank(this._javaLocation)) {
            return null;
        }
        String string = "java_vm.jar";
        try {
            Application application = this;
            URL uRL = new URL(application.createVAppBase(application._targetVersion), Application.encodePath(this._javaLocation));
            return new Resource(string, uRL, this.getLocalPath(string), EnumSet.of(Resource.Attr.UNPACK));
        }
        catch (Exception exception) {
            Log.log.warning("Failed to create VM resource", "vmfile", string, "appbase", this._appbase, "tvers", this._targetVersion, "javaloc", this._javaLocation, "error", exception);
            return null;
        }
    }

    public Resource getFullResource() {
        String string = "full";
        try {
            Application application = this;
            URL uRL = new URL(application.createVAppBase(application._targetVersion), Application.encodePath(string));
            return new Resource(string, uRL, this.getLocalPath(string), Resource.NORMAL);
        }
        catch (Exception exception) {
            Log.log.warning("Failed to create full resource path", "file", string, "appbase", this._appbase, "tvers", this._targetVersion, "error", exception);
            return null;
        }
    }

    public URL getTrackingURL(String string) {
        try {
            String string2 = this._trackingURLSuffix == null ? "" : this._trackingURLSuffix;
            String string3 = this.getGATrackingCode();
            if (this._trackingURL == null) {
                return null;
            }
            return HostWhitelist.verify(new URL(this._trackingURL + Application.encodePath(string + string2 + string3)));
        }
        catch (MalformedURLException malformedURLException) {
            Log.log.warning("Invalid tracking URL", "path", this._trackingURL, "event", string, "error", malformedURLException);
            return null;
        }
    }

    public URL getTrackingProgressURL(int n2) {
        if (this._trackingPcts == null || !this._trackingPcts.contains(n2)) {
            return null;
        }
        return this.getTrackingURL("pct" + n2);
    }

    public String getTrackingCookieName() {
        return this._trackingCookieName;
    }

    public String getTrackingCookieProperty() {
        return this._trackingCookieProperty;
    }

    /*
     * WARNING - void declaration
     */
    public UpdateInterface init(boolean bl) throws IOException {
        Config config = null;
        Object object = this._config;
        Config.ParseOpts object2 = Config.createOpts(bl);
        try {
            if (((File)object).exists()) {
                config = Config.parseConfig(this._config, object2);
            } else {
                object = this.getLocalPath("getdown.txt_old");
                if (((File)object).exists()) {
                    config = Config.parseConfig((File)object, object2);
                } else {
                    Log.log.info("Found no getdown.txt file", "appdir", this.getAppDir());
                }
            }
        }
        catch (Exception exception) {
            Log.log.warning("Failure reading config file", "file", config, exception);
        }
        if (config == null) {
            String string = this._envc.appBase;
            Log.log.info("Using 'appbase' from bootstrap config", "appbase", string);
            object = new HashMap<String, String>();
            object.put("appbase", string);
            config = new Config((Map<String, Object>)object);
        }
        this._appbase = config.getString("appbase");
        if (this._appbase == null) {
            throw new RuntimeException("m.missing_appbase");
        }
        this._appbase = SysProps.overrideAppbase(this._appbase);
        if (!this._appbase.endsWith("/")) {
            this._appbase = this._appbase + "/";
        }
        this._version = config.getLong("version", -1L);
        try {
            this._vappbase = this.createVAppBase(this._version);
        }
        catch (MalformedURLException malformedURLException) {
            object = MessageUtil.tcompose("m.invalid_appbase", this._appbase);
            throw (IOException)new IOException((String)object).initCause(malformedURLException);
        }
        String string = config.getString("latest");
        if (string != null) {
            if (string.startsWith(this._appbase)) {
                String string2 = this._appbase + string.substring(this._appbase.length());
            } else {
                String string3 = SysProps.replaceDomain(string);
            }
            try {
                void var1_11;
                this._latest = HostWhitelist.verify(new URL((String)var1_11));
            }
            catch (MalformedURLException malformedURLException) {
                Log.log.warning("Invalid URL for latest attribute.", malformedURLException);
            }
        }
        object = this._envc.appId == null ? "" : this._envc.appId + ".";
        this._class = config.getString("class");
        if (((String)object).length() > 0) {
            this._class = config.getString((String)object + "class", this._class);
        }
        if (this._class == null) {
            throw new IOException("m.missing_class");
        }
        this._strictComments = config.getBoolean("strict_comments");
        this._javaVersionProp = config.getString("java_version_prop", this._javaVersionProp);
        this._javaVersionRegex = config.getString("java_version_regex", this._javaVersionRegex);
        this._javaMinVersion = config.getLong("java_version", this._javaMinVersion);
        this._javaMinVersion = config.getLong("java_min_version", this._javaMinVersion);
        this._javaMaxVersion = config.getLong("java_max_version", this._javaMaxVersion);
        this._javaExactVersionRequired = config.getBoolean("java_exact_version_required");
        Object object3 = config.getRaw("java_location");
        if (object3 instanceof String) {
            this._javaLocation = (String)object3;
        }
        this._trackingURL = config.getString("tracking_url");
        String string4 = config.getString("tracking_percents");
        if (!StringUtil.isBlank(string4)) {
            this._trackingPcts = new HashSet<Integer>();
            for (int n2 : StringUtil.parseIntArray(string4)) {
                this._trackingPcts.add(n2);
            }
        } else if (!StringUtil.isBlank(this._trackingURL)) {
            this._trackingPcts = new HashSet<Integer>();
            this._trackingPcts.add(50);
        }
        this._trackingCookieName = config.getString("tracking_cookie_name");
        this._trackingCookieProperty = config.getString("tracking_cookie_property");
        this._trackingURLSuffix = config.getString("tracking_url_suffix");
        this._trackingGAHash = config.getString("tracking_ga_hash");
        this._codes.clear();
        this._resources.clear();
        this._auxgroups.clear();
        this._jvmargs.clear();
        this._appargs.clear();
        this._txtJvmArgs.clear();
        if (config.getMultiValue("code") == null && config.getMultiValue("ucode") == null) {
            throw new IOException("m.missing_code");
        }
        this.parseResources(config, "code", Resource.NORMAL, this._codes);
        this.parseResources(config, "ucode", Resource.UNPACK, this._codes);
        this.parseResources(config, "resource", Resource.NORMAL, this._resources);
        this.parseResources(config, "uresource", Resource.UNPACK, this._resources);
        this.parseResources(config, "xresource", Resource.EXEC, this._resources);
        for (String string5 : config.getList("auxgroups")) {
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            this.parseResources(config, string5 + ".code", Resource.NORMAL, arrayList);
            this.parseResources(config, string5 + ".ucode", Resource.UNPACK, arrayList);
            ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
            this.parseResources(config, string5 + ".resource", Resource.NORMAL, arrayList2);
            this.parseResources(config, string5 + ".uresource", Resource.UNPACK, arrayList2);
            this._auxgroups.put(string5, new AuxGroup(string5, arrayList, arrayList2));
        }
        String[] stringArray = config.getMultiValue("jvmarg");
        Application.addAll(stringArray, this._jvmargs);
        if (((String)object).length() > 0) {
            String[] stringArray2 = config.getMultiValue((String)object + "jvmarg");
            Application.addAll(stringArray2, this._jvmargs);
        }
        this._optimumJvmArgs = config.getMultiValue("optimum_jvmarg");
        String[] stringArray3 = config.getMultiValue((String)object + "apparg");
        Application.addAll(stringArray3, this._appargs);
        this._appargs.addAll(this._envc.appArgs);
        this.fillAssignmentListFromPairs("extra.txt", this._txtJvmArgs);
        this._allowOffline = config.getBoolean("allow_offline");
        this._windebug = this.getLocalPath("debug.txt").exists();
        this._useCodeCache = config.getBoolean("use_code_cache");
        this._codeCacheRetentionDays = config.getInt("code_cache_retention_days", 7);
        UpdateInterface updateInterface = new UpdateInterface(config);
        this._name = updateInterface.name;
        this._dockIconPath = config.getString("ui.mac_dock_icon");
        if (this._dockIconPath == null) {
            this._dockIconPath = "../desktop.icns";
        }
        return updateInterface;
    }

    protected void fillAssignmentListFromPairs(String object, List<String> list) {
        if (((File)(object = this.getLocalPath((String)object))).exists()) {
            try {
                Object object2 = Config.parsePairs((File)object, Config.createOpts(false));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    String[] stringArray = (String[])object2.next();
                    if (stringArray[1].length() == 0) {
                        list.add(stringArray[0]);
                        continue;
                    }
                    list.add(stringArray[0] + "=" + stringArray[1]);
                }
                return;
            }
            catch (Throwable throwable) {
                Log.log.warning("Failed to parse '" + object + "': " + throwable, new Object[0]);
            }
        }
    }

    public URL getRemoteURL(String string) throws MalformedURLException {
        return new URL(this._vappbase, Application.encodePath(string));
    }

    public File getLocalPath(String string) {
        Application application = this;
        return application.getLocalPath(application.getAppDir(), string);
    }

    public boolean haveValidJavaVersion() {
        if (this._javaMinVersion == 0L && this._javaMaxVersion == 0L) {
            return true;
        }
        try {
            boolean bl;
            long l2 = SysProps.parseJavaVersion(this._javaVersionProp, this._javaVersionRegex);
            Log.log.info("Checking Java version", "current", l2, "wantMin", this._javaMinVersion, "wantMax", this._javaMaxVersion);
            Comparable<Resource> comparable = this.getJavaVMResource();
            if (comparable != null && comparable.isMarkedValid()) {
                comparable = new File(this.getAppDir(), "java_vm");
                File file = new File((File)comparable, "release");
                if (!file.exists()) {
                    Log.log.warning("Unpacked JVM missing 'release' file. Assuming valid version.", new Object[0]);
                    return true;
                }
                long l3 = VersionUtil.readReleaseVersion(file, this._javaVersionRegex);
                if (l3 == 0L) {
                    Log.log.warning("Unable to read version from 'release' file. Assuming valid.", new Object[0]);
                    return true;
                }
                l2 = l3;
                Log.log.info("Checking version of unpacked JVM [vers=" + l2 + "].", new Object[0]);
            }
            if (this._javaExactVersionRequired) {
                if (l2 == this._javaMinVersion) {
                    return true;
                }
                Log.log.warning("An exact Java VM version is required.", "current", l2, "required", this._javaMinVersion);
                return false;
            }
            boolean bl2 = this._javaMinVersion == 0L || l2 >= this._javaMinVersion;
            boolean bl3 = bl = this._javaMaxVersion == 0L || l2 <= this._javaMaxVersion;
            return bl2 && bl;
        }
        catch (RuntimeException runtimeException) {
            Log.log.warning("Unable to parse VM version, hoping for the best", "error", runtimeException, "needed", this._javaMinVersion);
            return true;
        }
    }

    public boolean hasOptimumJvmArgs() {
        return this._optimumJvmArgs != null;
    }

    public boolean allowOffline() {
        return this._allowOffline;
    }

    public void attemptRecovery(StatusDisplay statusDisplay) throws IOException {
        statusDisplay.updateStatus("m.updating_metadata");
        this.downloadConfigFile();
    }

    public void updateMetadata() throws IOException {
        try {
            this._vappbase = this.createVAppBase(this._targetVersion);
        }
        catch (MalformedURLException malformedURLException) {
            String string = MessageUtil.tcompose("m.invalid_appbase", this._appbase);
            throw (IOException)new IOException(string).initCause(malformedURLException);
        }
        try {
            this.downloadDigestFiles();
            this.downloadConfigFile();
            return;
        }
        catch (IOException iOException) {
            if (this._allowOffline) {
                Log.log.warning("Failed to update digest files.  Attempting offline operaton.", iOException);
                if (!FileUtil.deleteHarder(this.getLocalPath(VERSION_FILE))) {
                    Log.log.warning("Deleting version.txt failed.  This probably isn't going to work.", new Object[0]);
                    return;
                }
            } else {
                throw iOException;
            }
            return;
        }
    }

    public Process createProcess(boolean bl) throws IOException {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(LaunchUtil.getJVMPath(this.getAppDir(), this._windebug || bl));
        boolean bl2 = MANIFEST_CLASS.equals(this._class);
        ClassPath classPath = ClassPaths.buildClassPath(this);
        if (!bl2) {
            arrayList.add("-classpath");
            arrayList.add(classPath.asArgumentString());
        }
        if (LaunchUtil.isMacOS()) {
            Application application = this;
            arrayList.add("-Xdock:icon=" + application.getLocalPath(application._dockIconPath).getAbsolutePath());
            arrayList.add("-Xdock:name=" + this._name);
        }
        if ((object = System.getProperty("http.proxyHost")) != null) {
            arrayList.add("-Dhttp.proxyHost=" + (String)object);
            arrayList.add("-Dhttp.proxyPort=" + System.getProperty("http.proxyPort"));
            arrayList.add("-Dhttps.proxyHost=" + (String)object);
            arrayList.add("-Dhttps.proxyPort=" + System.getProperty("http.proxyPort"));
        }
        arrayList.add("-Dcom.threerings.getdown=true");
        for (Map.Entry object2 : System.getProperties().entrySet()) {
            String string = (String)object2.getKey();
            if (!string.startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            string = string.substring(4);
            arrayList.add("-D" + string + "=" + object2.getValue());
        }
        for (String string : this._jvmargs) {
            arrayList.add(this.processArg(string));
        }
        if (bl && this._optimumJvmArgs != null) {
            object = this._optimumJvmArgs;
            int string = this._optimumJvmArgs.length;
            for (int i2 = 0; i2 < string; ++i2) {
                String string2 = object[i2];
                arrayList.add(this.processArg(string2));
            }
        }
        for (String objectArray : this._txtJvmArgs) {
            arrayList.add(this.processArg(objectArray));
        }
        if (bl2) {
            arrayList.add("-jar");
            arrayList.add(classPath.asArgumentString());
        } else {
            arrayList.add(this._class);
        }
        for (String string : this._appargs) {
            arrayList.add(this.processArg(string));
        }
        object = this.createEnvironment();
        ArrayList<String> arrayList2 = arrayList;
        Object[] objectArray = arrayList2.toArray(new String[arrayList2.size()]);
        Log.log.info("Running " + StringUtil.join(objectArray, "\n  "), new Object[0]);
        return Runtime.getRuntime().exec((String[])objectArray, (String[])object, this.getAppDir());
    }

    protected String[] createEnvironment() {
        Object[] objectArray = new ArrayList<String>();
        this.fillAssignmentListFromPairs("env.txt", (List<String>)objectArray);
        if (objectArray.isEmpty()) {
            Log.log.info("Didn't find any custom environment variables, not setting any.", new Object[0]);
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : objectArray) {
            arrayList.add(this.processArg(object));
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            arrayList.add(entry.getKey() + "=" + entry.getValue());
        }
        ArrayList<String> arrayList2 = arrayList;
        objectArray = arrayList2.toArray(new String[arrayList2.size()]);
        Log.log.info("Environment " + StringUtil.join(objectArray, "\n "), new Object[0]);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public void invokeDirect() throws IOException {
        void var4_12;
        Object object;
        void entry;
        Object object2 = ClassPaths.buildClassPath(this);
        object2 = ((ClassPath)object2).asUrls();
        a a2 = new a(this, (URL[])object2, ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(a2);
        Log.log.info("Configured URL class loader:", new Object[0]);
        int n2 = ((URL[])object2).length;
        boolean n22 = false;
        while (entry < n2) {
            object = object2[entry];
            Log.log.info("  " + object, new Object[0]);
            ++entry;
        }
        for (String string : this._jvmargs) {
            if (!string.startsWith("-D")) continue;
            int entry2 = (string = this.processArg(string.substring(2))).indexOf("=");
            if (entry2 == -1) {
                Log.log.warning("Bogus system property: '" + string + "'?", new Object[0]);
                continue;
            }
            System.setProperty(string.substring(0, entry2), string.substring(entry2 + 1));
        }
        object2 = new HashMap();
        for (Map.Entry<Object, Object> clazz : System.getProperties().entrySet()) {
            object = (String)clazz.getKey();
            if (!((String)object).startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            object = ((String)object).substring(4);
            object2.put(object, (String)clazz.getValue());
        }
        for (Map.Entry<Object, Object> exception : object2.entrySet()) {
            System.setProperty((String)exception.getKey(), (String)exception.getValue());
        }
        Iterator<Map.Entry<Object, Object>> iterator = new String[this._appargs.size()];
        boolean bl = false;
        while (var4_12 < ((Iterator<Map.Entry<Object, Object>>)iterator).length) {
            Application application = this;
            iterator[var4_12] = application.processArg(application._appargs.get((int)var4_12));
            ++var4_12;
        }
        try {
            Log.log.info("Loading " + this._class, new Object[0]);
            Class<?> clazz = a2.loadClass(this._class);
            object = clazz.getMethod("main", EMPTY_STRING_ARRAY.getClass());
            Log.log.info("Invoking main({" + StringUtil.join(iterator, ", ") + "})", new Object[0]);
            ((Method)object).invoke(null, iterator);
            return;
        }
        catch (Exception exception) {
            Log.log.warning("Failure invoking app main", exception);
            return;
        }
    }

    protected String processArg(String object) {
        object = ((String)object).replace("%APPDIR%", this.getAppDir().getAbsolutePath());
        if (((String)(object = ((String)object).replace("%VERSION%", String.valueOf(this._version)))).contains(ENV_VAR_PREFIX)) {
            StringBuffer stringBuffer = new StringBuffer();
            object = ENV_VAR_PATTERN.matcher((CharSequence)object);
            while (((Matcher)object).find()) {
                String string = ((Matcher)object).group(1);
                String string2 = System.getenv(string);
                ((Matcher)object).appendReplacement(stringBuffer, string2 == null ? "MISSING:" + string : string2);
            }
            ((Matcher)object).appendTail(stringBuffer);
            object = stringBuffer.toString();
        }
        return object;
    }

    /*
     * Exception decompiling
     */
    public boolean verifyMetadata(StatusDisplay var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void verifyResources(ProgressObserver object, int[] nArray, Set<Resource> set, Set<Resource> set2, Set<Resource> set3) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(SysProps.threadPoolSize());
        LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
        int[] nArray2 = new int[1];
        long l2 = System.currentTimeMillis();
        List<Resource> list = this.getAllActiveResources();
        long[] lArray = new long[list.size()];
        long l3 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = list.get(i2).getLocal().length();
            l3 += lArray[i2];
        }
        Object object2 = object;
        object = new ProgressAggregator(new b(this, linkedBlockingQueue, (ProgressObserver)object2), lArray);
        object2 = new ConcurrentSkipListSet<Resource>(set2);
        ConcurrentSkipListSet concurrentSkipListSet = new ConcurrentSkipListSet();
        ConcurrentSkipListSet concurrentSkipListSet2 = new ConcurrentSkipListSet();
        int n2 = 0;
        while (n2 < lArray.length) {
            Resource resource = list.get(n2);
            int n3 = n2++;
            executorService.execute(new d(this, resource, (ProgressAggregator)object, n3, nArray, concurrentSkipListSet2, (Set)object2, concurrentSkipListSet, linkedBlockingQueue, nArray2));
        }
        while (nArray2[0] < list.size()) {
            Runnable runnable = (Runnable)linkedBlockingQueue.poll(60L, TimeUnit.SECONDS);
            runnable.run();
        }
        set2.addAll((Collection<Resource>)object2);
        set3.addAll(concurrentSkipListSet);
        set.addAll(concurrentSkipListSet2);
        long l4 = System.currentTimeMillis();
        Log.log.info("Verified resources", "count", list.size(), "size", l3 / 1024L + "k", "duration", l4 - l2 + "ms");
    }

    private void verifyResource(Resource resource, ProgressObserver progressObserver, int[] nArray, Set<Resource> set, Set<Resource> set2, Set<Resource> set3) {
        if (resource.isMarkedValid()) {
            if (nArray != null) {
                nArray[0] = nArray[0] + 1;
            }
            progressObserver.progress(100);
            return;
        }
        try {
            if (this._digest.validateResource(resource, progressObserver)) {
                if (resource.getLocalNew().exists()) {
                    set2.add(resource);
                    return;
                }
                resource.applyAttrs();
                set.add(resource);
                resource.markAsValid();
                return;
            }
        }
        catch (Exception exception) {
            Log.log.info("Failure verifying resource. Requesting redownload...", "rsrc", resource, "error", exception);
        }
        finally {
            progressObserver.progress(100);
        }
        set3.add(resource);
    }

    public void unpackResources(ProgressObserver progressObserver, Set<Resource> object) throws InterruptedException {
        List<Resource> list = this.getActiveResources();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            Resource resource = object2.next();
            if (resource.shouldUnpack() && !object.contains(resource)) continue;
            object2.remove();
        }
        object2 = new long[list.size()];
        for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
            object2[i2] = list.get(i2).getLocal().length();
        }
        ProgressAggregator progressAggregator = new ProgressAggregator(progressObserver, (long[])object2);
        for (int i3 = 0; i3 < ((Object)object2).length; ++i3) {
            object = list.get(i3);
            ProgressObserver progressObserver2 = progressAggregator.startElement(i3);
            try {
                ((Resource)object).unpack();
            }
            catch (IOException iOException) {
                Log.log.warning("Failure unpacking resource", "rsrc", object, iOException);
            }
            progressObserver2.progress(100);
        }
    }

    public void clearValidationMarkers() {
        Application application = this;
        application.clearValidationMarkers(application.getAllActiveResources().iterator());
    }

    public long getVersion() {
        return this._version;
    }

    protected URL createVAppBase(long l2) throws MalformedURLException {
        String string = l2 < 0L ? this._appbase : this._appbase.replace("%VERSION%", "" + l2);
        return HostWhitelist.verify(new URL(string));
    }

    protected void clearValidationMarkers(Iterator<Resource> iterator) {
        while (iterator.hasNext()) {
            iterator.next().clearMarker();
        }
    }

    protected void downloadConfigFile() throws IOException {
        this.downloadControlFile(CONFIG_FILE, 0);
    }

    public synchronized boolean lockForUpdates() {
        if (this._lock != null && this._lock.isValid()) {
            return true;
        }
        try {
            this._lockChannel = new RandomAccessFile(this.getLocalPath("gettingdown.lock"), "rw").getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.log.warning("Unable to create lock file", "message", fileNotFoundException.getMessage(), fileNotFoundException);
            return false;
        }
        try {
            this._lock = this._lockChannel.tryLock();
        }
        catch (IOException iOException) {
            Log.log.warning("Unable to create lock", "message", iOException.getMessage(), iOException);
            return false;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            Log.log.warning("The lock is held elsewhere in this JVM", overlappingFileLockException);
            return false;
        }
        Log.log.info("Able to lock for updates: " + (this._lock != null), new Object[0]);
        return this._lock != null;
    }

    public synchronized void releaseLock() {
        if (this._lock != null) {
            Log.log.info("Releasing lock", new Object[0]);
            try {
                this._lock.release();
            }
            catch (IOException iOException) {
                Log.log.warning("Unable to release lock", "message", iOException.getMessage(), iOException);
            }
            try {
                this._lockChannel.close();
            }
            catch (IOException iOException) {
                Log.log.warning("Unable to close lock channel", "message", iOException.getMessage(), iOException);
            }
            this._lockChannel = null;
            this._lock = null;
        }
    }

    protected void downloadDigestFiles() throws IOException {
        for (int i2 = 1; i2 <= 2; ++i2) {
            this.downloadControlFile(Digest.digestFile(i2), i2);
        }
    }

    protected void downloadControlFile(String string, int n2) throws IOException {
        Serializable serializable;
        File file = this.downloadFile(string);
        if (n2 > 0) {
            if (this._envc.certs.isEmpty()) {
                Log.log.info("No signing certs, not verifying digest.txt", "path", string);
            } else {
                byte[] byArray;
                Object object;
                serializable = this.downloadFile(string + SIGNATURE_SUFFIX);
                try {
                    object = new FileInputStream((File)serializable);
                    Throwable throwable = null;
                    try {
                        byArray = StreamUtil.toByteArray((InputStream)object);
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable3 = throwable2;
                            throwable = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable != null) {
                                try {
                                    ((FileInputStream)object).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ((FileInputStream)object).close();
                            }
                            throw throwable4;
                        }
                    }
                    ((FileInputStream)object).close();
                }
                finally {
                    FileUtil.deleteHarder((File)serializable);
                }
                object = new byte[8192];
                int n3 = 0;
                for (Certificate certificate : this._envc.certs) {
                    try {
                        Object object2;
                        FileInputStream fileInputStream;
                        block31: {
                            int n4;
                            fileInputStream = new FileInputStream(file);
                            serializable = null;
                            object2 = Signature.getInstance(Digest.sigAlgorithm(n2));
                            ((Signature)object2).initVerify(certificate);
                            while ((n4 = fileInputStream.read((byte[])object)) != -1) {
                                ((Signature)object2).update((byte[])object, 0, n4);
                            }
                            if (((Signature)object2).verify(Base64.decode(byArray, 0))) break block31;
                            Log.log.info("Signature does not match", "cert", certificate.getPublicKey());
                            fileInputStream.close();
                            continue;
                        }
                        try {
                            Log.log.info("Signature matches", "cert", certificate.getPublicKey());
                            ++n3;
                        }
                        catch (Throwable throwable) {
                            try {
                                object2 = throwable;
                                serializable = throwable;
                                throw object2;
                            }
                            catch (Throwable throwable6) {
                                if (serializable != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable throwable7) {
                                        ((Throwable)serializable).addSuppressed(throwable7);
                                    }
                                } else {
                                    fileInputStream.close();
                                }
                                throw throwable6;
                            }
                        }
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        Log.log.warning("Failure validating signature of " + file + ": " + iOException, new Object[0]);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                    }
                }
                if (n3 == 0) {
                    FileUtil.deleteHarder(file);
                    throw new IOException("m.corrupt_digest_signature_error");
                }
            }
        }
        if (!FileUtil.renameTo(file, (File)(serializable = this.getLocalPath(string)))) {
            throw new IOException("Failed to rename(" + file + ", " + serializable + ")");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File downloadFile(String object) throws IOException {
        Object object2;
        File file = this.getLocalPath((String)object + "_new");
        try {
            object2 = this.getRemoteURL((String)object);
        }
        catch (Exception exception) {
            Log.log.warning("Requested to download invalid control file", "appbase", this._vappbase, "path", object, "error", exception);
            throw (IOException)new IOException("Invalid path '" + (String)object + "'.").initCause(exception);
        }
        Log.log.info("Attempting to refetch '" + (String)object + "' from '" + object2 + "'.", new Object[0]);
        object2 = ConnectionUtil.open((URL)object2, 0, 0);
        ((URLConnection)object2).setUseCaches(false);
        ((URLConnection)object2).setRequestProperty("Accept-Encoding", "gzip");
        object = ((URLConnection)object2).getInputStream();
        Throwable throwable = null;
        try {
            block23: {
                object2 = ((URLConnection)object2).getContentEncoding();
                boolean bl = "gzip".equalsIgnoreCase((String)object2);
                Object object3 = bl ? new GZIPInputStream((InputStream)object) : object;
                Throwable throwable2 = null;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    Throwable throwable3 = null;
                    try {
                        StreamUtil.copy((InputStream)object3, fileOutputStream);
                    }
                    catch (Throwable throwable4) {
                        try {
                            Throwable throwable5 = throwable4;
                            throwable3 = throwable4;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable3 == null) {
                                fileOutputStream.close();
                                throw throwable6;
                            }
                            try {
                                fileOutputStream.close();
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                                throw throwable6;
                            }
                        }
                    }
                    fileOutputStream.close();
                    if (object3 == null) break block23;
                }
                catch (Throwable throwable8) {
                    try {
                        Throwable throwable9 = throwable8;
                        throwable2 = throwable8;
                        throw throwable9;
                    }
                    catch (Throwable throwable10) {
                        if (object3 == null) throw throwable10;
                        if (throwable2 == null) {
                            ((InputStream)object3).close();
                            throw throwable10;
                        }
                        try {
                            ((InputStream)object3).close();
                            throw throwable10;
                        }
                        catch (Throwable throwable11) {
                            throwable2.addSuppressed(throwable11);
                            throw throwable10;
                        }
                    }
                }
                ((InputStream)object3).close();
            }
            if (object == null) return file;
        }
        catch (Throwable throwable12) {
            try {
                object2 = throwable12;
                throwable = throwable12;
                throw object2;
            }
            catch (Throwable throwable13) {
                if (object == null) throw throwable13;
                if (throwable == null) {
                    ((InputStream)object).close();
                    throw throwable13;
                }
                try {
                    ((InputStream)object).close();
                    throw throwable13;
                }
                catch (Throwable throwable14) {
                    throwable.addSuppressed(throwable14);
                    throw throwable13;
                }
            }
        }
        ((InputStream)object).close();
        return file;
    }

    protected Resource createResource(String string, EnumSet<Resource.Attr> enumSet) throws MalformedURLException {
        return new Resource(string, this.getRemoteURL(string), this.getLocalPath(string), enumSet);
    }

    protected static void addAll(String[] stringArray, List<String> list) {
        if (stringArray != null) {
            for (String string : stringArray) {
                list.add(string);
            }
        }
    }

    public static List<Integer> intsToList(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int n2 : nArray) {
            arrayList.add(n2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List<String> stringsToList(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    protected void parseResources(Config stringArray, String string, EnumSet<Resource.Attr> enumSet, List<Resource> list) {
        if ((stringArray = stringArray.getMultiValue(string)) == null) {
            return;
        }
        for (String string2 : stringArray) {
            try {
                list.add(this.createResource(string2, enumSet));
            }
            catch (Exception exception) {
                Log.log.warning("Invalid resource '" + string2 + "'. " + exception, new Object[0]);
            }
        }
    }

    protected String getGATrackingCode() {
        if (this._trackingGAHash == null) {
            return "";
        }
        long l2 = System.currentTimeMillis() / 1000L;
        if (this._trackingStart == 0L) {
            this._trackingStart = l2;
        }
        if (this._trackingId == 0) {
            this._trackingId = 100000000 + this._rando.nextInt(900000000);
        }
        StringBuilder stringBuilder = new StringBuilder("&utmcc=__utma%3D").append(this._trackingGAHash);
        stringBuilder.append(".").append(this._trackingId);
        stringBuilder.append(".").append(this._trackingStart).append(".").append(this._trackingStart);
        stringBuilder.append(".").append(l2).append(".1%3B%2B");
        stringBuilder.append("__utmz%3D").append(this._trackingGAHash).append(".");
        stringBuilder.append(this._trackingStart).append(".1.1.");
        stringBuilder.append("utmcsr%3D(direct)%7Cutmccn%3D(direct)%7Cutmcmd%3D(none)%3B");
        stringBuilder.append("&utmn=").append(this._rando.nextInt(1000000000));
        return stringBuilder.toString();
    }

    protected static String encodePath(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replace("%2F", "/").replace("+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.log.warning("Failed to URL encode " + string + ": " + unsupportedEncodingException, new Object[0]);
            return string;
        }
    }

    protected File getLocalPath(File file, String string) {
        return new File(file, string);
    }

    static /* synthetic */ void access$000(Application application, Resource resource, ProgressObserver progressObserver, int[] nArray, Set set, Set set2, Set set3) {
        application.verifyResource(resource, progressObserver, nArray, set, set2, set3);
    }

    public static class AuxGroup {
        public final String name;
        public final List<Resource> codes;
        public final List<Resource> rsrcs;

        public AuxGroup(String string, List<Resource> list, List<Resource> list2) {
            this.name = string;
            this.codes = Collections.unmodifiableList(list);
            this.rsrcs = Collections.unmodifiableList(list2);
        }
    }

    public static interface StatusDisplay {
        public void updateStatus(String var1);
    }

    public static final class UpdateInterface {
        public final String name;
        public final int background;
        public final List<String> rotatingBackgrounds;
        public final String errorBackground;
        public final List<String> iconImages;
        public final String backgroundImage;
        public final String progressImage;
        public final Rectangle progress;
        public final int progressText;
        public final int progressBar;
        public final Rectangle status;
        public final int statusText;
        public final int textShadow;
        public final String installError;
        public final Rectangle patchNotes;
        public final String patchNotesUrl;
        public final boolean hideDecorations;
        public final boolean hideProgressText;
        public final int minShowSeconds;
        public final Map<Step, List<Integer>> stepPercentages;

        public final String toString() {
            return "[name=" + this.name + ", bg=" + this.background + ", bg=" + this.backgroundImage + ", pi=" + this.progressImage + ", prect=" + this.progress + ", pt=" + this.progressText + ", pb=" + this.progressBar + ", srect=" + this.status + ", st=" + this.statusText + ", shadow=" + this.textShadow + ", err=" + this.installError + ", nrect=" + this.patchNotes + ", notes=" + this.patchNotesUrl + ", stepPercentages=" + this.stepPercentages + ", hideProgressText" + this.hideProgressText + ", minShow=" + this.minShowSeconds + "]";
        }

        public UpdateInterface(Config config) {
            this.name = config.getString("ui.name");
            this.progress = config.getRect("ui.progress", new Rectangle(5, 5, 300, 15));
            this.progressText = config.getColor("ui.progress_text", -16777216);
            this.hideProgressText = config.getBoolean("ui.hide_progress_text");
            this.minShowSeconds = config.getInt("ui.min_show_seconds", 5);
            this.progressBar = config.getColor("ui.progress_bar", 0x6699CC);
            this.status = config.getRect("ui.status", new Rectangle(5, 25, 500, 100));
            this.statusText = config.getColor("ui.status_text", -16777216);
            this.textShadow = config.getColor("ui.text_shadow", 0);
            this.hideDecorations = config.getBoolean("ui.hide_decorations");
            this.backgroundImage = config.getString("ui.background_image");
            int n2 = 0.5f < Color.brightness(this.progressText) ? -16777216 : -1;
            this.background = config.getColor("ui.background", n2);
            this.progressImage = config.getString("ui.progress_image");
            this.rotatingBackgrounds = Application.stringsToList(config.getMultiValue("ui.rotating_background"));
            this.iconImages = Application.stringsToList(config.getMultiValue("ui.icon"));
            this.errorBackground = config.getString("ui.error_background");
            Object object = config.getUrl("ui.install_error", null);
            this.installError = object == null ? "m.default_install_error" : MessageUtil.taint(object);
            this.patchNotes = config.getRect("ui.patch_notes", new Rectangle(5, 50, 112, 26));
            this.patchNotesUrl = config.getUrl("ui.patch_notes_url", null);
            object = new EnumMap(Step.class);
            Step[] stepArray = Step.values();
            int n3 = stepArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Step step;
                Step step2 = step = stepArray[i2];
                ((EnumMap)object).put(step2, step2.defaultPercents);
            }
            for (Step step : Step.values()) {
                String string = config.getString("ui.percents." + step.name());
                if (string == null) continue;
                try {
                    ((EnumMap)object).put(step, Application.intsToList(StringUtil.parseIntArray(string)));
                }
                catch (Exception exception) {
                    Log.log.warning("Failed to parse percentages for " + (Object)((Object)step) + ": " + string, new Object[0]);
                }
            }
            this.stepPercentages = Collections.unmodifiableMap(object);
        }

        public static enum Step {
            UPDATE_JAVA(10),
            VERIFY_METADATA(15, 65, 95),
            DOWNLOAD(40),
            PATCH(60),
            VERIFY_RESOURCES(70, 97),
            REDOWNLOAD_RESOURCES(90),
            UNPACK(98),
            LAUNCH(99);

            public final List<Integer> defaultPercents;

            private Step(int ... nArray) {
                this.defaultPercents = Application.intsToList(nArray);
            }
        }
    }
}

