/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.Log;
import com.threerings.getdown.tools.JarDiffPatcher;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Patcher {
    public static final String CREATE = ".create";
    public static final String PATCH = ".patch";
    public static final String DELETE = ".delete";
    protected ProgressObserver _obs;
    protected long _complete;
    protected long _plength;
    protected byte[] _buffer;
    protected static final int COPY_BUFFER_SIZE = 4096;

    public void patch(File appdir, File patch, ProgressObserver obs) throws IOException {
        this._obs = obs;
        this._plength = patch.length();
        try (JarFile file = new JarFile(patch);){
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String path = entry.getName();
                long elength = entry.getCompressedSize();
                if (path.endsWith(CREATE)) {
                    path = this.strip(path, CREATE);
                    Log.log.info("Creating " + path + "...", new Object[0]);
                    this.createFile(file, entry, new File(appdir, path));
                } else if (path.endsWith(PATCH)) {
                    path = this.strip(path, PATCH);
                    Log.log.info("Patching " + path + "...", new Object[0]);
                    this.patchFile(file, entry, appdir, path);
                } else if (path.endsWith(DELETE)) {
                    path = this.strip(path, DELETE);
                    Log.log.info("Removing " + path + "...", new Object[0]);
                    File target = new File(appdir, path);
                    if (!FileUtil.deleteHarder(target)) {
                        Log.log.warning("Failure deleting '" + target + "'.", new Object[0]);
                    }
                } else {
                    Log.log.warning("Skipping bogus patch file entry: " + path, new Object[0]);
                }
                this._complete += elength;
            }
        }
    }

    protected String strip(String path, String suffix) {
        return path.substring(0, path.length() - suffix.length());
    }

    protected void createFile(JarFile file, ZipEntry entry, File target) {
        File pdir;
        if (this._buffer == null) {
            this._buffer = new byte[4096];
        }
        if (!(pdir = target.getParentFile()).exists() && !pdir.mkdirs()) {
            Log.log.warning("Failed to create parent for '" + target + "'.", new Object[0]);
        }
        try (InputStream in = file.getInputStream(entry);
             FileOutputStream fout = new FileOutputStream(target);){
            int read;
            int total = 0;
            while ((read = in.read(this._buffer)) != -1) {
                fout.write(this._buffer, 0, read);
                this.updateProgress(total += read);
            }
        }
        catch (IOException ioe) {
            Log.log.warning("Error creating '" + target + "': " + ioe, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void patchFile(JarFile file, ZipEntry entry, File appdir, String path) {
        File target = new File(appdir, path);
        File patch = new File(appdir, entry.getName());
        File otarget = new File(appdir, path + ".old");
        JarDiffPatcher patcher = null;
        FileUtil.deleteHarder(otarget);
        try (InputStream in = file.getInputStream(entry);
             FileOutputStream fout = new FileOutputStream(patch);){
            StreamUtil.copy(in, fout);
            StreamUtil.close(fout);
            if (!FileUtil.renameTo(target, otarget)) {
                Log.log.warning("Failed to .oldify '" + target + "'.", new Object[0]);
                return;
            }
            final long elength = entry.getCompressedSize();
            ProgressObserver obs = new ProgressObserver(){

                @Override
                public void progress(int percent) {
                    Patcher.this.updateProgress((int)((long)percent * elength / 100L));
                }
            };
            patcher = new JarDiffPatcher();
            patcher.patchJar(otarget.getPath(), patch.getPath(), target, obs);
        }
        catch (IOException ioe) {
            if (patcher == null) {
                Log.log.warning("Failed to write patch file '" + patch + "': " + ioe, new Object[0]);
            } else {
                Log.log.warning("Error patching '" + target + "': " + ioe, new Object[0]);
            }
        }
        finally {
            FileUtil.deleteHarder(patch);
            FileUtil.deleteHarder(otarget);
        }
    }

    protected void updateProgress(int progress) {
        if (this._obs != null) {
            this._obs.progress((int)(100L * (this._complete + (long)progress) / this._plength));
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: Patcher appdir patch_file");
            System.exit(-1);
        }
        Patcher patcher = new Patcher();
        try {
            patcher.patch(new File(args[0]), new File(args[1]), null);
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe.getMessage());
            System.exit(-1);
        }
    }
}

