/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.net;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.net.DownloadAbortedException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class Downloader
extends Thread {
    protected Collection<Resource> _resources;
    protected Map<Resource, Long> _sizes = new HashMap<Resource, Long>();
    protected Map<Resource, Long> _downloaded = new HashMap<Resource, Long>();
    protected Observer _obs;
    protected byte[] _buffer = new byte[4096];
    protected long _start;
    protected long _bytesPerSecond;
    protected long _lastUpdate;
    protected boolean _complete;
    protected static final long UPDATE_DELAY = 500L;

    public Downloader(Collection<Resource> resources, Observer obs) {
        super("Downloader");
        this._resources = resources;
        this._obs = obs;
    }

    @Override
    public void run() {
        this.download();
    }

    public boolean download() {
        Resource current = null;
        try {
            if (this._obs != null) {
                this._obs.resolvingDownloads();
            }
            for (Resource resource : this._resources) {
                this.discoverSize(resource);
            }
            long totalSize = Downloader.sum(this._sizes.values());
            Log.log.info("Downloading " + totalSize + " bytes...", new Object[0]);
            this._start = System.currentTimeMillis();
            for (Resource resource : this._resources) {
                this.download(resource);
            }
            if (this._obs != null && !this._complete && !this._obs.downloadProgress(100, 0L)) {
                return false;
            }
        }
        catch (DownloadAbortedException e) {
            return false;
        }
        catch (Exception e) {
            if (this._obs != null) {
                this._obs.downloadFailed(current, e);
            }
            Log.log.warning("Observer failed.", e);
        }
        return true;
    }

    protected void discoverSize(Resource rsrc) throws IOException {
        this._sizes.put(rsrc, Math.max(this.checkSize(rsrc), 0L));
    }

    protected abstract long checkSize(Resource var1) throws IOException;

    protected void download(Resource rsrc) throws IOException {
        File parent = new File(rsrc.getLocal().getParent());
        if (!parent.exists() && !parent.mkdirs()) {
            Log.log.warning("Failed to create target directory for resource '" + rsrc + "'. Download will certainly fail.", new Object[0]);
        }
        this.doDownload(rsrc);
    }

    protected void updateObserver(Resource rsrc, long currentSize, long actualSize) throws IOException {
        actualSize = Math.max(actualSize, this._sizes.get(rsrc));
        this._sizes.put(rsrc, actualSize);
        this._downloaded.put(rsrc, Math.min(actualSize, currentSize));
        long now = System.currentTimeMillis();
        if (now - this._lastUpdate >= 500L) {
            long remaining;
            this._lastUpdate = now;
            long downloaded = Downloader.sum(this._downloaded.values());
            long totalSize = Downloader.sum(this._sizes.values());
            long secs = (now - this._start) / 1000L;
            long bps = secs == 0L ? 0L : downloaded / secs;
            int pctdone = totalSize == 0L ? 0 : (int)((float)downloaded * 100.0f / (float)totalSize);
            long l = remaining = bps <= 0L || totalSize == 0L ? -1L : (totalSize - downloaded) / bps;
            if (pctdone < 100 || !this._complete) {
                boolean bl = this._complete = pctdone == 100;
                if (!this._obs.downloadProgress(pctdone, remaining)) {
                    throw new DownloadAbortedException();
                }
            }
        }
    }

    protected static long sum(Iterable<Long> values) {
        long acc = 0L;
        for (Long value : values) {
            acc += value.longValue();
        }
        return acc;
    }

    protected abstract void doDownload(Resource var1) throws IOException;

    public static interface Observer {
        public void resolvingDownloads();

        public boolean downloadProgress(int var1, long var2);

        public void downloadFailed(Resource var1, Exception var2);
    }
}

