/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Resource
implements Comparable<Resource> {
    public static final EnumSet<Attr> NORMAL = EnumSet.noneOf(Attr.class);
    public static final EnumSet<Attr> UNPACK = EnumSet.of(Attr.UNPACK);
    public static final EnumSet<Attr> EXEC = EnumSet.of(Attr.EXEC);
    protected String _path;
    protected URL _remote;
    protected File _local;
    protected File _localNew;
    protected File _marker;
    protected File _unpacked;
    protected EnumSet<Attr> _attrs;
    protected boolean _isJar;
    protected boolean _isPacked200Jar;
    protected static final Comparator<JarEntry> ENTRY_COMP = new Comparator<JarEntry>(){

        @Override
        public int compare(JarEntry e1, JarEntry e2) {
            return e1.getName().compareTo(e2.getName());
        }
    };
    protected static final int DIGEST_BUFFER_SIZE = 5125;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeDigest(int version, File target, MessageDigest md, ProgressObserver obs) throws IOException {
        block41: {
            byte[] buffer;
            block42: {
                File tmpJarFile;
                block40: {
                    md.reset();
                    buffer = new byte[5125];
                    boolean isJar = Resource.isJar(target.getPath());
                    boolean isPacked200Jar = Resource.isPacked200Jar(target.getPath());
                    if (!isJar && !isPacked200Jar) break block42;
                    tmpJarFile = null;
                    JarFile jar = null;
                    try {
                        if (isPacked200Jar) {
                            tmpJarFile = new File(target.getPath() + ".tmp");
                            FileUtil.unpackPacked200Jar(target, tmpJarFile);
                            jar = new JarFile(tmpJarFile);
                        } else {
                            jar = new JarFile(target);
                        }
                        ArrayList<JarEntry> entries = Collections.list(jar.entries());
                        Collections.sort(entries, ENTRY_COMP);
                        int eidx = 0;
                        for (JarEntry entry : entries) {
                            if (version < 2 && entry.getName().startsWith("META-INF")) {
                                Resource.updateProgress(obs, eidx, entries.size());
                                continue;
                            }
                            try (InputStream in = jar.getInputStream(entry);){
                                int read;
                                while ((read = in.read(buffer)) != -1) {
                                    md.update(buffer, 0, read);
                                }
                            }
                            Resource.updateProgress(obs, eidx, entries.size());
                        }
                        if (jar == null) break block40;
                    }
                    catch (Throwable throwable) {
                        if (jar != null) {
                            try {
                                jar.close();
                            }
                            catch (IOException ioe) {
                                Log.log.warning("Error closing jar", "path", target, "jar", jar, "error", ioe);
                            }
                        }
                        if (tmpJarFile != null) {
                            FileUtil.deleteHarder(tmpJarFile);
                        }
                        throw throwable;
                    }
                    try {
                        jar.close();
                    }
                    catch (IOException ioe) {
                        Log.log.warning("Error closing jar", "path", target, "jar", jar, "error", ioe);
                    }
                }
                if (tmpJarFile != null) {
                    FileUtil.deleteHarder(tmpJarFile);
                }
                break block41;
            }
            long totalSize = target.length();
            long position = 0L;
            try (FileInputStream fin = new FileInputStream(target);){
                int read;
                while ((read = fin.read(buffer)) != -1) {
                    md.update(buffer, 0, read);
                    Resource.updateProgress(obs, position += (long)read, totalSize);
                }
            }
        }
        return StringUtil.hexlate(md.digest());
    }

    public Resource(String path, URL remote, File local, EnumSet<Attr> attrs) {
        this._path = path;
        this._remote = remote;
        this._local = local;
        this._localNew = new File(local.toString() + "_new");
        String lpath = this._local.getPath();
        this._marker = new File(lpath + "v");
        this._attrs = attrs;
        this._isJar = Resource.isJar(lpath);
        this._isPacked200Jar = Resource.isPacked200Jar(lpath);
        boolean unpack = attrs.contains((Object)Attr.UNPACK);
        if (unpack && this._isJar) {
            this._unpacked = this._local.getParentFile();
        } else if (unpack && this._isPacked200Jar) {
            String dotJar = ".jar";
            String lname = this._local.getName();
            String uname = lname.substring(0, lname.lastIndexOf(dotJar) + dotJar.length());
            this._unpacked = new File(this._local.getParent(), uname);
        }
    }

    public String getPath() {
        return this._path;
    }

    public File getLocal() {
        return this._local;
    }

    public File getLocalNew() {
        return this._localNew;
    }

    public File getUnpacked() {
        return this._unpacked;
    }

    public File getFinalTarget() {
        return this.shouldUnpack() ? this.getUnpacked() : this.getLocal();
    }

    public URL getRemote() {
        return this._remote;
    }

    public boolean shouldUnpack() {
        return this._attrs.contains((Object)Attr.UNPACK) && !SysProps.noUnpack();
    }

    public String computeDigest(int version, MessageDigest md, ProgressObserver obs) throws IOException {
        File file = this._local.toString().toLowerCase(Locale.ROOT).endsWith("getdown.txt") ? this._local : (this._localNew.exists() ? this._localNew : this._local);
        return Resource.computeDigest(version, file, md, obs);
    }

    public boolean isMarkedValid() {
        if (!this._local.exists()) {
            this.clearMarker();
            return false;
        }
        return this._marker.exists();
    }

    public void markAsValid() throws IOException {
        this._marker.createNewFile();
    }

    public void clearMarker() {
        if (this._marker.exists() && !FileUtil.deleteHarder(this._marker)) {
            Log.log.warning("Failed to erase marker file '" + this._marker + "'.", new Object[0]);
        }
    }

    public void install() throws IOException {
        File source = this.getLocalNew();
        File dest = this.getLocal();
        Log.log.info("- " + source, new Object[0]);
        if (!FileUtil.renameTo(source, dest)) {
            throw new IOException("Failed to rename " + source + " to " + dest);
        }
        this.applyAttrs();
        this.markAsValid();
    }

    public void unpack() throws IOException {
        if (!this._isJar && !this._isPacked200Jar) {
            throw new IOException("Requested to unpack non-jar file '" + this._local + "'.");
        }
        if (this._isJar) {
            try (JarFile jar = new JarFile(this._local);){
                FileUtil.unpackJar(jar, this._unpacked);
            }
        } else {
            FileUtil.unpackPacked200Jar(this._local, this._unpacked);
        }
    }

    public void applyAttrs() throws IOException {
        if (this.shouldUnpack()) {
            this.unpack();
        }
        if (this._attrs.contains((Object)Attr.EXEC)) {
            FileUtil.makeExecutable(this._local);
        }
    }

    public void erase() {
        this.clearMarker();
        if (this._local.exists() && !FileUtil.deleteHarder(this._local)) {
            Log.log.warning("Failed to erase resource '" + this._local + "'.", new Object[0]);
        }
    }

    @Override
    public int compareTo(Resource other) {
        return this._path.compareTo(other._path);
    }

    public boolean equals(Object other) {
        if (other instanceof Resource) {
            return this._path.equals(((Resource)other)._path);
        }
        return false;
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path;
    }

    protected static void updateProgress(ProgressObserver obs, long pos, long total) {
        if (obs != null) {
            obs.progress((int)(100L * pos / total));
        }
    }

    protected static boolean isJar(String path) {
        return path.endsWith(".jar") || path.endsWith(".jar_new");
    }

    protected static boolean isPacked200Jar(String path) {
        return path.endsWith(".jar.pack") || path.endsWith(".jar.pack_new") || path.endsWith(".jar.pack.gz") || path.endsWith(".jar.pack.gz_new");
    }

    public static enum Attr {
        UNPACK,
        EXEC;

    }
}

