/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class EnvConfig {
    public final File appDir;
    public final String appId;
    public final String appBase;
    public final List<Certificate> certs;
    public final List<String> appArgs;
    private static final String USER_HOME_KEY = "${user.home}";

    public static EnvConfig create(String[] argv, List<Note> notes) {
        String argvAppId;
        String argvAppDir;
        String spropsAppBase;
        String spropsAppId;
        String appDir = null;
        String appDirProv = null;
        String appId = null;
        String appIdProv = null;
        String appBase = null;
        String appBaseProv = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("bootstrap");
            if (bundle.containsKey("appdir")) {
                appDir = bundle.getString("appdir");
                File appDirFile = new File(appDir = appDir.replace(USER_HOME_KEY, System.getProperty("user.home")));
                if (!appDirFile.exists()) {
                    appDirFile.mkdirs();
                }
                appDirProv = "bootstrap.properties";
            }
            if (bundle.containsKey("appid")) {
                appId = bundle.getString("appid");
                appIdProv = "bootstrap.properties";
            }
            if (bundle.containsKey("appbase")) {
                appBase = bundle.getString("appbase");
                appBaseProv = "bootstrap.properties";
            }
        }
        catch (MissingResourceException bundle) {
            // empty catch block
        }
        String spropsAppDir = SysProps.appDir();
        if (!StringUtil.isBlank(spropsAppDir)) {
            if (appDir == null) {
                appDir = spropsAppDir;
                appDirProv = "system property";
            } else {
                notes.add(Note.warn("Ignoring 'appdir' system property, have appdir via '" + appDirProv + "'"));
            }
        }
        if (!StringUtil.isBlank(spropsAppId = SysProps.appId())) {
            if (appId == null) {
                appId = spropsAppId;
                appIdProv = "system property";
            } else {
                notes.add(Note.warn("Ignoring 'appid' system property, have appid via '" + appIdProv + "'"));
            }
        }
        if (!StringUtil.isBlank(spropsAppBase = SysProps.appBase())) {
            if (appBase == null) {
                appBase = spropsAppBase;
                appBaseProv = "system property";
            } else {
                notes.add(Note.warn("Ignoring 'appbase' system property, have appbase via '" + appBaseProv + "'"));
            }
        }
        String string = argvAppDir = argv.length > 0 ? argv[0] : null;
        if (!StringUtil.isBlank(argvAppDir)) {
            if (appDir == null) {
                appDir = argvAppDir;
                appDirProv = "command line";
            } else {
                notes.add(Note.warn("Ignoring 'appdir' command line arg, have appdir via '" + appDirProv + "'"));
            }
        }
        String string2 = argvAppId = argv.length > 1 ? argv[1] : null;
        if (!StringUtil.isBlank(spropsAppId)) {
            if (appId == null) {
                appId = argvAppId;
                appIdProv = "command line";
            } else {
                notes.add(Note.warn("Ignoring 'appid' command line arg, have appid via '" + appIdProv + "'"));
            }
        }
        if (appDir == null) {
            return null;
        }
        File appDirFile = new File(appDir);
        if (!appDirFile.exists() || !appDirFile.isDirectory()) {
            notes.add(Note.error("Invalid appdir '" + appDir + "'."));
            return null;
        }
        notes.add(Note.info("Using appdir from " + appDirProv + ": " + appDir));
        if (appId != null) {
            notes.add(Note.info("Using appid from " + appIdProv + ": " + appId));
        }
        if (appBase != null) {
            notes.add(Note.info("Using appbase from " + appBaseProv + ": " + appBase));
        }
        List<String> appArgs = argv.length > 2 ? Arrays.asList(argv).subList(2, argv.length) : Collections.emptyList();
        File crtFile = new File(appDirFile, Digest.digestFile(2) + ".crt");
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        if (crtFile.exists()) {
            try (FileInputStream fis = new FileInputStream(crtFile);){
                X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(fis);
                certs.add(certificate);
            }
            catch (Exception e) {
                notes.add(Note.error("Certificate error: " + e.getMessage()));
            }
        }
        return new EnvConfig(appDirFile, appId, appBase, certs, appArgs);
    }

    public EnvConfig(File appDir) {
        this(appDir, null, null, Collections.emptyList(), Collections.emptyList());
    }

    private EnvConfig(File appDir, String appId, String appBase, List<Certificate> certs, List<String> appArgs) {
        this.appDir = appDir;
        this.appId = appId;
        this.appBase = appBase;
        this.certs = certs;
        this.appArgs = appArgs;
    }

    public static final class Note {
        public final Level level;
        public final String message;

        public static Note info(String msg) {
            return new Note(Level.INFO, msg);
        }

        public static Note warn(String msg) {
            return new Note(Level.WARN, msg);
        }

        public static Note error(String msg) {
            return new Note(Level.ERROR, msg);
        }

        public Note(Level level, String message) {
            this.level = level;
            this.message = message;
        }

        public static enum Level {
            INFO,
            WARN,
            ERROR;

        }
    }
}

